<?php
/**
 * @author Ing. Gerardo Cordero
 * @desc Interfaz del servicio parametro clasificacion, este tiene la finalidad 
 *       de describir de manera abstracta los metodos que definen el comportamiento
 *       del servicio
 */
interface icmp_retencion 
{
			
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Funcion que se encarga de generar los comprobante de retencion 
	 * @param string $origenPan - origen del js (CREAR-EDITAR)
	 * @param string $as_mes - mes actual
	 * @param string $as_agno - año actual
	 * @param string $as_probendesde - rango desde de proveedor o beneficiario
	 * @param string $as_probenhasta - rango hasta de  proveedor o beneficiario
	 * @param string $as_tipproben - tipo (proveedor->P) o (beneficiario->B)
	 * @param string $aa_numcmp - tipo del comprobante (IVA-Municipales-1x1000)
	 * @param Json $objson - json con los datos de la interfaz
	 * @param Array $arrevento - arreglo con los datos del log
	 * @return Resulset Adodb $valido - numero que indica si el proceso fue efectivo, y $mensaje - mensaje a imprimir 
	 */
	public function procesar_comprobante_retencion($origenPan,$as_mes,$as_agno,$as_tipproben,$as_probendesde,$as_probenhasta,$aa_numcmp,$objson,$arrevento);	

}