<?php
$dirsrvscb = "";
$dirsrvscb = dirname(__FILE__);
$dirsrvscb = str_replace("\\","/",$dirsrvscb);
$dirsrvscb = str_replace("/modelo/servicio/scb","",$dirsrvscb); 
require_once ($dirsrvscb."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrvscb."/base/librerias/php/general/sigesp_lib_funciones.php");
require_once ($dirsrvscb."/modelo/servicio/scb/sigesp_srv_scb_ielimin_doc_no_conta.php");
require_once ($dirsrvscb."/modelo/servicio/sss/sigesp_srv_sss_evento.php");


/**
 * @author Ingeniero Domingo Calicchio
 * @desc clase que sirve a la pantalla parametro de clasificacion, esta implementa
 *       la logica del negocio y maneja los recursos de base de datos
 */
class servicioCheque implements ielimin_doc_no_conta 
{
	private $daoCheques;
	private $daoProcesar;
	private $daoRegistroEvento;
	private $daoRegistroFalla;
	private $conexionbd;
	public  $mensaje; 
	public  $valido; 
	
	public function servicioCheque() 
	{
		$this->daoCheques = null;
		$this->daoProcesar = null;
		$this->daoRegistroEvento = null;
		$this->daoRegistroFalla  = null;
		$this->mensaje = '';
		$this->valido = true;
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
	//	$this->conexionBaseDatos->debug=true;
	}
				
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()
	 */
	public function cargarDocumentos($codemp, $as_tipo, $as_fechadesde, $as_fechahasta, $as_documento, $as_filtro, $as_numcarta, $as_estatus)
	{		
		$ls_straux = "";
		
		switch ($as_filtro)
		{
			case 'CH':
				if ($as_estatus == 1)
				{
					if($as_fecha != "")
					{
						$as_fecha = convertirFechaBd($as_fecha);			
						$ls_straux = " AND fecmov='".$as_fecha."' ";
					}
					
					if($as_numdoc != "")
					{
						$ls_straux = $ls_straux." AND numdoc like '%".$as_numdoc."' ";
					}
					//-> CADENA SQL PARA CARGAR MONTOS ANULADOS 0 NO CONTABILIZADOS
					$cadenasql = " 	SELECT * ".
								 "  FROM scb_movbco ".
								 "  WHERE codemp='".$codemp."' ".
								 "	AND estmov='A' ".
								 "	AND codope='CH' ". 
								 "	AND monto=0 ".$ls_straux;
								 
					$conexionbd = ConexionBaseDatos::getInstanciaConexion();
					$resultado = $conexionbd->Execute ( $cadenasql );
					if ($resultado===false)
					{
						$mensaje .= '  ->'.$conexionbd->ErrorMsg();
					}
					return $resultado;
				}
				else
				{
					if (!empty($as_documento))
					{
						$ls_straux = " AND numdoc like '%".$as_documento."' ";
					}
					   
					switch ($as_tipo)
					{
						case 'P':
							$ls_straux = $ls_straux." AND tipo_destino='P'";
						break;
						
						case 'B':
							$ls_straux = $ls_straux." AND tipo_destino='B'";
						break;
					}	
			
					if (($as_fechadesde!="") && ($as_fechadesde!="01/01/1900"))
					{
						$as_fechadesde = convertirFechaBd($as_fechadesde);
						$ls_straux = $ls_straux." AND fecmov>='$as_fechadesde'";
					}
					
					if (($as_fechahasta!="") && ($as_fechahasta!="01/01/1900"))
					{
						$as_fechahasta = convertirFechaBd($as_fechahasta);
						$ls_straux = $ls_straux." AND fecmov<='$as_fechahasta'";
					}
					//-> CADENA SQL PARA CARGAR CHEQUES NO CONTABILIZADOS
					$cadenasql = "	SELECT 	numdoc, cod_pro, ced_bene, nomproben, fecmov, conmov, estmov, monto, codban, ctaban, ".
								 " 			codope, estcon ".
								 "	FROM scb_movbco ".
								 "	WHERE codemp='".$codemp."' ". 
								 "	AND (estmov='N' OR estmov='L') ".
								 "	AND codope='CH' $ls_straux ".
								 "	ORDER BY numdoc ASC";
				//	echo $cadenasql;
				//	break;			 
					$conexionbd = ConexionBaseDatos::getInstanciaConexion();
					$resultado = $conexionbd->Execute ( $cadenasql );
					if ($resultado===false)
					{
						$mensaje .= '  ->'.$conexionbd->ErrorMsg();
					}
					return $resultado;
				}
			break; //fin de Cheques
			
			case 'CO':
				if (!empty($as_documento))
				{
					$ls_straux = " AND numdoc like '%".$as_documento."' ";
				}
				
				if (!empty($as_numcarta))
				{
					$ls_straux = " AND numdoc like '%".$as_numcarta."' ";
				}
				
				if ($as_tipo=='P')
				   {
					 $ls_straux = " AND tipo_destino='P'";
				   }
				elseif($as_tipo=='B')
				   {
					 $ls_straux = " AND tipo_destino='B'";
				   } 
				   
				if(($as_fechadesde != "") && ($as_fechadesde != "01/01/1900"))
				{
					$as_fechadesde = convertirFechaBd($as_fechadesde);
					$ls_straux = $ls_straux." AND fecmov>='$as_fechadesde'";
				}
				
				if(($as_fechahasta != "") && ($as_fechahasta != "01/01/1900"))
				{
					$as_fechahasta = convertirFechaBd($as_fechahasta);
					$ls_straux = $ls_straux." AND fecmov<='$as_fechahasta'";
				}
				//-> CADENA SQL PARA CARGAR CARTAS ORDEN NO CONTABILIZADOS
				$cadenasql = "	SELECT	numdoc, cod_pro, ced_bene, nomproben, fecmov, estmov, monto, ".
							 "        	conmov , codban, ctaban, codope, numcarord, estcon ".
							 "	FROM scb_movbco ".
							 " 	WHERE codemp='".$codemp."' $ls_straux ". 
							 "	AND estmov='N' ".
							 "	AND codope='ND' ".
							 "	AND estbpd='T' ".
							 " 	ORDER BY numdoc asc ";
	//			echo $cadenasql;
	//			break;			 
				$conexionbd = ConexionBaseDatos::getInstanciaConexion();
				$resultado = $conexionbd->Execute ( $cadenasql );
				if ($resultado===false)
				{
					$mensaje .= '  ->'.$conexionbd->ErrorMsg();
				}
				return $resultado;
			break; //fin de Carta Orden
		}//Fin del switch
	}
	
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()
	 */
	public function procesarEliminacion($codemp, $as_numdoc, $as_codban, $as_ctaban, $as_codope, $as_estprosol, $as_estprogpago, $as_numcar, $as_filtro, $as_estmov, $as_estatus, $arrevento)
	{
	    $ls_codusu   = $_SESSION["la_logusr"];
		$resultado = 0;
		$valido = true;
		$filtro = $as_filtro;
		
		$this->daoProcesar = FabricaDao::CrearDAO("N","scb_movbco");
	//	$this->daoProcesar->setData($objson);
		$this->daoProcesar->codemp		 = $codemp;
		$this->daoProcesar->codusu       = $ls_codusu; 
		$this->daoProcesar->numdoc    	 = $as_numdoc; 
		$this->daoProcesar->codban       = $as_codban; 
		$this->daoProcesar->ctaban       = $as_ctaban; 
		$this->daoProcesar->codope       = $as_codope; 
		$this->daoProcesar->estprosol 	 = $as_estprosol;
		$this->daoProcesar->estprogpago  = $as_estprogpago;
		$this->daoProcesar->numcarord 	 = $as_numcar;
		
		//Iniciar transaccion
		DaoGenerico::iniciarTrans();
		
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];

		if ($as_estatus == 1)
		{
			if ($valido)	//-> Eliminacion de los detalles del movimiento
			{				
				//Creacion del Dao con la tabla y campos a eliminar. 
				$strPk = "codemp='{$codemp}' AND codban='{$as_codban}' AND ctaban='{$as_ctaban}' AND codope='{$as_codope}' AND numdoc='{$as_numdoc}' AND estmov<>'C' AND estmov<>'A' AND estmov<>'O'";
				$this->daoProcesar = FabricaDao::CrearDAO("C", "scb_movbco", '', $strPk);
				$resultado = $this->daoProcesar->eliminar();
				if ($resultado)
				{
					$servicioEvento->tipoevento=true;
					$servicioEvento->incluirEvento();
				}
				else
				{
					$valido=false;
					$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
					$servicioEvento->tipoevento=false;
					$servicioEvento->desevetra=$arrevento['desevetra'];
					$servicioEvento->incluirEvento();
				}
				unset($this->daoProcesar);
			}
			
			if ($valido)	//-> Eliminacion de lo detalles de fuente de financiamiento
			{
				//Creacion del Dao con la tabla y campos a eliminar. 
				$strPk = "codemp='{$codemp}' AND codban='{$as_codban}' AND ctaban='{$as_ctaban}' AND codope='{$as_codope}' AND numdoc='{$as_numdoc}' AND estmov='A'";
				$this->daoProcesar = FabricaDao::CrearDAO("C", "scb_movbco_fuefinanciamiento", '', $strPk);
				$resultado = $this->daoProcesar->eliminar();
				if ($resultado)
				{
					$servicioEvento->tipoevento=true;
					$servicioEvento->incluirEvento();
				}
				else
				{
					$valido=false;
					$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
					$servicioEvento->tipoevento=false;
					$servicioEvento->desevetra=$arrevento['desevetra'];
					$servicioEvento->incluirEvento();
				}
				unset($this->daoProcesar);
			}	

			if ($valido)	//-> Eliminacion del movimiento
			{				
				//Creacion del Dao con la tabla y campos a eliminar. 
				$strPk = "codemp='{$codemp}' AND codban='{$as_codban}' AND ctaban='{$as_ctaban}' AND codope='{$as_codope}' AND estmov='{$as_estmov}' AND numdoc='{$as_numdoc}'";
				$this->daoProcesar = FabricaDao::CrearDAO("C", "scb_movbco", '', $strPk);
				$resultado = $this->daoProcesar->eliminar();
				if ($resultado)
				{
					$servicioEvento->tipoevento=true;
					$servicioEvento->incluirEvento();
				}
				else
				{
					$valido=false;
					$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
					$servicioEvento->tipoevento=false;
					$servicioEvento->desevetra=$arrevento['desevetra'];
					$servicioEvento->incluirEvento();
				}
				unset($this->daoProcesar);
			}
			
			if (DaoGenerico::completarTrans()) 
			{
				$resultado = 1;
				$servicioEvento->tipoevento=true;
				$servicioEvento->incluirEvento(); 		
			}
			else
			{
				$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
				$servicioEvento->tipoevento=false;
				$servicioEvento->desevetra=$arrevento['desevetra'];
				$servicioEvento->incluirEvento();
			}
			  
			//liberando variables y retornando el resultado de la operacion
			unset($this->daoProcesar);	
			return $resultado;
		}
		else
		{
			switch ($as_filtro)
			{
				case 'CH':
					$cadenasql = "	SELECT numsol ". 
								 " 	FROM cxp_sol_banco ". 
								 "	WHERE codemp='".$codemp."' ".
								 "	AND codban='".$as_codban."' ". 
								 "	AND ctaban='".$as_ctaban."' ". 
								 "	AND numdoc='".$as_numdoc."' ". 
								 "	AND estmov='N'";
				//	echo $cadenasql;
				//	break; 		 
					$conexionbd = ConexionBaseDatos::getInstanciaConexion();
					$result = $conexionbd->Execute ( $cadenasql );
					if ($result===false)
					{
						$valido=false;
						$mensaje .= '  ->'.$conexionbd->ErrorMsg();
					}
					else
					{
						while(!$result->EOF)
						{
							$ls_numsol = $result->fields["numsol"];
							
							//Creacion del Dao con la tabla y campos a modificar.
							$strPk = "codemp='{$codemp}' AND numsol='{$ls_numsol}'";
							$this->daoProcesar = FabricaDao::CrearDAO("C", "scb_prog_pago", '', $strPk);
							$this->daoProcesar->estmov = 'P' ;
							$resultado = $this->daoProcesar->modificar();
							if ($resultado == 1)
							{
								$servicioEvento->tipoevento=true;
								$servicioEvento->incluirEvento();
							}
							else
							{
								$valido=false;
								$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
								$servicioEvento->tipoevento=false;
								$servicioEvento->desevetra=$arrevento['desevetra'];
								$servicioEvento->incluirEvento();
							}
							unset($this->daoProcesar);
							
							if ($valido)
							{
								//Creacion del Dao con la tabla y campos a modificar.
								$strPk = "codemp='{$codemp}' AND numsol='{$ls_numsol}'";
								$this->daoProcesar = FabricaDao::CrearDAO("C", "cxp_solicitudes", '', $strPk);
								$this->daoProcesar->estprosol = 'S' ;
								$resultado = $this->daoProcesar->modificar();
								if ($resultado == 1)
								{
									$servicioEvento->tipoevento=true;
									$servicioEvento->incluirEvento();
								}
								else
								{
									$valido=false;
									$arrevento ['desevetra'] = $this->daoProcesar2->ErrorMsg();
									$servicioEvento->tipoevento=false;
									$servicioEvento->desevetra=$arrevento['desevetra'];
									$servicioEvento->incluirEvento();
								}
								unset($this->daoProcesar);
							}	
							
							if ($valido)
							{
								//Creacion del Dao con la tabla y campos a eliminar.
								$strPk = "codemp='{$codemp}' AND codban='{$as_codban}' AND ctaban='{$as_ctaban}' AND codope='CH' AND numdoc='{$as_numdoc}'";
								$this->daoProcesar = FabricaDao::CrearDAO("C", "cxp_sol_banco", '', $strPk);
								$resultado = $this->daoProcesar->eliminar();
							//	var_dump($resultado);
								if ($resultado)
								{
									$servicioEvento->tipoevento=true;
									$servicioEvento->incluirEvento();
								}
								else
								{
									$valido=false;
									$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
									$servicioEvento->tipoevento=false;
									$servicioEvento->desevetra=$arrevento['desevetra'];
									$servicioEvento->incluirEvento();
								}
								unset($this->daoProcesar);
							}	
							$result->MoveNext();
						}
						
						if ($valido)	//-> Eliminacion de lo detalles de gasto
						{
							$cadenasql = " 	DELETE FROM scb_movbco_spg ".
										 "	WHERE codemp='".$codemp."' ". 
										 "	AND codban='".$as_codban."' ".
										 "	AND ctaban='".$as_ctaban."' ".
										 "	AND codope='CH' ".
										 "	AND numdoc='".$as_numdoc."' ". 
										 "	AND estmov='N'";
							
							$conexionbd = ConexionBaseDatos::getInstanciaConexion();
							$resultado = $conexionbd->Execute ( $cadenasql );
							if ($resultado===false)
							{
								$valido=false;
								$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
								$servicioEvento->tipoevento=false;
								$servicioEvento->desevetra=$arrevento['desevetra'];
								$servicioEvento->incluirEvento();
							}
							else
							{
								$servicioEvento->tipoevento=true;
								$servicioEvento->incluirEvento();
							}
						}	
						
						if ($valido)	//-> Eliminacion de lo detalles de contabilidad
						{
							$cadenasql = " 	DELETE FROM scb_movbco_scg ".
										 "	WHERE codemp='".$codemp."' ". 
										 "	AND codban='".$as_codban."' ".
										 "	AND ctaban='".$as_ctaban."' ".
										 "	AND codope='CH' ".
										 "	AND numdoc='".$as_numdoc."' ". 
										 "	AND estmov='N'";
							
							$conexionbd = ConexionBaseDatos::getInstanciaConexion();
							$resultado = $conexionbd->Execute ( $cadenasql );
							if ($resultado===false)
							{
								$valido=false;
								$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
								$servicioEvento->tipoevento=false;
								$servicioEvento->desevetra=$arrevento['desevetra'];
								$servicioEvento->incluirEvento();
							}
							else
							{
								$servicioEvento->tipoevento=true;
								$servicioEvento->incluirEvento();
							}
						}	
													
						if ($valido)	//-> Eliminacion de lo detalles de ingreso
						{
							//Creacion del Dao con la tabla y campos a eliminar. 
							$strPk = "codemp='{$codemp}' AND codban='{$as_codban}' AND ctaban='{$as_ctaban}' AND codope='CH' AND numdoc='{$as_numdoc}' AND estmov='N'";
							$this->daoProcesar = FabricaDao::CrearDAO("C", "scb_movbco_spi", '', $strPk);
							$resultado = $this->daoProcesar->eliminar();
							if ($resultado)
							{
								$servicioEvento->tipoevento=true;
								$servicioEvento->incluirEvento();
							}
							else
							{
								$valido=false;
								$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
								$servicioEvento->tipoevento=false;
								$servicioEvento->desevetra=$arrevento['desevetra'];
								$servicioEvento->incluirEvento();
							}
							unset($this->daoProcesar);
						}	
						
						if ($valido)	//-> Eliminacion de lo detalles de fuente de financiamiento
						{
							//Creacion del Dao con la tabla y campos a eliminar. 
							$strPk = "codemp='{$codemp}' AND codban='{$as_codban}' AND ctaban='{$as_ctaban}' AND codope='CH' AND numdoc='{$as_numdoc}' AND (estmov='N' OR estmov='L')";
							$this->daoProcesar = FabricaDao::CrearDAO("C", "scb_movbco_fuefinanciamiento", '', $strPk);
							$resultado = $this->daoProcesar->eliminar();
							if ($resultado)
							{
								$servicioEvento->tipoevento=true;
								$servicioEvento->incluirEvento();
							}
							else
							{
								$valido=false;
								$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
								$servicioEvento->tipoevento=false;
								$servicioEvento->desevetra=$arrevento['desevetra'];
								$servicioEvento->incluirEvento();
							}
							unset($this->daoProcesar);
						}	
						
						if ($valido)	//-> Eliminacion de anticipos
						{
							//Creacion del Dao con la tabla y campos a eliminar.
							$strPk = "codemp='{$codemp}' AND codban='{$as_codban}' AND ctaban='{$as_ctaban}' AND codope='CH' AND numdoc='{$as_numdoc}' AND estmov='N'";
							$this->daoProcesar = FabricaDao::CrearDAO("C", "scb_movbco_anticipo", '', $strPk);
							$resultado = $this->daoProcesar->eliminar();
							if ($resultado)
							{
								$servicioEvento->tipoevento=true;
								$servicioEvento->incluirEvento();
							}
							else
							{
								$valido=false;
								$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
								$servicioEvento->tipoevento=false;
								$servicioEvento->desevetra=$arrevento['desevetra'];
								$servicioEvento->incluirEvento();
							}
							unset($this->daoProcesar);
						}	
					
						if ($valido)	//-> Si el cheque es de amortizacion
						{
							$cadenasql = "	SELECT docant, monamo ".  
										 "	FROM scb_movbco ".
										 "  WHERE codemp='".$codemp."' ". 
										 "  AND codban='".$as_codban."' ".
										 "  AND ctaban='".$as_ctaban."' ". 
										 "  AND codope='CH' ".
										 "  AND numdoc='".$as_numdoc."' ".
										 "  AND (estmov='N')";
						//	echo $cadenasql;
						//	break; 			 
							$conexionbd = ConexionBaseDatos::getInstanciaConexion();
							$rs_data = $conexionbd->Execute ( $cadenasql );
							if($rs_data===false)
							{
								$valido=false;
								$mensaje .= '  ->'.$conexionbd->ErrorMsg();
							}
							else
							{
								while(!$rs_data->EOF)
								{					
									$ls_docant = $rs_data->fields["docant"];
									$ls_monamo = $rs_data->fields["monamo"];
									
									//Creacion del Dao con la tabla y campos a modificar.
									$strPk = "codemp='{$codemp}' AND numdoc='{$ls_docant}'";
									$this->daoProcesar = FabricaDao::CrearDAO("C", "scb_movbco_anticipo", '', $strPk);
									if($this->daoProcesar->numdoc=='')
									{
										$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
										$servicioEvento->tipoevento=false;
										$servicioEvento->desevetra=$arrevento['desevetra'];
										$servicioEvento->incluirEvento();
									}
									else
									{
										$this->daoProcesar->monamo = monamo - '{$ls_monamo}';
										$this->daoProcesar->monsal = monsal + '{$ls_monamo}';
										$resultado = $this->daoProcesar->modificar();
										if ($resultado == 1)
										{
											$servicioEvento->tipoevento=true;
											$servicioEvento->incluirEvento();
										}
										else
										{
											$valido=false;
											$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
											$servicioEvento->tipoevento=false;
											$servicioEvento->desevetra=$arrevento['desevetra'];
											$servicioEvento->incluirEvento();
										}
									}
									$rs_data->MoveNext();
								}
							}
							unset($this->daoProcesar);
						}			
				
						if ($valido)	//-> Eliminacion del movimiento bancario
						{
							//Creacion del Dao con la tabla y campos a eliminar. 
							$strPk = "codemp='{$codemp}' AND codban='{$as_codban}' AND ctaban='{$as_ctaban}' AND codope='CH' AND numdoc='{$as_numdoc}' AND (estmov='N' OR estmov='L')";
							$this->daoProcesar = FabricaDao::CrearDAO("C", "scb_movbco", '', $strPk);
							$resultado = $this->daoProcesar->eliminar();
							if ($resultado)
							{
								$servicioEvento->tipoevento=true;
								$servicioEvento->incluirEvento();
							}
							else
							{
								$valido=false;
								$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
								$servicioEvento->tipoevento=false;
								$servicioEvento->desevetra=$arrevento['desevetra'];
								$servicioEvento->incluirEvento();
							}
						
							if ($valido)
							{
								$resultado = $this->liberarCheque($codemp, $as_codban, $as_ctaban, $as_numdoc);
							}
							unset($this->daoProcesar);
						}	
					}	
							
					if (DaoGenerico::completarTrans()) 
					{
						$resultado = 1;
						$servicioEvento->tipoevento=true;
						$servicioEvento->incluirEvento(); 		
					}
					else
					{
						$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
						$servicioEvento->tipoevento=false;
						$servicioEvento->desevetra=$arrevento['desevetra'];
						$servicioEvento->incluirEvento();
					}
					  
					//liberando variables y retornando el resultado de la operacion
					unset($this->daoProcesar);	
					return $resultado;
				break;
				
				case 'CO':
					$cadenasql = " 	SELECT	* ".
								 " 	FROM cxp_sol_banco ". 
								 "	WHERE codemp='".$codemp."' ". 
								 "	AND codban='".$as_codban."' ".
								 "	AND ctaban='".$as_ctaban."' ".
								 "	AND numdoc='".$as_numdoc."' ".
								 "	AND estmov='N'";
				//	echo $cadenasql;
				//	break; 		 
					$conexionbd = ConexionBaseDatos::getInstanciaConexion();
					$result = $conexionbd->Execute ( $cadenasql );
					if ($result===false)
					{
						$valido=false;
						$mensaje .= '  ->'.$conexionbd->ErrorMsg();
					}
					else
					{
						while(!$result->EOF)
						{
							$ls_numsol = $result->fields["numsol"];
							
							//Creacion del Dao con la tabla y campos a modificar.
							$strPk = "codemp='{$codemp}' AND numsol='{$ls_numsol}'";
							$this->daoProcesar = FabricaDao::CrearDAO("C", "scb_prog_pago", '', $strPk);
							$this->daoProcesar->estmov = $as_estprogpago;
							$resultado = $this->daoProcesar->modificar();
							if ($resultado == 1)
							{
								$servicioEvento->tipoevento=true;
								$servicioEvento->incluirEvento();
							}
	
							else
							{
								$valido=false;
								$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
								$servicioEvento->tipoevento=false;
								$servicioEvento->desevetra=$arrevento['desevetra'];
								$servicioEvento->incluirEvento();
							}
							unset($this->daoProcesar);
							
							if ($valido)
							{
								//Creacion del Dao con la tabla y campos a modificar.
								$strPk = "codemp='{$codemp}' AND numsol='{$ls_numsol}'";
								$this->daoProcesar = FabricaDao::CrearDAO("C", "cxp_solicitudes", '', $strPk);
								$this->daoProcesar->estprosol = $as_estprosol;
								$resultado = $this->daoProcesar->modificar();
								if ($resultado == 1)
								{
									$servicioEvento->tipoevento=true;
									$servicioEvento->incluirEvento();
								}
								else
								{
									$valido=false;
									$arrevento ['desevetra'] = $this->daoProcesar2->ErrorMsg();
									$servicioEvento->tipoevento=false;
									$servicioEvento->desevetra=$arrevento['desevetra'];
									$servicioEvento->incluirEvento();
								}
								unset($this->daoProcesar);
							}	
							$result->MoveNext();
						}
						
						if ($valido)	//-> Eliminacion registro de solbanco
						{
							//Creacion del Dao con la tabla y campos a eliminar.
							$strPk = "codemp='{$codemp}' AND codban='{$as_codban}' AND ctaban='{$as_ctaban}' AND codope='ND' AND numdoc='{$as_numdoc}'";
							$this->daoProcesar = FabricaDao::CrearDAO("C", "cxp_sol_banco", '', $strPk);
							$resultado = $this->daoProcesar->eliminar();
						//	var_dump($resultado);
							if ($resultado)
							{
								$servicioEvento->tipoevento=true;
								$servicioEvento->incluirEvento();
							}
							else
							{
								$valido=false;
								$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
								$servicioEvento->tipoevento=false;
								$servicioEvento->desevetra=$arrevento['desevetra'];
								$servicioEvento->incluirEvento();
							}
							unset($this->daoProcesar);
						}	
						
						if ($valido)	//-> Eliminacion de lo detalles de gasto
						{
							$cadenasql = " 	DELETE FROM scb_movbco_spg ".
										 "	WHERE codemp='".$codemp."' ". 
										 "	AND codban='".$as_codban."' ".
										 "	AND ctaban='".$as_ctaban."' ".
										 "	AND codope='ND' ".
										 "	AND numdoc='".$as_numdoc."' ". 
										 "	AND estmov='N'";
							
							$conexionbd = ConexionBaseDatos::getInstanciaConexion();
							$resultado = $conexionbd->Execute ( $cadenasql );
							if ($resultado===false)
							{
								$valido=false;
								$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
								$servicioEvento->tipoevento=false;
								$servicioEvento->desevetra=$arrevento['desevetra'];
								$servicioEvento->incluirEvento();
							}
							else
							{
								$servicioEvento->tipoevento=true;
								$servicioEvento->incluirEvento();
							}
						}	
						
						if ($valido)	//-> Eliminacion de lo detalles de contabilidad
						{
							$cadenasql = " 	DELETE FROM scb_movbco_scg ".
										 "	WHERE codemp='".$codemp."' ". 
										 "	AND codban='".$as_codban."' ".
										 "	AND ctaban='".$as_ctaban."' ".
										 "	AND codope='ND' ".
										 "	AND numdoc='".$as_numdoc."' ". 
										 "	AND estmov='N'";
							
							$conexionbd = ConexionBaseDatos::getInstanciaConexion();
							$resultado = $conexionbd->Execute ( $cadenasql );
							if ($resultado===false)
							{
								$valido=false;
								$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
								$servicioEvento->tipoevento=false;
								$servicioEvento->desevetra=$arrevento['desevetra'];
								$servicioEvento->incluirEvento();
							}
							else
							{
								$servicioEvento->tipoevento=true;
								$servicioEvento->incluirEvento();
							}
						}	
						
						if ($valido)	//-> Eliminacion de lo detalles de ingreso
						{
							//Creacion del Dao con la tabla y campos a eliminar. 
							$strPk = "codemp='{$codemp}' AND codban='{$as_codban}' AND ctaban='{$as_ctaban}' AND codope='ND' AND numdoc='{$as_numdoc}' AND estmov='N'";
							$this->daoProcesar = FabricaDao::CrearDAO("C", "scb_movbco_spi", '', $strPk);
							$resultado = $this->daoProcesar->eliminar();
							if ($resultado)
							{
								$servicioEvento->tipoevento=true;
								$servicioEvento->incluirEvento();
							}
							else
							{
								$valido=false;
								$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
								$servicioEvento->tipoevento=false;
								$servicioEvento->desevetra=$arrevento['desevetra'];
								$servicioEvento->incluirEvento();
							}
							unset($this->daoProcesar);
						}	
						
						if ($valido)	//-> Eliminacion del detalle de movimiento de banco
						{
							//Creacion del Dao con la tabla y campos a eliminar. 
							$strPk = "codemp='{$codemp}' AND codban='{$as_codban}' AND ctaban='{$as_ctaban}' AND codope='ND' AND numdoc='{$as_numdoc}' AND estmov='N'";
							$this->daoProcesar = FabricaDao::CrearDAO("C", "scb_dt_movbco", '', $strPk);
							$resultado = $this->daoProcesar->eliminar();
							if ($resultado)
							{
								$servicioEvento->tipoevento=true;
								$servicioEvento->incluirEvento();
							}
							else
							{
								$valido=false;
								$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
								$servicioEvento->tipoevento=false;
								$servicioEvento->desevetra=$arrevento['desevetra'];
								$servicioEvento->incluirEvento();
							}
							unset($this->daoProcesar);
						}	
						
						if ($valido)	//-> Eliminacion de lo detalles de fuente de financiamiento
						{
							//Creacion del Dao con la tabla y campos a eliminar. 
							$strPk = "codemp='{$codemp}' AND codban='{$as_codban}' AND ctaban='{$as_ctaban}' AND codope='ND' AND numdoc='{$as_numdoc}' AND estmov='N'";
							$this->daoProcesar = FabricaDao::CrearDAO("C", "scb_movbco_fuefinanciamiento", '', $strPk);
							$resultado = $this->daoProcesar->eliminar();
							if ($resultado)
							{
								$servicioEvento->tipoevento=true;
								$servicioEvento->incluirEvento();
							}
							else
							{
								$valido=false;
								$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
								$servicioEvento->tipoevento=false;
								$servicioEvento->desevetra=$arrevento['desevetra'];
								$servicioEvento->incluirEvento();
							}
							unset($this->daoProcesar);
						}	
									
						if ($valido)	//-> Eliminacion del movimiento bancario
						{
							//Creacion del Dao con la tabla y campos a eliminar. 
					//		print("PASO ---> VALIDO ---> ");
					//		return false;
							$strPk = "codemp='{$codemp}' AND codban='{$as_codban}' AND ctaban='{$as_ctaban}' AND codope='ND' AND estbpd='T' AND numdoc='{$as_numdoc}' AND estmov='N' AND numcarord='{$as_numcar}'";
							$this->daoProcesar = FabricaDao::CrearDAO("C", "scb_movbco", '', $strPk);
							$resultado = $this->daoProcesar->eliminar();
					//		var_dump($resultado);
							if ($resultado)
							{
								$servicioEvento->tipoevento=true;
								$servicioEvento->incluirEvento();
							}
							else
							{
								$valido=false;
								$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
								$servicioEvento->tipoevento=false;
								$servicioEvento->desevetra=$arrevento['desevetra'];
								$servicioEvento->incluirEvento();
							}
							unset($this->daoProcesar);
						}	
					}	
							
					if (DaoGenerico::completarTrans()) 
					{
						$resultado = 1;
						$servicioEvento->tipoevento=true;
						$servicioEvento->incluirEvento(); 		
					}
					else
					{
						$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
						$servicioEvento->tipoevento=false;
						$servicioEvento->desevetra=$arrevento['desevetra'];
						$servicioEvento->incluirEvento();
					}
					  
					//liberando variables y retornando el resultado de la operacion
					unset($this->daoProcesar);	
					return $resultado;
				break;
			}	
		}
	}		

	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()
	 */
	public function liberarCheque($as_codemp, $as_codban, $as_ctaban, $as_numche)
	{
		///////////////////////////////////////////////////////////////////////////////////////////////////////
		//	   Function: uf_liberar_cheque
		//       Access: public
		//	    Returns: Boolean Retorna si proceso correctamente.
		//	Description: Funcion que se encarga de actualizar el estatus Emitido (1) a Disponible ->(0), 
		//               al cheque perteneciente a esa chequera del banco y la cuenta que vienen por parametro.	
		///////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valido = true;
		
		$cadenasql = "	UPDATE scb_cheques ".
					 "	SET estche=0 ".
					 "	WHERE codemp='".$as_codemp."' ".
					 "	AND codban='".$as_codban."' ".
					 "	AND ctaban='".$as_ctaban."' ".
					 "	AND numche='".$as_numche."'";
					 
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$respuesta = $conexionbd->Execute ( $cadenasql );
		if ($respuesta===false)
		{
			$lb_valido=false;
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
		}
		return $lb_valido;
	}
	
}
?>