<?php
$dirsrvscb = "";
$dirsrvscb = dirname(__FILE__);
$dirsrvscb = str_replace("\\","/",$dirsrvscb);
$dirsrvscb = str_replace("/modelo/servicio/scb","",$dirsrvscb); 
require_once ($dirsrvscb."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrvscb.'/base/librerias/php/general/sigesp_lib_funciones.php');
require_once ($dirsrvscb."/modelo/servicio/scb/sigesp_srv_scb_idesprogpago.php");
require_once ($dirsrvscb."/modelo/servicio/sss/sigesp_srv_sss_evento.php");


/**
 * @author Ingeniero Domingo Calicchio
 * @desc clase que sirve a la pantalla parametro de clasificacion, esta implementa
 *       la logica del negocio y maneja los recursos de base de datos
 */
class servicioBanco implements idesprogpago {
	private $daoBanco;
	private $daoDesprogramacion;
	private $daoRegistroEvento;
	private $daoRegistroFalla;
	public  $mensaje; 
	public  $valido; 
	
	public function servicioBanco() {
		$this->daoBanco = null;
		$this->daoDesprogramacion = null;
		$this->daoRegistroEvento = null;
		$this->daoRegistroFalla  = null;
		$this->mensaje = '';
		$this->valido = true;
		//$this->conexionBaseDatos->debug=true;
	}
	
	
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()
	 */
	public function buscarSolicitudesDes($codemp, $tipproben, $codban, $ctaban, $fecmov)
	{
	  $arrSolicitudes=array();
	  $ls_cadaux = "";
	  $fecmov = convertirFechaBd($fecmov);
	  if ($tipproben=='P')
	  {
		  $ls_tabla  = "rpc_proveedor";
		  $ls_campo  = "cod_pro";
		  $ls_sqlaux = ',rpc_proveedor.nompro as nomproben';
		  $ls_straux = "AND cxp_solicitudes.codemp = rpc_proveedor.codemp AND cxp_solicitudes.cod_pro = rpc_proveedor.cod_pro";
	 }
	  elseif($tipproben=='B')
	 {
	   	$ls_tabla  = "rpc_beneficiario";
	   	$ls_sqlaux = ',rpc_beneficiario.nombene, rpc_beneficiario.apebene';
	   	$ls_straux = "AND cxp_solicitudes.codemp = rpc_beneficiario.codemp AND cxp_solicitudes.ced_bene = rpc_beneficiario.ced_bene";
	 }																		   
	    //Condicion despues de $ls_tabla ---->   cxp_rd.procede as procede, !!!No Eliminar!!!
		$cadenasql = "SELECT cxp_solicitudes.numsol as numsol, ".
		             "  cxp_solicitudes.cod_pro as codproben, ".
					 "	cxp_solicitudes.consol as consol, ".
		             "  cxp_solicitudes.estprosol as estprosol, ".
					 "	cxp_solicitudes.monsol as monsol, ".
					 "	cxp_solicitudes.obssol as obssol, ".
					 "	scb_prog_pago.fecpropag as fecpropag, ".
					 "	scb_prog_pago.codban as codban, ".
					 "	scb_prog_pago.ctaban as ctaban, ".
					 "	scb_banco.nomban as nomban, ".
					 "	scb_ctabanco.dencta as dencta $ls_sqlaux, ".
					 "   (SELECT count(cxp_rd_spg.spg_cuenta) ".
				 	 "	  FROM cxp_rd_spg, cxp_rd, cxp_dt_solicitudes ".
					 "	 WHERE cxp_solicitudes.codemp=cxp_dt_solicitudes.codemp ".
					 "	   AND cxp_solicitudes.numsol=cxp_dt_solicitudes.numsol ".
					 "	   AND cxp_dt_solicitudes.codemp=cxp_rd_spg.codemp ".
					 "	   AND cxp_dt_solicitudes.numrecdoc=cxp_rd_spg.numrecdoc ".
				 	 "	   AND cxp_dt_solicitudes.codtipdoc=cxp_rd_spg.codtipdoc ".
					 "	   AND cxp_dt_solicitudes.cod_pro=cxp_rd_spg.cod_pro ".
					 "	   AND cxp_dt_solicitudes.ced_bene=cxp_rd_spg.ced_bene ".
					 "	   AND cxp_rd.codemp=cxp_rd_spg.codemp ".
					 "	   AND cxp_rd.numrecdoc=cxp_rd_spg.numrecdoc ".
					 "	   AND cxp_rd.codtipdoc=cxp_rd_spg.codtipdoc ".
					 "	   AND cxp_rd.cod_pro=cxp_rd_spg.cod_pro ".
					 "	   AND cxp_rd.ced_bene=cxp_rd_spg.ced_bene) as detspg ".
				     " FROM cxp_solicitudes, $ls_tabla, scb_prog_pago, scb_banco, scb_ctabanco ".
				     " WHERE cxp_solicitudes.codemp = '".$codemp."' ".
					 " AND cxp_solicitudes.tipproben = '".$tipproben."' ".
					 " AND cxp_solicitudes.estprosol = 'S' ".
					 " AND scb_prog_pago.codban like '%".$codban."%' ".
					 " AND scb_prog_pago.ctaban like '%".$ctaban."%' ".
					 " AND scb_prog_pago.fecpropag = '%".$fecmov."%' ".
					 " AND scb_prog_pago.estmov = 'P' ".
					 " AND cxp_solicitudes.numsol = scb_prog_pago.numsol $ls_straux ".					
					 " AND scb_prog_pago.codban = scb_banco.codban ".
					 " AND scb_prog_pago.codban = scb_ctabanco.codban ".
					 " AND scb_prog_pago.ctaban = scb_ctabanco.ctaban ".					
					 " AND cxp_solicitudes.codemp = scb_prog_pago.codemp ".
					 " AND cxp_solicitudes.codemp = scb_banco.codemp ".
					 " AND cxp_solicitudes.codemp = scb_ctabanco.codemp ".
					 " AND cxp_solicitudes.numsol NOT IN (SELECT numsol FROM cxp_sol_banco WHERE estmov<>'A' AND estmov<>'O') ".
				     " ORDER BY cxp_solicitudes.numsol ASC ";				
	//	echo $cadenasql;
	//	break;
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
		}
		else
		{
			$j=0;
			while((!$resultado->EOF))
			{
				$ld_montotsal = $ld_montotnot = 0;
			    $ls_numsol    = $resultado->fields["numsol"];
				$ls_codproben = $resultado->fields["codproben"];
				$ld_monsolpag = $resultado->fields["monsol"];
				$ls_fecpropag = $resultado->fields["fecpropag"];
				$ls_codproben = trim($resultado->fields["codproben"]);
				$ls_nomban    = trim($resultado->fields["nomban"]);
				$ls_nomctaban = trim($resultado->fields["dencta"]);
				$ls_codban    = trim($resultado->fields["codban"]);
				$ls_ctaban    = trim($resultado->fields["ctaban"]);
				if ($tipproben=='P')
				{
					$ls_nomproben = $resultado->fields["nomproben"];
				}
			    elseif($tipproben=='B')
				{
				 	$ls_nomproben = $resultado->fields["nombene"];
				 	$ls_apeben    = $resultado->fields["apebene"];
				 	if (!empty($ls_apeben))
				    {
				        $ls_nomproben = $ls_nomproben.', '.$ls_apeben;
				    } 								   
				}
				$arrSolicitudes[$j]['numsol']     = $ls_numsol;
				$arrSolicitudes[$j]['monsol']     = number_format($ld_monsolpag,2,",",".");
				$arrSolicitudes[$j]['saldo']      = number_format($ld_montotsal,2,",",".");
				$arrSolicitudes[$j]['fecpropag']  = $ls_fecpropag;
				$arrSolicitudes[$j]['codproben']  = $ls_nomproben;
				$arrSolicitudes[$j]['nomban']     = $ls_nomban;
				$arrSolicitudes[$j]['nomctaban']  = $ls_nomctaban;
				$arrSolicitudes[$j]['codban']     = $ls_codban;
				$arrSolicitudes[$j]['ctaban']     = $ls_ctaban;
				$j++;
				$resultado->MoveNext();
			}
		}
		unset($conexionbd);
		unset($resultado);
		return $arrSolicitudes;
	}
	
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarCodigoParametro()
	 */
	public function uf_load_notas_asociadas($as_codemp,$as_numsol,$ai_montonotas)
	{
		$lb_valido=true;
		$as_codemp = $_SESSION["la_empresa"]["codemp"];
		$ai_montonotas=0;
		$cadenasql = "SELECT SUM(CASE cxp_sol_dc.codope WHEN 'NC' THEN (-1*cxp_sol_dc.monto) ".
			   "  ELSE (cxp_sol_dc.monto) END) as total ".
			   "  FROM cxp_dt_solicitudes, cxp_sol_dc ".
			   " WHERE cxp_dt_solicitudes.codemp='".$as_codemp."' ".
			   "   AND cxp_dt_solicitudes.numsol='".$as_numsol."' ".
			   "   AND cxp_sol_dc.estnotadc= 'C' ".
			   "   AND cxp_dt_solicitudes.codemp = cxp_sol_dc.codemp ".
			   "   AND cxp_dt_solicitudes.numsol = cxp_sol_dc.numsol ".
			   "   AND cxp_dt_solicitudes.numrecdoc = cxp_sol_dc.numrecdoc ".
			   "   AND cxp_dt_solicitudes.codtipdoc = cxp_sol_dc.codtipdoc ".
			   "   AND cxp_dt_solicitudes.ced_bene = cxp_sol_dc.ced_bene ".
			   "   AND cxp_dt_solicitudes.cod_pro = cxp_sol_dc.cod_pro";
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
		}
		else
		{
			while((!$resultado->EOF))
			{
				$ai_montonotas=$resultado->fields["total"];
				$resultado->MoveNext();
			}
		}
		unset($conexionbd);
		unset($resultado);
		return $lb_valido;
	}

	
	 /* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()*/
	public function insertarDesprogramacion($numsol,$fechaprog,$estmov,$codban,$ctaban,$tipproben,$arrevento)
	{
		//////////////////////////////////////////////////////////////////////////////
		//	Function:	uf_procesar_programacion
		// Access:		public
		//	Returns:	Boolean Retorna si proceso correctamente
		//	Description:	Funcion que se encarga de guardar el movimiento bien sea 
		//						insertando o actualizando
		//////////////////////////////////////////////////////////////////////////////
		$resultado = 0;
		$ls_codemp   = $_SESSION["la_empresa"]["codemp"]; 
	    $ls_codusu   = $_SESSION["la_logusr"];			 
		//Creacion del Dao con la tabla y campos a insertar.
		
		$this->daoDesprogramacion=FabricaDao::CrearDAO("N","scb_prog_pago");
		$this->daoDesprogramacion->codemp       = $ls_codemp;
		$this->daoDesprogramacion->codban    	= $codban; 
		$this->daoDesprogramacion->ctaban       = $ctaban; 
		$this->daoDesprogramacion->codusu       = $ls_codusu; 
		$this->daoDesprogramacion->numsol       = $numsol; 
		$this->daoDesprogramacion->fecpropag    = convertirFechaBd($fechaprog); 
		//Iniciar transaccion
		DaoGenerico::iniciarTrans();
		//Insertamos la programacion de pago
		$resultado = $this->daoDesprogramacion->eliminar();
		
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];
		
		if ($resultado)
		{
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento();
			$strPk = "codemp='{$ls_codemp}' AND numsol='{$numsol}'";
			$this->daoDesprogramacion = FabricaDao::CrearDAO("C", "cxp_solicitudes", '', $strPk);
			$this->daoDesprogramacion->estprosol = 'C' ;
			$resultado = $this->daoDesprogramacion->modificar();
			
			if ($resultado)
			{
				$servicioEvento->tipoevento=true;
				$servicioEvento->incluirEvento();
			}
			else
			{
				$arrevento ['desevetra'] = $this->daoDesprogramacion->ErrorMsg();
				$servicioEvento->tipoevento=false;
				$servicioEvento->desevetra=$arrevento['desevetra'];
				$servicioEvento->incluirEvento();
			}
			
			$this->daoDesprogramacion=FabricaDao::CrearDAO("N","cxp_historico_solicitud");
			$this->daoDesprogramacion->codemp       = $ls_codemp;
			$this->daoDesprogramacion->numsol       = $numsol; 
			$this->daoDesprogramacion->fecha    = convertirFechaBd($fechaprog); 
			$this->daoDesprogramacion->estprodoc    = 'S';
			$resultado = $this->daoDesprogramacion->eliminar();
			if ($resultado)
			{
				$servicioEvento->tipoevento=true;
				$servicioEvento->incluirEvento();
			}
			else
			{
				$arrevento ['desevetra'] = $this->daoDesprogramacion->ErrorMsg();
				$servicioEvento->tipoevento=false;
				$servicioEvento->desevetra=$arrevento['desevetra'];
				$servicioEvento->incluirEvento();
			}
			
			 
		}
		else
		{
			$arrevento ['desevetra'] = $this->daoDesprogramacion->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
		}
		
		if (DaoGenerico::completarTrans()) 
		{
			$resultado = 1;
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 		
		}
		else
		{
			$arrevento ['desevetra'] = $this->daoDesprogramacion->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
		}  
	//liberando variables y retornando el resultado de la operacion
	unset($this->daoDesprogramacion);	
    return $resultado;	
	}

}
?>