<?php
$dirsrvscb = "";
$dirsrvscb = dirname(__FILE__);
$dirsrvscb = str_replace("\\","/",$dirsrvscb);
$dirsrvscb = str_replace("/modelo/servicio/scb","",$dirsrvscb); 
require_once ($dirsrvscb."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrvscb."/modelo/servicio/scb/sigesp_srv_scb_icontroldocumentos.php");
require_once ($dirsrvscb."/modelo/servicio/sss/sigesp_srv_sss_evento.php");


/**
 * @author Ingeniero Domingo Calicchio
 * @desc clase que sirve a la pantalla parametro de clasificacion, esta implementa
 *       la logica del negocio y maneja los recursos de base de datos
 */
class servicioDocumento implements icontroldocumentos 
{
	private $daoDocumentos;
	private $daoRegistroEvento;
	private $daoRegistroFalla;
	public  $mensaje; 
	public  $valido; 
	
	public function servicioDocumento() 
	{
		$this->daoDocumentos = null;
		$this->daoRegistroEvento = null;
		$this->daoRegistroFalla  = null;
		$this->mensaje = '';
		$this->valido = true;
	}
		
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()
	 */
	public function cargarDatos($codemp, $as_codban, $as_ctaban, $as_fecdes, $as_fechas, $as_estatus)
	{
	  	$ls_filtro = "";
	  
	 	if ($as_fecdes != '' && $as_fechas != '') 
		{
	  	 	$as_fecdes = convertirFechaBd($as_fecdes);
	     	$as_fechas = convertirFechaBd($as_fechas);
		}
	  
		if (!empty($as_fecdes) && !empty($as_fechas))
		{
			$ls_filtro = $ls_filtro." AND scb_movbco.fecmov BETWEEN '".$as_fecdes."' AND '".$as_fechas."'";
		}
	  
		if (!empty($as_codban))
		{
			$ls_filtro = $ls_filtro." AND scb_movbco.codban='".$as_codban."' ";
		}
		else
		{
			$ls_codbanco = "  ";
		}
		
		if (!empty($as_codban))
		{
			if (empty($as_ctaban))
			{
				$ls_filtro = $ls_filtro."  ";
			}
			else
			{
				$ls_filtro = $ls_filtro." AND scb_movbco.ctaban='".$as_ctaban."'";
			}
		}
		else
		{
			$ls_filtro = $ls_filtro."  ";
		}
		
		if(!empty($as_estatus))
		{
			$ls_filtro = $ls_filtro." AND scb_movbco.estcondoc='".$as_estatus."'";
		}
		else
		{
			$ls_filtro = $ls_filtro."  ";	
		}
	
		$cadenasql = " 	SELECT 	scb_movbco.codemp, scb_movbco.codban, scb_movbco.ctaban, scb_movbco.numdoc ,scb_movbco.codope, ".
					 "			scb_movbco.estmov, scb_movbco.nomproben as nombre, (scb_movbco.monto - scb_movbco.monret) as monto, ".
					 "			scb_movbco.fecmov ".
					 "	FROM scb_movbco ".
					 "	WHERE scb_movbco.codemp='".$codemp."' ".
					 "	AND(scb_movbco.procede = 'SCBBCH' or scb_movbco.procede = 'SCBCOR') ".
					 "	AND ((scb_movbco.codope='CH' OR scb_movbco.codope='ND') AND (scb_movbco.codope<>'DP' AND scb_movbco.codope<>'OP')) ".
					 "	AND scb_movbco.estmov <>'A' ".$ls_filtro." ".
					 "	ORDER BY scb_movbco.fecmov, scb_movbco.numdoc ";
		//echo $cadenasql;
		//break;
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
		}
		return $resultado;
	}
		
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()
	 */
	public function guardarDatos($as_codban, $as_ctaban, $as_numdoc, $as_codope, $as_estmov, $as_estatus)
	{
		$resultado = 0;
		$ls_codemp   = $_SESSION["la_empresa"]["codemp"];
	    $ls_codusu   = $_SESSION["la_logusr"];
		//print($as_estatus);
		//break;		
		//Creacion del Dao con la tabla y campos a insertar.
		$this->daoProcesar=FabricaDao::CrearDAO("C","scb_movbco");
		$this->daoProcesar->codemp       = $ls_codemp;
		$this->daoProcesar->codusu       = $ls_codusu;
		$this->daoProcesar->codban		 = $as_codban;
		$this->daoProcesar->ctaban		 = $as_ctaban;
		$this->daoProcesar->numdoc		 = $as_numdoc;
		$this->daoProcesar->codope		 = $as_codope;
		$this->daoProcesar->estmov    	 = $as_estmov;
		switch ($as_estatus)
		{
    		case "F";
				$this->daoProcesar->fecenvfir	= date('Y-m-d');
				$this->daoProcesar->fecenvcaj	= '1900-01-01';
				$this->daoProcesar->estcondoc	= $as_estatus;
    			break;
    		case "C";
				$this->daoProcesar->fecenvcaj	= date('Y-m-d');
				$this->daoProcesar->estcondoc	= $as_estatus;
    			break;
    		case "S";
				$this->daoProcesar->fecenvfir	= '1900-01-01';
				$this->daoProcesar->fecenvcaj	= '1900-01-01';
				$this->daoProcesar->estcondoc	= $as_estatus;
    			break;
    	}
		//Iniciar transaccion
		DaoGenerico::iniciarTrans();
		
		//Insertamos la programacion de pago
		$resultado = $this->daoProcesar->modificar();
				
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];
		
		if (DaoGenerico::completarTrans()) 
		{
			$resultado = 1;
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 		
		}
		else
		{
			$arrevento ['desevetra'] = $this->daoProcesar->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
		}  
	//liberando variables y retornando el resultado de la operacion
	unset($this->daoProcesar);	
    return $resultado;	
	}
	
}
?>