<?php
$dirsrvscb = "";
$dirsrvscb = dirname(__FILE__);
$dirsrvscb = str_replace("\\","/",$dirsrvscb);
$dirsrvscb = str_replace("/modelo/servicio/scb","",$dirsrvscb); 
require_once ($dirsrvscb."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrvscb.'/base/librerias/php/general/sigesp_lib_funciones.php');
require_once ($dirsrvscb."/modelo/servicio/scb/sigesp_srv_scb_iconciliacion.php");
require_once ($dirsrvscb."/modelo/servicio/sss/sigesp_srv_sss_evento.php");


/**
 * @author Ing. Gerardo Cordero
 * @desc clase que sirve a la pantalla parametro de clasificacion, esta implementa
 *       la logica del negocio y maneja los recursos de base de datos
 */
class ServicioConciliacion implements IConciliacion {
	
	private $conexionBD;
	private $daoMovimiento;
	private $daoConciliacion;
	
	public function buscarMovimientoConciliar($codemp, $codbanco, $ctabanco, $fechadesde, $fechahasta, $filtro) {
		$arrMovConciliar = array();
		$cadenaFiltro = '';
		switch($filtro) {
			case "ND":
				$cadenaFiltro = " AND codope='ND' ";
				break;
			case "NC":
				$cadenaFiltro = " AND codope='NC' ";
				break;
			case "DP":
				$cadenaFiltro = " AND codope='DP' ";
				break;
			case "RE":
				$cadenaFiltro = " AND codope='RE' ";
				break;
			case "CH":
				$cadenaFiltro = " AND codope='CH' ";
				break;				
		}
		
		$this->conexionBD = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL="SELECT numdoc,fecmov,conmov,(monto - monret) as monto,codope,estmov,estcon,feccon,estreglib, numcarord
						FROM scb_movbco
						WHERE codemp='".$codemp."' 
				     	  AND codban='".$codbanco."' 
						  AND ctaban ='".$ctabanco."' 
				     	  AND estmov <>'N' {$cadenaFiltro} 
						  AND ((feccon='1900-01-01' AND fecmov<='".$fechahasta."') 
					  		   OR (feccon = '".$fechadesde."') 
					  		   OR (fecmov<='".$fechahasta."' AND feccon>'".$fechadesde."'))";
		$dataMovbco = $this->conexionBD->Execute($cadenaSQL);
		$numMov = 0;
		while (!$dataMovbco->EOF) {
			$arrMovConciliar[$numMov]['numdoc'] = $dataMovbco->fields['numdoc'];
			$arrMovConciliar[$numMov]['fecmov'] = $dataMovbco->fields['fecmov'];
			$arrMovConciliar[$numMov]['conmov'] = $dataMovbco->fields['conmov'];
			$arrMovConciliar[$numMov]['monto']  = $dataMovbco->fields['monto'];
			$arrMovConciliar[$numMov]['codope'] = $dataMovbco->fields['codope'];
			$arrMovConciliar[$numMov]['estmov'] = $dataMovbco->fields['estmov'];
			$arrMovConciliar[$numMov]['estcon'] = $dataMovbco->fields['estcon'];
			$arrMovConciliar[$numMov]['feccon'] = $dataMovbco->fields['feccon'];
			$arrMovConciliar[$numMov]['estreglib'] = $dataMovbco->fields['estreglib'];
			$arrMovConciliar[$numMov]['numcarord'] = $dataMovbco->fields['numcarord'];
			
			$dataMovbco->MoveNext();
			$numMov++;
		}
		$dataMovbco->Close();
		
		$cadenaSQL2 = "SELECT numdoc,fecmov,conmov,(monmov-monret) as monto,codope,estmov,estcon,fecmesano,esterrcon
				     		FROM scb_errorconcbco 
				    		WHERE codemp = '".$codemp."'
				    		  AND codban = '".$codbanco."' 
					  		  AND ctaban = '".$ctabanco."' {$cadenaFiltro} 
					  		  AND ((fecmesano='1900-01-01' AND fecmov<='".$fechahasta."') 
				      			   OR  (fecmesano = '".$fechadesde."') 
				      			   OR (fecmov<='".$fechahasta."' AND fecmesano>'".$fechadesde."' ))";
		$dataErrbco = $this->conexionBD->Execute($cadenaSQL2);
		while (!$dataErrbco->EOF) {
			$arrMovConciliar[$numMov]['numdoc'] = $dataErrbco->fields['numdoc'];
			$arrMovConciliar[$numMov]['fecmov'] = $dataErrbco->fields['fecmov'];
			$arrMovConciliar[$numMov]['conmov'] = $dataErrbco->fields['conmov'];
			$arrMovConciliar[$numMov]['monto']  = $dataErrbco->fields['monto'];
			$arrMovConciliar[$numMov]['codope'] = $dataErrbco->fields['codope'];
			$arrMovConciliar[$numMov]['estmov'] = $dataErrbco->fields['estmov'];
			$arrMovConciliar[$numMov]['estcon'] = $dataErrbco->fields['estcon'];
			$arrMovConciliar[$numMov]['feccon'] = $dataErrbco->fields['fecmesano'];
			$arrMovConciliar[$numMov]['estreglib'] = $dataErrbco->fields['esterrcon'];
			$arrMovConciliar[$numMov]['numcarord'] = ' ';
			
			$dataErrbco->MoveNext();
			$numMov++;
		}
		$dataErrbco->Close();
		
		return $arrMovConciliar;
	}
	
	public function buscarConciliacion($codemp, $codbanco, $ctabanco, $periodo) {
		$arrConciliacion = array();
		$this->conexionBD = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL="SELECT estcon,salseglib,salsegbco,conciliacion 
				 		FROM scb_conciliacion
				 		WHERE codemp = '{$codemp}' 
				 		  AND codban='{$codbanco}' 
				 		  AND ctaban='{$ctabanco}' 
				 		  AND mesano='{$periodo}'";
		$dataConciliacion = $this->conexionBD->Execute($cadenaSQL);
		if(!$dataConciliacion->EOF){
			$arrConciliacion['estcon']       = $dataConciliacion->fields['estcon'];
			$arrConciliacion['salseglib']    = $dataConciliacion->fields['salseglib'];
			$arrConciliacion['salsegbco']    = $dataConciliacion->fields['salsegbco'];
			$arrConciliacion['conciliacion'] = $dataConciliacion->fields['conciliacion'];	
		}
		$dataConciliacion->Close();
		
		return $arrConciliacion;
	}
	
	public function buscarBanco($codemp, $codbanco, $desbanco) {
		$this->conexionBD = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL="SELECT codban, nomban
  						FROM scb_banco 
  						WHERE codemp = '".$codemp."'
  						  AND codban <> '---'
				    	  AND codban like '%".$codbanco."%' 
				    	  AND nomban like '%".$desbanco."%'
				    	ORDER BY codban";
		return $this->conexionBD->Execute($cadenaSQL);
	}
	
	public function buscarCuentaBanco($codemp, $codbanco, $codusu) {
		$this->conexionBD = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSeguridad =  $this->conexionBD->Concat('cta.codban',"'-'",'cta.ctaban');
		$cadenaSQL="SELECT cta.ctaban, tct.nomtipcta, cta.ctabanext, cta.dencta, cta.sc_cuenta, 
       					   cta.fecapr
  						FROM scb_ctabanco cta 
  							INNER JOIN scb_tipocuenta tct ON cta.codemp=tct.codemp AND cta.codtipcta=tct.codtipcta
  							INNER JOIN sss_permisos_internos pi ON cta.codemp=pi.codemp AND pi.codusu='".$codusu."' 
  																   AND TRIM(".$cadenaSeguridad.")=TRIM(pi.codintper)	
  						WHERE cta.codemp = '".$codemp."'
				    	  AND cta.codban = '".$codbanco."' 
				    	  AND cta.estact='1'
				    	ORDER BY cta.ctaban";
		return $this->conexionBD->Execute($cadenaSQL);
	}
	
	public function obtenerSaldoCuentaBanco($codemp, $codbanco, $ctabanco) {
		$totmondeb = 0;
		$totmonhab = 0;
		$saldo = 0;
		$this->conexionBD = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = "SELECT SUM(monto - monret) As monhab, 0 As mondeb 
				     	FROM scb_movbco 
						WHERE codemp='".$codemp."' 
					  	AND codban='".$codbanco."' 
					 	AND trim(ctaban)='".trim($ctabanco)."' 
					  	AND (codope='RE' OR codope='ND' OR codope='CH') 
					  	AND estmov<>'A' 
					  	AND estmov<>'O'
			       	 	GROUP BY codemp, codban, ctaban
					  UNION
				   	  SELECT 0 As monhab, SUM(monto - monret) As mondeb 
					 	FROM scb_movbco 
						WHERE codemp='".$codemp."' 
					  	AND codban='".$codbanco."' 
					  	AND trim(ctaban)='".trim($ctabanco)."' 
					  	AND (codope='NC' OR codope='DP') 
					  	AND estmov<>'A' 
					  	AND estmov<>'O'
						GROUP BY codemp, codban, ctaban";
		$dataMov = $this->conexionBD->Execute($cadenaSQL);
		while(!$dataMov->EOF){
			$montoDebe  = $dataMov->fields["mondeb"];
			$montoHaber = $dataMov->fields["monhab"];
			$totmondeb += $montoDebe;
			$totmonhab += $montoHaber;
			
			$dataMov->MoveNext();
		}
		$saldo = $totmondeb-$totmonhab;
		
		return $saldo;
	}
	
	public function obtenerSaldoSegunLibro($codemp, $codbanco, $ctabanco, $fecha) {
		$this->conexionBD = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = "SELECT SUM(monto - monret) As mondeb,estmov
				   		FROM scb_movbco
				   		WHERE codemp='".$codemp."'  
				   		AND codban='".$codbanco."'  
				   		AND ctaban='".$ctabanco."' 
				   		AND fecmov<='".$fecha."'  
				   		AND (codope='NC' OR codope='DP')   
					    AND ((estreglib IS NULL) or estreglib<>'A' OR (estreglib='A' AND estcon=1)) 
					    GROUP BY estmov";
		$dataMovDebe = $this->conexionBD->Execute($cadenaSQL);
		$totalDebe = 0;
		$totalDebeAnulado = 0;
		$saldoDebe = 0;
		while(!$dataMovDebe->EOF){
			$estmov  = $dataMovDebe->fields["estmov"];
			$montoDebe  = $dataMovDebe->fields["mondeb"];
			if($estmov != 'A'){
				$totalDebe += $montoDebe;
			}
			else {
				$totalDebeAnulado += $montoDebe;
			}
			$dataMovDebe->MoveNext();
		}
		$dataMovDebe->Close();
		$saldoDebe = $totalDebe - $totalDebeAnulado;
		
		$cadenaSQLB = "SELECT SUM(monto - monret) As monhab,estmov
				   		FROM  scb_movbco 
				   		WHERE codemp='".$codemp."'  
				   		AND codban='".$codbanco."' 
				   		AND ctaban='".$ctabanco."'
				   		AND fecmov<='".$fecha."' 
				   		AND (codope='RE' OR codope='ND' OR codope='CH') 
					 	AND ((estreglib IS NULL) or estreglib<>'A' OR (estreglib='A' AND estcon=1)) 
					 	GROUP BY estmov";
		$dataMovHaber = $this->conexionBD->Execute($cadenaSQLB);
		$totalHaber = 0;
		$totalHaberAnulado = 0;
		$saldoHaber = 0;
		while(!$dataMovHaber->EOF){
			$estmov  = $dataMovHaber->fields["estmov"];
			$montoHaber  = $dataMovHaber->fields["monhab"];
			if($estmov != 'A'){
				$totalHaber += $montoHaber;
			}
			else {
				$totalHaberAnulado += $montoHaber;
			}
			$dataMovHaber->MoveNext();
		}
		$dataMovHaber->Close();
		$saldoHaber = $totalHaber - $totalHaberAnulado;
		
		return number_format($saldoDebe-$saldoHaber,2,',','.');
	}
	
	public function obtenerTransNoRegLibro($codemp, $codbanco, $ctabanco, $fechadesde, $fechahasta) {
		$this->conexionBD = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = "SELECT 0 as mondeb, SUM(monto - monret) as monhab  
	            		FROM scb_movbco 
					   WHERE codemp='{$codemp}'
					     AND codban='{$codbanco}' 
					     AND ctaban='{$ctabanco}' 
						 AND (codope='RE' OR codope='ND' OR codope='CH') 
						 AND estmov<>'A'
						 AND estmov<>'O'
						 AND tranoreglib = '1' 
						 AND fecmov BETWEEN '".$fechadesde."' AND '".$fechahasta."'
				       UNION
					  SELECT SUM(monto - monret) as mondeb, 0 as monhab  
			            FROM scb_movbco
					   WHERE codemp='{$codemp}'
					     AND codban='{$codbanco}' 
					     AND ctaban='{$ctabanco}' 
						 AND (codope='NC' OR codope='DP') 
						 AND estmov<>'A' 
						 AND estmov<>'O'
						 AND tranoreglib = '1'  
						 AND fecmov BETWEEN '{$fechadesde}' AND '{$fechahasta}'
					   GROUP BY codemp,codban,ctaban";
		$dataTransNoRegLib = $this->conexionBD->Execute($cadenaSQL);
		$totalDebe  = 0;
		$totalHaber = 0;
		while(!$dataTransNoRegLib->EOF){
			$totalDebe  += $dataTransNoRegLib->fields["mondeb"];
			$totalHaber += $dataTransNoRegLib->fields["monhab"];
			
			$dataTransNoRegLib->MoveNext();
		}
		$dataTransNoRegLib->Close();
		
		return number_format($totalDebe - $totalHaber,2,',','.');
	}
	
	public function obtenerErrorBanco($codemp, $codbanco, $ctabanco, $periodo) {
		$this->conexionBD = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = "SELECT SUM(monmov - monret) as mondeb 
						FROM scb_errorconcbco 
						WHERE codemp='{$codemp}' 
						  AND codban='{$codbanco}' 
						  AND ctaban='{$ctabanco}'
						  AND fecmesano='{$periodo}' 
					 	  AND (codope='NC' OR codope='DP') 
						  AND estmov<>'A' 
						  AND estmov<>'O' 
						GROUP BY codemp,codban,ctaban";
		$dataErrorDeb = $this->conexionBD->Execute($cadenaSQL);
		$totalDebe = 0;
		while(!$dataErrorDeb->EOF){
			$totalDebe  += $dataErrorDeb->fields["mondeb"];
			
			$dataErrorDeb->MoveNext();
		}
		$dataErrorDeb->Close();
		
		$cadenaSQLB = "SELECT  SUM(monmov - monret) as monhab 
						FROM scb_errorconcbco 
						WHERE codemp='{$codemp}' 
						  AND codban='{$codbanco}' 
						  AND ctaban='{$ctabanco}'
						  AND fecmesano ='{$periodo}' 
						  AND (codope='RE' OR codope='ND' OR codope='CH') 
						  AND estmov<>'A' 
						  AND estmov<>'O' 
						GROUP BY codemp,codban,ctaban";
		$dataErrorHab = $this->conexionBD->Execute($cadenaSQLB);
		$totalHaber = 0;
		while(!$dataErrorHab->EOF){
			$totalHaber  += $dataErrorHab->fields["monhab"];
			
			$dataErrorHab->MoveNext();
		}
		$dataErrorHab->Close();
		
		return number_format($totalDebe - $totalHaber,2,',','.'); 
	}
	
	public function obtenerErrorLibro($codemp, $codbanco, $ctabanco, $fechadesde, $fechahasta) {
		$this->conexionBD = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = "SELECT 0 as mondeb, SUM(monto-monret) As monhab
						 FROM scb_movbco 
						WHERE codemp='{$codemp}'
						  AND codban='{$codbanco}' 
						  AND ctaban='{$ctabanco}'
						  AND fecmov>='{$fechadesde}' 
						  AND fecmov<='{$fechahasta}' 
						  AND (codope='RE' OR codope='ND' OR codope='CH') 
						  AND estmov<>'A' 
						  AND estmov<>'O' 
						  AND estreglib='B' 
						UNION
					   SELECT SUM(monto-monret) as mondeb, 0 as monhab
					     FROM scb_movbco
					    WHERE codemp='{$codemp}'
						  AND codban='{$codbanco}' 
						  AND ctaban='{$ctabanco}'
						  AND fecmov>='{$fechadesde}' 
						  AND fecmov<='{$fechahasta}' 
					  	  AND (codope='NC' OR codope='DP') 
						  AND estmov<>'A' 
						  AND estmov<>'O' 
						  AND estreglib='B' 
						GROUP BY codemp,codban,ctaban";
		$dataErrorLibro = $this->conexionBD->Execute($cadenaSQL);
		$totalDebe  = 0;
		$totalHaber = 0;
		while(!$dataErrorLibro->EOF){
			$totalDebe  += $dataErrorLibro->fields["mondeb"];
			$totalHaber += $dataErrorLibro->fields["monhab"];
			
			$dataErrorLibro->MoveNext();
		}
		$dataErrorLibro->Close();
		
		return $totalDebe - $totalHaber;
		
	}
	
	public function procesarConciliacion($codemp, $objJson, $arrEvento) {
		$arrMovimientos = $objJson->arrMovimientos;
		DaoGenerico::iniciarTrans();
		$movOk = true;
		foreach ($arrMovimientos as $movimiento) {
			$strPk = "codemp='{$codemp}' 
					  AND codban = '{$objJson->codban}'
					  AND ctaban = '{$objJson->ctaban}'
					  AND numdoc = '{$movimiento->numdoc}'
					  AND codope = '{$movimiento->codope}'";
 			$this->daoMovimiento = FabricaDao::CrearDAO('C','scb_movbco',null,$strPk);
 			$this->daoMovimiento->estcon = $movimiento->estcon;
 			$this->daoMovimiento->feccon = $movimiento->feccon;
			if($this->daoMovimiento->modificar() == 0){
				$movOk = false;
			 	break;
			}
		}
		
		if($movOk){
			$this->daoConciliacion = FabricaDao::CrearDAO('N','scb_conciliacion');
			$this->daoConciliacion->codemp = $codemp;
			$this->daoConciliacion->setData($objJson);
			$this->daoConciliacion->salseglib = formatoNumericoBd($objJson->salseglib, 1);
			$this->daoConciliacion->salsegbco = formatoNumericoBd($objJson->salsegbco, 1);
			$this->daoConciliacion->conciliacion = formatoNumericoBd($objJson->conciliacion, 1);
			$this->daoConciliacion->mesano   = str_replace('/','',$objJson->mesano);
			$respuesta = $this->daoConciliacion->modificar();
			
			$servicioEvento = new ServicioEvento();
			$servicioEvento->codemp=$codemp;
			$servicioEvento->codsis=$arrevento['codsis'];
			$servicioEvento->nomfisico=$arrevento['nomfisico'];
			if ($respuesta==2) {
				$servicioEvento->evento = 'INSERT';
				$servicioEvento->desevetra = 'Registro la conciliacion del banco '.$objJson->codban.', la cuenta '.$objJson->ctaban.' del periodo '.$objJson->periodo;
			}
			elseif ($respuesta==1) {
				$servicioEvento->evento = 'UPDATE';
				$servicioEvento->desevetra = 'Modifico la conciliacion del banco '.$objJson->codban.', la cuenta '.$objJson->ctaban.' del periodo '.$objJson->periodo;
			}
		}
		else {
			$mensajeError = $this->daoMovimiento->ErrorMsg();
		}
		
		if(DaoGenerico::completarTrans()) {
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento(); 
			return '1';
		}
		else{
			$servicioEvento->tipoevento=false;
			if (!$movOk) {
				$servicioEvento->desevetra = $mensajeError;
			}
			else {
				$servicioEvento->desevetra = $this->daoConciliacion->ErrorMsg();
			}
			$servicioEvento->incluirEvento();
			return "0";
		}
		
	}
	
	public function abrirConciliacion($codemp, $codbanco, $ctabanco, $periodo) {
		$abrirConciliacion = '0';
		$strPk = "codemp='{$codemp}' 
				  AND codban = '{$codbanco}'
				  AND ctaban = '{$ctabanco}'
				  AND mesano = '{$periodo}'";
		$this->daoConciliacion = FabricaDao::CrearDAO('C','scb_conciliacion',null,$strPk);
		$this->daoConciliacion->estcon = 0;
		if($this->daoConciliacion->modificar() != 0) {
			$abrirConciliacion = '1';
		}
		
		return $abrirConciliacion;
	}
}
?>