<?php
$dirsrvscb = "";
$dirsrvscb = dirname(__FILE__);
$dirsrvscb = str_replace("\\","/",$dirsrvscb);
$dirsrvscb = str_replace("/modelo/servicio/scb","",$dirsrvscb); 
require_once ($dirsrvscb."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrvscb."/modelo/servicio/scb/sigesp_srv_scb_icmp_retencion.php");
require_once ($dirsrvscb."/modelo/servicio/sss/sigesp_srv_sss_evento.php");

require_once($dirsrvscb."/shared/class_folder/class_datastore.php");

/**
 * @author Ing. Gerardo Cordero
 * @desc clase que sirve a la pantalla parametro de clasificacion, esta implementa
 *       la logica del negocio y maneja los recursos de base de datos
 */
class servicioDocumento implements icmp_retencion 
{
	private $daoDocumentos;
	private $daoRegistroEvento;
	private $daoRegistroFalla;
	private $daoComprobante;
	private $conexionBaseDatos;
	private $daoCambioEstatus;
	private $daoDetalle; 
	public  $mensaje; 
	public  $valido; 
	public  $existe;
	
	public function servicioDocumento() 
	{
		$this->daoDocumentos = null;
		$this->daoRegistroEvento = null;
		$this->daoRegistroFalla  = null;
		$this->daoComprobante = null;
		$this->mensaje = '';
		$this->existe = false;
		$this->valido = true;
		$this->daoDetalle = null;
		$this->daoCambioEstatus = null;
	}
	
	/* (non-PHPdoc)
	 * Funcion que elimina los detalles existentes del comprobante de retencion 
	*/
	public function uf_delete_dt_cmpret($as_numcom,$as_codret)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$ls_sql="DELETE FROM scb_dt_cmp_ret  ".
				"WHERE codemp='".$_SESSION["la_empresa"]["codemp"]."' ".
				"  AND numcom='".$as_numcom."'".
				"  AND codret='".$as_codret."'";
		$resultado = $this->conexionBaseDatos->Execute($ls_sql);
		if($resultado===false)
	    {
			$this->mensaje .= ' CLASE->Editar Comprobate MÉTODO->uf_delete_dt_cmpret ERROR->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
	    }
		return $this->valido;
	}// end function uf_insert_recepciones
	
	public function validaFechaPeriodo($as_fecha,$as_codemp)
	{
	    $li_ano    = 0 ; $li_mes=0;$li_ano_periodo=0;$li_mes_periodo=0;
	    $ls_fecha  = ""; $ls_periodo_final=""; 
	    $lb_valido = true;
   	    //$as_fecha=$this->uf_convert_date_to_db($as_fecha);
	    $li_ano = intval(substr($as_fecha,0,4));
	    $li_mes = intval(substr($as_fecha,5,2));
	    $li_ano_periodo = intval(substr($_SESSION["la_empresa"]["periodo"],0,4));
	    $li_mes_periodo = intval(substr($_SESSION["la_empresa"]["periodo"],5,2));
	    $ld_periodo_final = "31/12/".$li_ano_periodo;
		if ($li_ano == $li_ano_periodo)
		{
			if($li_mes >= $li_mes_periodo)
			{
			   if($this->uf_valida_fecha_mes( $as_codemp, $as_fecha ))
			   {
			 	  $lb_valido = true;
			   }
			   else	 
			   {
				  $lb_valido = false;
			 	  //$this->is_msg_error = "Mes no esta Abierto";
				  return false;
			   }
			} 			
			else {  $lb_valido = false;	}
		}
		else 
		{ 
			$lb_valido = false;	
		}
		return $lb_valido;	
	} // end function()
	
	public function uf_valida_fecha_mes($as_codemp,$as_fecha)
 	{ 
		 $li_mes=0;$li_M01=0;$li_M02=0;$li_M03=0;$li_M04=0;$li_M05=0;
		 $li_M06=0;$li_M07=0;$li_M08=0;$li_M09=0;$li_M10=0;$li_M11=0;$li_M12=0;
		 $lb_abierto_mes=false;
		 $lb_valido=false;
		 $ls_cadena="";
		 $li_mes = intval(substr($as_fecha,5,2));
		 $cadenasql=" SELECT m01,m02,m03,m04,m05,m06,m07,m08,m09,m10,m11,m12 ". 
		 			" FROM sigesp_empresa WHERE codemp = '".$as_codemp."' ";
		 $conexionbd = ConexionBaseDatos::getInstanciaConexion();
		 $resultado = $conexionbd->Execute ( $cadenasql );
		 if ($resultado===false)
		 {
	 		 $mensaje .= '  ->'.$conexionbd->ErrorMsg();
		 }
		 else
		 {
			$lb_valido=true;
			while((!$resultado->EOF))
			{
				$li_M01=$resultado->fields["m01"];
				$li_M02=$resultado->fields["m02"];
				$li_M03=$resultado->fields["m03"];
				$li_M04=$resultado->fields["m04"];
				$li_M05=$resultado->fields["m05"];
				$li_M06=$resultado->fields["m06"];
				$li_M07=$resultado->fields["m07"];
				$li_M08=$resultado->fields["m08"];
				$li_M09=$resultado->fields["m09"];
				$li_M10=$resultado->fields["m10"];
				$li_M11=$resultado->fields["m11"];
				$li_M12=$resultado->fields["m12"];
				$resultado->MoveNext();
			}
		 } 
		 if ($lb_valido)
		 {
			switch ($li_mes)
			{
				case 1:
					if($li_M01==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 2:
					if($li_M02==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 3:
					if($li_M03==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 4:
					if($li_M04==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 5:
					if($li_M05==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 6:
					if($li_M06==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 7:
					if($li_M07==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 8:
					if($li_M08==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 9:
					if($li_M09==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 10:
					if($li_M10==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 11:
					if($li_M11==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				case 12:
					if($li_M12==1) 	{ $lb_abierto_mes = true; }
					else { $lb_abierto_mes = false;	}
					break;
				default:
			}
		 }	
		 if (!$lb_abierto_mes)
		 {
		   	 //$this->is_msg_error = "El Mes ".$li_mes." no esta abierto.";
			 $lb_valido = false;
		 }
		 unset($conexionbd);
		 unset($resultado);
		 return $lb_valido;
    } // end fuction
	
	/* (non-PHPdoc)
	 * Funcion que genera el comprobante de retencion 
	*/
	public function procesar_comprobante_retencion($origenPan,$as_mes,$as_agno,$as_tipproben,$as_probendesde,$as_probenhasta,$aa_numcmp,$objson,$arrevento)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$this->valido = true;
		$this->mensaje = '';
		$ls_codemp   = $_SESSION["la_empresa"]["codemp"];
	    $ls_codusu   = $_SESSION["la_logusr"];
	    $ls_basdatcmp=$_SESSION["la_empresa"]["basdatcmp"];
		$arre_numcom = array();
		$arrDatos  = array();
		$li_numcmp = $li_totrowpro = 0;
		$ls_fecact = date('Y-m-d');
		$ls_perfis = $as_agno.$as_mes;
		$lb_valido = false;
				
		if($aa_numcmp=="I")
		{
			$codret="0000000001";
		}
		elseif($aa_numcmp=="M")
		{
			$codret="0000000003";
		}
		elseif($aa_numcmp=="1")
		{
			$codret="0000000005";
		}
		
		
		if($this->validaFechaPeriodo($ls_fecact,$codemp)){
			if($origenPan=='CREAR'){
				$data = $this->load_proveedores_beneficiarios($ls_codemp,$aa_numcmp,$as_mes,$as_agno,$as_probendesde,$as_probenhasta,$as_tipproben);
				$li_numrow = $data->_numOfRows;
				$arrProBen = object_to_array($data);
				if(($this->valido) && ($li_numrow>0))
				{
					$i=0;
					while($i<$li_numrow)
					{
						$ls_codpro = $arrProBen[$i]["cod_pro"];
						$ls_codproalt = $arrProBen[$i]["codproalt"];
						$prueba = $this->get_documento($as_mes, $as_agno,$ls_codpro,$as_tipproben,$aa_numcmp,$ls_codproalt,$codret);
						$li_totrows = $prueba->_numOfRows;
						$documento = object_to_array($prueba);
						if($li_totrows>0)
						{  
							$this->existe = true;
							$this->valido = $this->uf_validar_rdmanual($ls_codpro,$documento,$as_tipproben);
							if($this->valido)
							{  
								$numcom = $this->get_nrocomprobante($ls_perfis,$codret,date('Y-m-d'),date('Y-m-01'),$as_tipproben,$ls_codpro);
								if($this->valido){
									$arrevento ['nomven']  = 'sigesp_vis_scb_cmp_retencion.html';
									$arrevento ['desevetra'] = 'Inserto el comprobante de retencion con el numero'.$numcom.', asociado a la empresa '.$ls_codemp;
									$this->daoComprobante = FabricaDao::CrearDAO("N","scb_cmp_ret");
									$this->daoComprobante->codemp = $_SESSION["la_empresa"]["codemp"];
									$this->daoComprobante->codret = $codret;
									$this->daoComprobante->numcom = $numcom;
									$this->daoComprobante->fecrep = convertirFechaBd($ls_fecact);
									$this->daoComprobante->perfiscal = $ls_perfis;
									$this->daoComprobante->codsujret = $ls_codproalt;
									$this->daoComprobante->nomsujret = $arrProBen[$i]['nompro'];
									$this->daoComprobante->dirsujret = $arrProBen[$i]['dirpro'];
									$this->daoComprobante->rif = $arrProBen[$i]['rifpro'];
									$this->daoComprobante->nit = '---------------';
									$this->daoComprobante->estcmpret = '1'; 
									$this->daoComprobante->codusu = $_SESSION['la_logusr'];
									$this->daoComprobante->numlic = '';
									$this->daoComprobante->origen = 'A';
									
									DaoGenerico::iniciarTrans();
									if(!$this->daoComprobante->incluir()){
										$this->mensaje .= '  CLASE->Editar Comprobate MÉTODO->procesar_comprobante_retencion ERROR->'.$this->conexionBaseDatos->ErrorMsg();
										$this->valido = false;
									}
									else{
										$k=0;
										$j=0;
										unset($aa_dt_cmp);
										$aa_dt_cmp = array();
										while($k<$li_totrows)
										{
											$arre_numcom[$k]["numcom"] = $numcom;
											$ls_numrecdoc = trim($documento[$k]["numrecdoc"]); 
											$ls_codtipdoc = $documento[$k]["codtipdoc"]; 
											$ls_fecha = $documento[$k]["fecemidoc"]; 
											$ls_basimpiva = $documento[$k]["basimpiva"];
											$ls_totconiva = $documento[$k]["totconiva"];
											$ls_monobjret = $documento[$k]["monobjret"];
											$ls_porcar = $documento[$k]["porcar"];
											$ls_totiva = $documento[$k]["totiva"];
											$ls_ivaret = $documento[$k]["ivaret"];
											$ls_numsop = $documento[$k]["numsop"];
											$ls_codded = $documento[$k]["codded"];
											$ls_codpro = $documento[$k]["cod_pro"];
											$ls_ced_bene= $documento[$k]["ced_bene"];
											$ls_numref = $documento[$k]["numref"];
											$ls_cuenta = $documento[$k]["cuenta"];
											$ls_tipdoctesnac = $documento[$k]["tipdoctesnac"];
											$ls_numope= agregarUno($k+1,10);
											$ls_totconiva=$ls_totconiva+$this->uf_buscar_monto_rdmanual($ls_codpro,$ls_numrecdoc,$as_tipproben);
											if($this->valido){
												if($aa_numcmp=="I")
												{
													$ls_totsiniva=$ls_totconiva-($ls_basimpiva+$ls_totiva);
												}
												else
												{
													$ls_totsiniva=$ls_totconiva-$ls_basimpiva;
												}
												$this->valido=$this->uf_validar_dt_rdmanual($ls_codpro,$ls_numrecdoc,$ls_cuenta,$as_tipproben);
												if($this->valido){
													$this->valido = $this->guardar_detallecmp($numcom,$codret,$ls_numope,$ls_fecha,$ls_numrecdoc,$ls_numref,'','',
													                                          "01-reg",$ls_totsiniva,$ls_totconiva,$ls_monobjret,$ls_porcar, 
																						      $ls_totiva,$ls_ivaret,"",$ls_numsop,"","",$ls_numrecdoc,"01");
												    if($this->valido){
												    	$this->valido = $this->actualizar_estcmp('CREAR',$ls_numrecdoc,$ls_codpro,$as_tipproben,$ls_codded,$ls_codtipdoc);
												    }
												}
												if(($this->valido)&&($codret=="0000000001"))
												{
													$this->valido=$this->uf_procesar_ndnc($ls_numsop,$ls_numrecdoc,$ls_codtipdoc,$ls_codpro,$ls_ced_bene,
																					      $i,$numcom,$ls_fecha,$ls_numref,$ls_codded);
												}
												$servicioEvento = new ServicioEvento();
												$servicioEvento->evento=$arrevento['evento'];
												$servicioEvento->codemp=$arrevento['codemp'];
												$servicioEvento->codsis=$arrevento['codsis'];
												$servicioEvento->nomfisico=$arrevento['nomfisico'];
												$servicioEvento->desevetra=$arrevento['desevetra'];
													
												//completando la transaccion retorna 1 si no hay errores
												if(DaoGenerico::completarTrans($this->valido)) {
													$servicioEvento->tipoevento=true;
												 	$servicioEvento->incluirEvento();	
												}
												else{
													$arrevento['desevetra'] = $this->daoComprobante->ErrorMsg();
													$servicioEvento->tipoevento=false;
													$servicioEvento->desevetra=$arrevento['desevetra'];
													$servicioEvento->incluirEvento();
												}
											}
											$k++;
											
										}
										if(trim($ls_codproalt)!='')
										{
											$this->valido=$this->uf_update_datos_proveedor($codret,$numcom,$ls_numsop,$ls_codproalt);
										}
									}
								}
							}
						}
						else{
							if($as_tipproben=='P'){
								if($i==0){
									$this->mensaje .= '  Los Proveedores '.$ls_codpro.$this->conexionBaseDatos->ErrorMsg();
								}
								else{
									$this->mensaje .= ', '.$ls_codpro.$this->conexionBaseDatos->ErrorMsg();
								}
							}
							elseif($as_tipproben=='B'){
								if($i==0){
									$this->mensaje .= '  Los Beneficiarios '.$ls_codpro.$this->conexionBaseDatos->ErrorMsg();
								}
								else{
									$this->mensaje .= ', '.$ls_codpro.$this->conexionBaseDatos->ErrorMsg();
								}
							}
						}
						$i++;
					}
				}
				else
				{
					$this->mensaje .= '  No existen documentos validos para realizar el proceso'.$this->conexionBaseDatos->ErrorMsg();
					$this->valido = false;
				}
			}
			else if($origenPan=='EDITAR'){
				$arrDetalle = $objson->detallesCmp;
				$ls_perfis = $objson->agno.$objson->fecha;
				$arrevento ['nomven']  = 'sigesp_vis_scb_modcmpret.html';
				$arrevento ['desevetra'] = 'Modifico el comprobante de retencion con el numero'.$objson->numcom.', asociado a la empresa '.$ls_codemp;
				$this->daoComprobante = FabricaDao::CrearDAO("N","scb_cmp_ret");
				$this->daoComprobante->codemp = $_SESSION["la_empresa"]["codemp"];
				$this->daoComprobante->codret = $codret;
				$this->daoComprobante->setData($objson);
				$this->daoComprobante->fecrep = convertirFechaBd($ls_fecact);
				$this->daoComprobante->perfiscal = $ls_perfis;
				$this->daoComprobante->nit = '---------------';
				$this->daoComprobante->estcmpret = '1'; 
				$this->daoComprobante->codusu = $_SESSION['la_logusr'];
				$this->daoComprobante->numlic = '';
				$this->daoComprobante->origen = 'A';
				DaoGenerico::iniciarTrans();
				if(!$this->daoComprobante->modificar()){
					$this->mensaje .= ' CLASE->Editar Comprobate MÉTODO->procesar_comprobante_retencion ERROR->'.$this->conexionBaseDatos->ErrorMsg();
					$this->valido = false;
				}
				else{
					$this->valido = $this->uf_delete_dt_cmpret($objson->numcom,$codret);
					if($this->valido){
						foreach($arrDetalle as $detalle){
							$this->valido = $this->guardar_detallecmp($objson->numcom,$codret,$detalle->numope,$detalle->fecfac,
																	  $detalle->numfac,$detalle->numcon,'','',"01-reg",
																	  $detalle->totcmp_sin_iva,$detalle->totcmp_con_iva,
																	  $detalle->basimp,$detalle->porimp,$detalle->totimp,
																	  $detalle->iva_ret,"",$detalle->numsop,"","",$detalle->numdoc,"01");
							if($this->valido){
							   	$this->valido = $this->actualizar_estcmp('EDITAR',$objson->numfac,$objson->codsujret,$objson->prov_bene,$codret,'');
							}
						}
					}
				}
				$servicioEvento = new ServicioEvento();
				$servicioEvento->evento=$arrevento['evento'];
				$servicioEvento->codemp=$arrevento['codemp'];
				$servicioEvento->codsis=$arrevento['codsis'];
				$servicioEvento->nomfisico=$arrevento['nomfisico'];
				$servicioEvento->desevetra=$arrevento['desevetra'];
					
				//completando la transaccion retorna 1 si no hay errores
				if(DaoGenerico::completarTrans($this->valido)){
					$servicioEvento->tipoevento=true;
				 	$servicioEvento->incluirEvento(); 		
				}
				else{
					$arrevento['desevetra'] = $this->daoComprobante->ErrorMsg();
					$servicioEvento->tipoevento=false;
					$servicioEvento->desevetra=$arrevento['desevetra'];
					$servicioEvento->incluirEvento();
				}
			}
		}
		else{
			$this->mensaje .= '  Verifique que el periodo y el mes de la empresa estén abiertos '.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $arre_numcom;
	}
	
	

//	/* (non-PHPdoc)
//	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()				LISTO
//	 */
//	public function buscar_provalt($as_codpro) 
//	{
//		$cadenasql = " SELECT nompro, dirpro, rifpro ".
//					 " FROM rpc_proveedor ".
//					 " WHERE cod_pro='$as_codpro'";
//					 
//		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
//	    $resultado = $conexionbd->Execute ( $cadenasql );
//	    if ($resultado===false)
//	    {
//			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
//	    }
//	    return $resultado;
//	}

	/* (non-PHPdoc)
	 * Funcion que genera una lista con proveedores o beneficiarios con posibilidad de 
	 * tener movimientos que ameriten la generacion de un comprobante de retencion 		
	 */
	public function load_proveedores_beneficiarios($ls_codemp, $codret, $as_mes, $as_agno, $as_probendesde, $as_probenhasta, $as_tipproben)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$this->valido = true;
		$ld_fecdes = trim($as_agno.'/'.$as_mes.'/01');								
		$ld_fechas  = trim(ultimoDiaMes($as_mes, $as_agno));
		$ls_selaux = $ls_tabla = $ls_sqlaux = "";
	
		if($as_tipproben=='P')
		{
		 	$ls_campo  = "cod_pro";
		 	$ls_tabla = "rpc_proveedor";
		 	$ls_selaux = "cxp_rd.cod_pro as cod_pro, max(rpc_proveedor.nompro) as nompro, max(rpc_proveedor.dirpro) as dirpro, max(rpc_proveedor.rifpro) as rifpro";
		}
		else if($as_tipproben=='B'){
		 	$ls_campo  = "ced_bene";
		 	$ls_tabla = "rpc_beneficiario";
		 	$ls_selaux = " cxp_rd.ced_bene as cod_pro, MAX(rpc_beneficiario.dirbene) as dirpro, MAX(rpc_beneficiario.rifben) as rifpro";
			switch ($_SESSION["ls_gestor"])
			{
				case "MYSQLT":
					$ls_selaux = $ls_selaux." ,CONCAT(rpc_beneficiario.nombene,rpc_beneficiario.apebene) AS nompro ";
					break;
				case "MYSQLI":
					$ls_selaux = $ls_selaux." ,CONCAT(rpc_beneficiario.nombene,rpc_beneficiario.apebene) AS nompro ";
					break;
				case "POSTGRES":
					$ls_selaux = $ls_selaux." ,(MAX(rpc_beneficiario.nombene)||MAX(rpc_beneficiario.apebene)) AS nompro ";
					break;
				case "OCI8PO":
					$ls_selaux = $ls_selaux." ,CONCAT(rpc_beneficiario.nombene,rpc_beneficiario.apebene) AS nompro ";
					break;
			}
		}
		
		if($codret=="I"){
				
			if(!empty($as_probendesde) && !empty($as_probenhasta))
		 	{
		 		$ls_sqlaux = " AND (cxp_rd.$ls_campo BETWEEN '".$as_probendesde."' AND '".$as_probenhasta."')";
		 	}
		 	$ls_sqlaux = $ls_sqlaux." AND cxp_rd.codemp=$ls_tabla.codemp ".
							  "    AND cxp_rd.$ls_campo=$ls_tabla.$ls_campo ".
							  "    AND cxp_rd_deducciones.codemp=$ls_tabla.codemp  ".
							  "    AND cxp_rd_deducciones.$ls_campo=$ls_tabla.$ls_campo ".					 
							  "	   AND cxp_rd.codemp=cxp_dt_solicitudes.codemp   ".
							  "	   AND cxp_rd.$ls_campo=cxp_dt_solicitudes.$ls_campo ".
		 	                  "    AND $ls_tabla.$ls_campo <> '----------'";
		 	
			$cadenasql = " SELECT $ls_selaux, MAX(cxp_rd.codproalt) as codproalt ".
					  	 " FROM cxp_solicitudes, cxp_dt_solicitudes, cxp_rd, cxp_rd_deducciones, sigesp_deducciones, cxp_sol_banco,".
						 "		scb_movbco, $ls_tabla ".
					 	 " WHERE cxp_rd.codemp = '".$ls_codemp."' ".
					   	 " AND scb_movbco.estmov = 'C' ".
					   	 " AND ((scb_movbco.codope = 'CH' AND scb_movbco.estbpd='P') OR (scb_movbco.codope = 'ND' AND scb_movbco.numcarord<>'')) ".
					     " AND (cxp_solicitudes.fecaprosol BETWEEN '".$ld_fecdes."' AND '".$ld_fechas."') ".
					     " AND sigesp_deducciones.iva=1 ".
					     " AND sigesp_deducciones.islr=0 ".
					     " AND sigesp_deducciones.estretmun=0 ".
					     " AND sigesp_deducciones.otras=0 ". $ls_sqlaux.
					     " AND cxp_solicitudes.codemp=cxp_dt_solicitudes.codemp ".
					     " AND cxp_solicitudes.numsol=cxp_dt_solicitudes.numsol ".				   
					     " AND cxp_dt_solicitudes.codemp=cxp_rd_deducciones.codemp ".
					     " AND cxp_dt_solicitudes.numrecdoc=cxp_rd_deducciones.numrecdoc ".
					     " AND cxp_dt_solicitudes.codtipdoc=cxp_rd_deducciones.codtipdoc ".
					     " AND cxp_dt_solicitudes.cod_pro=cxp_rd_deducciones.cod_pro ".
					     " AND cxp_dt_solicitudes.ced_bene=cxp_rd_deducciones.ced_bene ".				   
					     " AND cxp_rd.codemp=cxp_rd_deducciones.codemp ".
					     " AND cxp_rd.numrecdoc=cxp_rd_deducciones.numrecdoc ".
					     " AND cxp_rd.codtipdoc=cxp_rd_deducciones.codtipdoc ".
					     " AND cxp_rd.cod_pro=cxp_rd_deducciones.cod_pro ".
					     " AND cxp_rd.ced_bene=cxp_rd_deducciones.ced_bene ".
					     " AND cxp_rd_deducciones.codemp=sigesp_deducciones.codemp ".
					     " AND cxp_rd_deducciones.codded=sigesp_deducciones.codded ".
					     " AND cxp_sol_banco.codemp=cxp_solicitudes.codemp ".
					     " AND cxp_sol_banco.numsol=cxp_solicitudes.numsol ".
					     " AND cxp_sol_banco.codemp=cxp_dt_solicitudes.codemp ".
					     " AND cxp_sol_banco.numsol=cxp_dt_solicitudes.numsol ".				   
					     " AND cxp_sol_banco.codemp=scb_movbco.codemp ".
					     " AND cxp_sol_banco.codban=scb_movbco.codban ".
					     " AND cxp_sol_banco.ctaban=scb_movbco.ctaban ".				   
					     " AND cxp_sol_banco.estmov=scb_movbco.estmov ".
					     " AND cxp_sol_banco.codope=scb_movbco.codope ".
					 	 " GROUP BY cxp_rd.$ls_campo ";
		}
		else if($codret=="M"){
			$cadenasql=" SELECT MAX(cxp_rd_deducciones.codded) AS codded,MAX(cxp_rd_deducciones.numrecdoc) AS numrecdoc, ".
			           "        $ls_selaux,cxp_rd.codproalt".
			           " FROM sigesp_deducciones,cxp_rd_deducciones,cxp_rd,  ".
					   "      cxp_dt_solicitudes,cxp_solicitudes,$ls_tabla".
					   " WHERE (sigesp_deducciones.codemp='".$ls_codemp."') AND (sigesp_deducciones.codemp=cxp_rd_deducciones.codemp) ".
			           "   AND (sigesp_deducciones.codemp=cxp_rd.codemp)". 
					   "   AND (sigesp_deducciones.codemp=$ls_tabla.codemp) AND (sigesp_deducciones.codemp=cxp_dt_solicitudes.codemp) ".
			           "   AND (sigesp_deducciones.codemp=cxp_solicitudes.codemp)".
					   "   AND (sigesp_deducciones.estretmun=1) AND (sigesp_deducciones.codded=cxp_rd_deducciones.codded)  ".
			           "   AND (cxp_rd_deducciones.numrecdoc=cxp_rd.numrecdoc) AND cxp_rd_deducciones.estcmp='0' AND".
					   "       (cxp_rd.$ls_campo BETWEEN '".$as_probendesde."' AND '".$as_probenhasta."') AND".
					   "       (cxp_rd.$ls_campo=$ls_tabla.$ls_campo) AND (cxp_rd_deducciones.$ls_campo=cxp_rd.$ls_campo)  ". 
			           "   AND (cxp_rd_deducciones.codtipdoc=cxp_rd.codtipdoc)".
					   "   AND (cxp_solicitudes.fecaprosol BETWEEN '".$ld_fecdes."' AND '".$ld_fechas."') AND (cxp_rd.estprodoc='C') AND".
					   "       (cxp_rd.numrecdoc=cxp_dt_solicitudes.numrecdoc) AND (cxp_rd.$ls_campo=cxp_dt_solicitudes.$ls_campo) ".
			           "   AND (cxp_dt_solicitudes.numsol=cxp_solicitudes.numsol)".
					   " GROUP BY cxp_rd.$ls_campo,cxp_rd.codproalt";
		}
		else if($codret=="1"){
			$cadenasql="SELECT MAX(cxp_rd_deducciones.codded) AS codded,MAX(cxp_rd_deducciones.numrecdoc) AS numrecdoc,".
		           	"          $ls_selaux,cxp_rd.codproalt ".
		            "   FROM sigesp_deducciones,cxp_rd_deducciones,cxp_rd,".
				    "        cxp_dt_solicitudes,cxp_solicitudes,$ls_tabla".
				    "   WHERE sigesp_deducciones.codemp='".$ls_codemp."'".
				   	"     AND sigesp_deducciones.codemp=cxp_rd_deducciones.codemp".
				   	"     AND sigesp_deducciones.codemp=cxp_rd.codemp". 
				   	"     AND sigesp_deducciones.codemp=$ls_tabla.codemp".
				   	"     AND sigesp_deducciones.codemp=cxp_dt_solicitudes.codemp".
				   	"     AND sigesp_deducciones.codemp=cxp_solicitudes.codemp".
				   	"     AND sigesp_deducciones.estretmil='1'".
				   	"     AND cxp_rd_deducciones.estcmp='0'".
				   	"     AND sigesp_deducciones.codded=cxp_rd_deducciones.codded".
				   	"     AND cxp_rd_deducciones.numrecdoc=cxp_rd.numrecdoc".
				   	"     AND (cxp_rd.$ls_campo BETWEEN '".$as_probendesde."' AND '".$as_probenhasta."')".
				   	"     AND cxp_rd.$ls_campo=$ls_tabla.$ls_campo".
				   	"     AND cxp_rd_deducciones.$ls_campo=cxp_rd.$ls_campo".
				   	"     AND cxp_rd_deducciones.codtipdoc=cxp_rd.codtipdoc".
				   	"     AND (cxp_solicitudes.fecaprosol BETWEEN '".$ld_fecdes."' AND '".$ld_fechas."')".
				   	"     AND cxp_rd.estprodoc='C'".
				   	"     AND cxp_rd.numrecdoc=cxp_dt_solicitudes.numrecdoc".
				   	"     AND cxp_rd.$ls_campo=cxp_dt_solicitudes.$ls_campo".
				   	"     AND cxp_dt_solicitudes.numsol=cxp_solicitudes.numsol".
				   	"   GROUP BY cxp_rd.$ls_campo,cxp_rd.codproalt";
		}
		$resultado = $this->conexionBaseDatos->Execute($cadenasql);
	    if ($resultado===false)
	    {
			$this->mensaje .= '  CLASE->Editar Comprobate MÉTODO->load_proveedores_beneficiarios ERROR->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
	    }
	    return $resultado;
	}

//	function uf_rep_cur_pagos($ld_fecdesde, $ld_fechasta, $as_tipproben, $ls_codproben, $codret)
//	{
//		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
//		$this->valido=true;
//		$ls_filt = " AND monret>0 ";
//		if($as_tipproben=='P')
//		{
//		 	$ls_campo = "cod_pro";
//		 	$ls_condicion = "AND (BRH.codope='CH' OR BRH.codope='ND')";
//		}
//		else if($as_tipproben=='B'){
//		 	$ls_campo = "ced_bene";
//		 	$ls_condicion = "AND BRH.codope='CH' ";
//		}
//		
//		$ls_sql=" SELECT BRH.numdoc as numdoc, BRH.fecmov as fecmov, XSC.numsol as numsol, XSC.monto as monto, ".
//			    "        BRH.codban as codban,BRH.ctaban as ctaban,BRH.codope as codope ".
//				" FROM scb_movbco BRH  ".
//			  	" LEFT OUTER JOIN  cxp_sol_banco XSC ". 
//				"	ON (BRH.codban=XSC.codban ".
//				"	AND BRH.ctaban=XSC.ctaban ".
//				"	AND BRH.numdoc=XSC.numdoc ".
//				"	AND BRH.codope=XSC.codope ".
//				"	AND BRH.estmov=XSC.estmov ".
//				"	AND BRH.codemp=XSC.codemp)  ". 
//				" WHERE BRH.codemp='".$_SESSION["la_empresa"]["codemp"]."' $ls_condicion  ".
//				"   AND BRH.estmov='C' ".
//				"	AND BRH.$ls_campo='".$ls_codproben."' ".  
//				"	AND BRH.fecmov between '".$ld_fecdesde."' AND '".$ld_fechasta."' ".
//				"	AND BRH.numdoc NOT IN (SELECT d.numdoc ". 
//				"		                   FROM scb_dt_cmp_ret d, scb_cmp_ret c ". 
//				"						   WHERE d.codret='".$codret."' ".
//				"			                 AND d.codemp='".$_SESSION["la_empresa"]["codemp"]."' ". 
//				"							 AND d.codret=c.codret ".
//				"							 AND d.codemp=c.codemp ".
//				"							 AND c.numcom= d.numcom ".
//				"							 AND c.estcmpret<>2) ".$ls_filt;
//
//		$resultado = $this->conexionBaseDatos->Execute($ls_sql);
//		if($resultado===false)
//		{
//			$this->mensaje = "No hay pagos en el periodo para el Proveedor/Beneficiario $ls_codproben";
//			$this->valido=false;
//		}
//		return $this->valido;
//	}
	
	/* (non-PHPdoc)
	  Funcion que genera una lista con proveedores o beneficiarios con posibilidad de tener movimientos
	  que ameriten la generacion de un comprobante de retencion  					
	 */
	public function get_documento($as_mes,$as_agno,$as_codprobene,$as_tipproben,$as_tiporet,$as_codproalt,$codret)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$ld_fecdes = trim($as_agno.'/'.$as_mes.'/01');								
		$ld_fechas = trim(ultimoDiaMes($as_mes, $as_agno));	
		$ls_joinalt = "";
		
		if(trim($as_codproalt)!=''){
			$ls_joinalt="AND (cxp_rd.codproalt='".$as_codproalt."')";
		}
		if($as_tipproben=='P'){
			$ls_campo = "cod_pro";
		}
		if($as_tipproben=='B'){
			$ls_campo = "ced_bene";
		}
		switch (strtoupper($_SESSION["ls_gestor"]))
		{
			
			case "MYSQLT":
				if($as_tiporet=='I')
				{	   	   
				  $ls_id="CONCAT(cxp_rd.numrecdoc,cxp_rd_cargos.porcar)";
				}
				else
				{
				  $ls_id="CONCAT(cxp_rd.numrecdoc,cxp_rd_deducciones.porded)";
				}
				break;

			case "MYSQLI":
				if($as_tiporet=='I')
				{	   	   
				  $ls_id="CONCAT(cxp_rd.numrecdoc,cxp_rd_cargos.porcar)";
				}
				else
				{
				  $ls_id="CONCAT(cxp_rd.numrecdoc,cxp_rd_deducciones.porded)";
				}
				break;

			case "POSTGRES":
				if($as_tiporet=='I')
				{	   	   
				  $ls_id="cxp_rd.numrecdoc||cxp_rd_cargos.porcar";
				}
				else
				{
				  $ls_id="cxp_rd.numrecdoc||cxp_rd_deducciones.porded";
				}
				break;
			case "OCI8PO":
				if($as_tiporet=='I')
				{	   	   
				  $ls_id="CONCAT(cxp_rd.numrecdoc,cxp_rd_cargos.porcar)";
				}
				else
				{
				  $ls_id="CONCAT(cxp_rd.numrecdoc,cxp_rd_deducciones.porded)";
				}
				break;
		}  
		if($as_tiporet=='I'){
			$cadenasql = "SELECT ".$ls_id." as id,cxp_rd.numrecdoc,cxp_rd.fecemidoc,SUM(cxp_rd_cargos.monobjret) AS basimpiva,  ".
			          "          MAX(cxp_rd.codproalt) as codproalt,MAX(cxp_rd.montotdoc+cxp_rd.mondeddoc) AS totconiva, ".
			          "          SUM(cxp_rd_cargos.monobjret) AS monobjret,MAX(cxp_rd_cargos.porcar) AS porcar, ".
			          "          SUM(cxp_rd_cargos.monret) AS totiva,MAX(cxp_rd_deducciones.monret) AS ivaret, ".
			          "          cxp_dt_solicitudes.numsol as numsop, ".
			          "          cxp_rd_deducciones.codded,MAX(cxp_rd_deducciones.sc_cuenta) as cuenta, ".
					  "          cxp_rd.numref, MAX(cxp_rd.codtipdoc) as codtipdoc ,MAX(cxp_rd.cod_pro) as cod_pro, ".
			          "          MAX(cxp_rd.ced_bene) as  ced_bene,MAX(cxp_rd.codemp), MAX(cxp_rd.tipdoctesnac) as  tipdoctesnac".
					  "   FROM sigesp_deducciones,cxp_rd_deducciones,cxp_rd,cxp_rd_cargos,cxp_dt_solicitudes,cxp_solicitudes".
                      "   WHERE (sigesp_deducciones.codemp='".$_SESSION["la_empresa"]["codemp"]."') ".
			          "   	AND (sigesp_deducciones.codemp=cxp_rd_deducciones.codemp) ". 
			          "   	AND (sigesp_deducciones.codemp=cxp_rd.codemp) ".
			          "   	AND (sigesp_deducciones.codemp=cxp_rd_cargos.codemp)  ".
			          "   	AND (sigesp_deducciones.codemp=cxp_dt_solicitudes.codemp) ".
			          "   	AND (sigesp_deducciones.codemp=cxp_solicitudes.codemp) AND (sigesp_deducciones.iva=1) ".
			          "   	AND (sigesp_deducciones.codded=cxp_rd_deducciones.codded) ".
			          "   	AND (cxp_rd_deducciones.estcmp='0') ".
			          "   	AND (cxp_rd_deducciones.numrecdoc=cxp_rd.numrecdoc) AND (cxp_rd_cargos.numrecdoc=cxp_rd.numrecdoc ) ".
			          "   	AND (cxp_rd_deducciones.codtipdoc=cxp_rd.codtipdoc)".
					  "   	AND (cxp_rd_deducciones.$ls_campo='".$as_codprobene."') AND (cxp_rd_deducciones.$ls_campo=cxp_rd.$ls_campo) ".
					  "   	AND (cxp_rd_cargos.$ls_campo=cxp_rd.$ls_campo)". 
                      "   	AND (cxp_solicitudes.fecaprosol BETWEEN '".$ld_fecdes."' AND '".$ld_fechas."')AND (cxp_rd.estprodoc='C')".
					  $ls_joinalt.  
					  "  	AND (cxp_rd.numrecdoc=cxp_dt_solicitudes.numrecdoc) AND (cxp_rd.$ls_campo=cxp_dt_solicitudes.$ls_campo) ".
					  "  	AND (cxp_dt_solicitudes.numsol=cxp_solicitudes.numsol) ".
					  "  	AND (cxp_solicitudes.estprosol<>'A') AND (cxp_solicitudes.estprosol<>'N') ".
					  "  	AND cxp_dt_solicitudes.codemp=cxp_rd.codemp".
					  "  	AND cxp_dt_solicitudes.numrecdoc=cxp_rd.numrecdoc".
					  "  	AND cxp_dt_solicitudes.codtipdoc=cxp_rd.codtipdoc".
					  "  	AND cxp_dt_solicitudes.cod_pro=cxp_rd.cod_pro".
					  " 	AND cxp_dt_solicitudes.ced_bene=cxp_rd.ced_bene".
					  "   GROUP by ".$ls_id.",cxp_rd.numrecdoc,cxp_rd.fecemidoc,cxp_dt_solicitudes.numsol,cxp_rd_deducciones.codded,cxp_rd.numref ";
		}
		else if($as_tiporet=='M'){
			$cadenasql =" SELECT ".$ls_id." as id,cxp_rd.numrecdoc,cxp_rd.fecemidoc,SUM(cxp_rd_deducciones.monobjret) AS basimpiva, ".
			            "        MAX(cxp_rd.codproalt) as codproalt,MAX(cxp_rd.montotdoc+cxp_rd.mondeddoc) AS totconiva,  ".
			            "        SUM(cxp_rd_deducciones.monobjret) AS monobjret,MAX(cxp_rd_deducciones.porded) AS porcar,  ".
			            "        SUM(cxp_rd_deducciones.monret) AS totiva,MAX(cxp_rd_deducciones.monret) AS ivaret,  ".
			            "        cxp_dt_solicitudes.numsol as numsop,cxp_rd_deducciones.codded,MAX(cxp_rd_deducciones.sc_cuenta) as cuenta, ".
					    "        cxp_rd.numref, MAX(cxp_rd.codtipdoc) as codtipdoc ,MAX(cxp_rd.cod_pro) as cod_pro, MAX(cxp_rd.ced_bene) as  ced_bene,".
					    "        MAX(cxp_rd.codemp), MAX(cxp_rd.tipdoctesnac) as  tipdoctesnac ".
					    " FROM sigesp_deducciones,cxp_rd_deducciones,cxp_rd,cxp_dt_solicitudes,cxp_solicitudes ".
					    " WHERE (sigesp_deducciones.codemp='".$_SESSION["la_empresa"]["codemp"]."') ".
			            "   AND (sigesp_deducciones.codemp=cxp_rd_deducciones.codemp) ".
			            "   AND (sigesp_deducciones.codemp=cxp_rd.codemp) ".
					        $ls_joinalt. 
					    "   AND (sigesp_deducciones.codemp=cxp_solicitudes.codemp)   ".
					    "   AND (sigesp_deducciones.codemp=cxp_dt_solicitudes.codemp ) ".
					    "   AND (sigesp_deducciones.estretmun=1)  ".
					    "	AND (sigesp_deducciones.codded=cxp_rd_deducciones.codded)".
					    "   AND (cxp_rd_deducciones.estcmp='0') ".
					    "	AND (cxp_rd_deducciones.numrecdoc=cxp_rd.numrecdoc)  ".
					    "   AND (cxp_rd_deducciones.codtipdoc=cxp_rd.codtipdoc) ".
					    "   AND (cxp_rd_deducciones.$ls_campo='".$as_codprobene."') ".
					    "   AND (cxp_rd_deducciones.$ls_campo=cxp_rd.$ls_campo) ".
					    "   AND (cxp_solicitudes.fecaprosol BETWEEN '".$ld_fecdes."' AND '".$ld_fechas."')  ".
					    "   AND (cxp_rd.estprodoc='C') AND (cxp_rd.numrecdoc=cxp_dt_solicitudes.numrecdoc)  ".
					    "   AND (cxp_rd.$ls_campo=cxp_dt_solicitudes.$ls_campo) ". 
					    "	AND (cxp_dt_solicitudes.numsol=cxp_solicitudes.numsol) ".
					    "   AND (cxp_solicitudes.estprosol<>'A')  ".
					    "	AND (cxp_solicitudes.estprosol<>'N')".
					  	"   AND cxp_dt_solicitudes.codemp=cxp_rd.codemp ".
					  	"	AND cxp_dt_solicitudes.numrecdoc=cxp_rd.numrecdoc".
					  	"   AND cxp_dt_solicitudes.codtipdoc=cxp_rd.codtipdoc ".
					  	"	AND cxp_dt_solicitudes.cod_pro=cxp_rd.cod_pro".
					  	"   AND cxp_dt_solicitudes.ced_bene=cxp_rd.ced_bene".
					 	" GROUP by ".$ls_id.",cxp_rd.numrecdoc,cxp_rd.fecemidoc,cxp_rd_deducciones.porded, ".
					    "          cxp_dt_solicitudes.numsol,cxp_rd_deducciones.codded,cxp_rd.numref ";
		}
		else if($as_tiporet=='1'){
			$cadenasql ="SELECT ".$ls_id." as id,cxp_rd.numrecdoc,cxp_rd.fecemidoc,SUM(cxp_rd_deducciones.monobjret) AS basimpiva,  ".
			         "       	MAX(cxp_rd.codproalt) as codproalt,MAX(cxp_rd.montotdoc+cxp_rd.mondeddoc) AS totconiva,  ".
			         "       	SUM(cxp_rd_deducciones.monobjret) AS monobjret,MAX(cxp_rd_deducciones.porded) AS porcar,  ".
			         "       	0 AS totiva,MAX(cxp_rd_deducciones.monret) AS ivaret,cxp_dt_solicitudes.numsol as numsop, ".
					 "       	cxp_rd_deducciones.codded,MAX(cxp_rd_deducciones.sc_cuenta) as cuenta,  ".
			         "       	cxp_rd.numref, MAX(cxp_rd.tipdoctesnac) as  tipdoctesnac ".
					 " 	 FROM sigesp_deducciones,cxp_rd_deducciones,cxp_rd,cxp_dt_solicitudes,cxp_solicitudes ".
					 "   WHERE sigesp_deducciones.codemp='".$_SESSION["la_empresa"]["codemp"]."'".
					 "     AND sigesp_deducciones.codemp=cxp_rd_deducciones.codemp".
					 "     AND sigesp_deducciones.codemp=cxp_rd.codemp".
					 "     AND sigesp_deducciones.codemp=cxp_solicitudes.codemp".
					 "     AND sigesp_deducciones.codemp=cxp_dt_solicitudes.codemp".
					 "     AND sigesp_deducciones.retaposol=1".
					 "     AND sigesp_deducciones.codded=cxp_rd_deducciones.codded".
					 "     AND cxp_rd_deducciones.estcmp='0'".
					       $ls_joinalt.
					 "     AND cxp_rd_deducciones.numrecdoc=cxp_rd.numrecdoc".
					 "     AND cxp_rd_deducciones.codtipdoc=cxp_rd.codtipdoc ".
					 "     AND cxp_rd_deducciones.$ls_campo='".$as_codprobene."'".
					 "     AND (cxp_rd_deducciones.$ls_campo=cxp_rd.$ls_campo) ". 
					 "     AND (cxp_solicitudes.fecaprosol BETWEEN '".$ld_fecdes."' AND '".$ld_fechas."')".
					 "     AND cxp_rd.estprodoc='C'". 
					 "     AND cxp_rd.numrecdoc=cxp_dt_solicitudes.numrecdoc".
					 "     AND cxp_rd.$ls_campo=cxp_dt_solicitudes.$ls_campo".
					 "     AND cxp_dt_solicitudes.numsol=cxp_solicitudes.numsol".
					 "     AND cxp_solicitudes.estprosol<>'A'  AND cxp_solicitudes.estprosol<>'N'".
					 "     AND cxp_dt_solicitudes.codemp=cxp_rd.codemp".
					 "     AND cxp_dt_solicitudes.numrecdoc=cxp_rd.numrecdoc".
					 "     AND cxp_dt_solicitudes.codtipdoc=cxp_rd.codtipdoc".
					 "     AND cxp_dt_solicitudes.cod_pro=cxp_rd.cod_pro".
					 "     AND cxp_dt_solicitudes.ced_bene=cxp_rd.ced_bene".
					 "   GROUP by ".$ls_id.",cxp_rd.numrecdoc,cxp_rd.fecemidoc,cxp_rd_deducciones.porded, ".
					 "            cxp_dt_solicitudes.numsol,cxp_rd_deducciones.codded,cxp_rd.numref ";
		}
		$resultado = $this->conexionBaseDatos->Execute($cadenasql);
	    if($resultado===false)
	    {
			$this->mensaje .= ' CLASE->Crear Comprobate MÉTODO->get_documento ERROR->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
	    }	
		return $resultado;
	}


	/* (non-PHPdoc)
	 * Funcion que genera el nuemero del comprobante
	 */
	public function get_nrocomprobante($as_periodofiscal, $codret, $ld_fecdesde, $ld_fechasta, $ls_tipo, $ls_codproben)
	{
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$this->valido = true;
		
		if($this->valido){
			$cadenasql = " SELECT SUBSTR(numcom,7,9) as numcom ".
						 " FROM scb_cmp_ret ".
						 " WHERE codemp='".$_SESSION["la_empresa"]["codemp"]."' ".
						 "   AND codret='{$codret}' ".
						 " ORDER BY numcom DESC LIMIT 1";
			
			$resultado = $conexionbd->Execute($cadenasql);
			if($resultado->fields['numcom']=='')
		    {
				$this->mensaje .= ' CLASE->Crear Comprobate MÉTODO->get_nrocomprobante ERROR->'.$conexionbd->ErrorMsg();
				$this->valido = false;
		    }
			else
			{
				$codigo = $resultado->fields['numcom'];
				if($codigo!=''){
					$codigo = agregarUno($codigo,8);
					$codigo = $as_periodofiscal.$codigo;	
				}
			}
		}
		return $codigo;
	}

	/* (non-PHPdoc)
	 * Funcion que inserta los detalles del comprobante
	 */
	public function guardar_detallecmp($as_numcom,$codret,$as_numope,$as_fecfac,$as_numfac,$as_numcon,$as_numnd,
									   $as_numnc,$as_tiptrans,$as_tot_cmp_sin_iva,$as_tot_cmp_con_iva,$as_basimp,
									   $as_porimp,$as_totimp,$as_ivaret,$as_desope,$as_numsop,$as_codban,$as_ctaban,
									   $as_numdoc,$as_codope)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$this->valido=true;
		$this->daoDetalle = FabricaDao::CrearDAO("N","scb_dt_cmp_ret");
		$this->daoDetalle->codemp = $_SESSION["la_empresa"]["codemp"];
		$this->daoDetalle->codret = $codret;
		$this->daoDetalle->numcom = $as_numcom;
		$this->daoDetalle->numope = $as_numope;
		$this->daoDetalle->fecfac = convertirFechaBd($as_fecfac);
		$this->daoDetalle->numfac = $as_numfac;
		$this->daoDetalle->numcon = $as_numcon;
		$this->daoDetalle->numnd = $as_numnd;
		$this->daoDetalle->numnc = $as_numnc;
		$this->daoDetalle->tiptrans = $as_tiptrans;
		$this->daoDetalle->totcmp_sin_iva = formatoNumericoBd($as_tot_cmp_sin_iva); 
		$this->daoDetalle->totcmp_con_iva = formatoNumericoBd($as_tot_cmp_con_iva);
		$this->daoDetalle->basimp = formatoNumericoBd($as_basimp);
		$this->daoDetalle->porimp = formatoNumericoBd($as_porimp);
		$this->daoDetalle->totimp = formatoNumericoBd($as_totimp);
		$this->daoDetalle->iva_ret = formatoNumericoBd($as_ivaret);
		$this->daoDetalle->desope = $as_desope;
		$this->daoDetalle->numsop = $as_numsop;
		$this->daoDetalle->codban = $as_codban;
		$this->daoDetalle->ctaban = $as_ctaban;
		$this->daoDetalle->numdoc = $as_numdoc;
		$this->daoDetalle->codope = $as_codope;
		$this->daoDetalle->tipdoctesnac = 0;
		if(!$this->daoDetalle->incluir()){
			$this->mensaje .= ' ERROR al incluir el detalle del comprobante->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $this->valido;
	}

	/* (non-PHPdoc)
	 * Funcion que actualiza el estatus del comprobante
	 */
	public function actualizar_estcmp($origenPan,$as_numrecdoc, $as_codprobene, $as_tipproben, $as_codded, $as_codtipdoc)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$this->valido = true;
		if($origenPan=='CREAR'){
			if($as_tipproben == "P")
			{
				$ls_filtro = "cod_pro='".$as_codprobene."' AND ced_bene='----------'";
			}
			else if($as_tipproben = "B")
			{
				$ls_filtro = "ced_bene='".$as_codprobene."' AND cod_pro='----------'";
			}
			$ls_sql="UPDATE cxp_rd_deducciones  ".
				    "SET estcmp='1'  ".
				  	"WHERE codemp='".$_SESSION["la_empresa"]["codemp"]."' ".
				    "   AND numrecdoc='".$as_numrecdoc."'  ".
				    "   AND $ls_filtro ".
				    "   AND codded='".$as_codded."' ".
					"   AND codtipdoc = '".$as_codtipdoc."'";
		}
		else if($origenPan=='EDITAR'){
			if($as_codded=="0000000001"){
				$cadena = " codded IN (SELECT codded FROM sigesp_deducciones WHERE iva='1') ";
			}
			else if($as_codded=="0000000003")
			{
				$cadena = " codded IN (SELECT codded FROM sigesp_deducciones WHERE estretmun='1') ";
			}
			else if($as_codded=="0000000005")
			{
			 	$cadena = " codded IN (SELECT codded FROM sigesp_deducciones WHERE estretmil='1') ";
			}
			$ls_sql="UPDATE cxp_rd_deducciones  ".
					"SET estcmp='1' ".
			        "WHERE codemp='".$_SESSION["la_empresa"]["codemp"]."'  ".
					"  AND numrecdoc='".$as_numrecdoc."' ". 
					"  AND ".$cadena;
		}
		$resultado = $this->conexionBaseDatos->Execute($ls_sql);
	    if ($resultado===false)
	    {
			$this->mensaje .= '  Error al actualizar el estatus del comprobante de cxp_rd_deducciones->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
	    }
	    return $this->valido;
	}

//	/* (non-PHPdoc)
//	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()				LISTO
//	 */
//	public function load_numeroinicial()
//	{
//		$ls_concomiva = 1;
//		$cadenasql= " SELECT concomiva ".
//					" FROM sigesp_empresa ".
//					" WHERE codemp='".$_SESSION["la_empresa"]["codemp"]."'";
//		
//	    $conexionbd = ConexionBaseDatos::getInstanciaConexion();
//	    $resultado = $conexionbd->Execute ( $cadenasql );
//	    if ($resultado===false)
//	    {
//			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
//	    }
//		else
//		{
//			$ls_concomiva = $resultado->fields["concomiva"];
//		}
//	//	unset $resultado;
//		return $ls_concomiva;
//	}
	
	/* (non-PHPdoc)
	 * Funcion que valida un grupo de detalles en el caso de las recepciones manuales
	 */
	function uf_validar_rdmanual($as_codprobene,$aa_rd,$as_tipo)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		if($as_tipo=="P"){
		   $ls_filtro="cod_pro='".$as_codprobene."'";
		}
		else if($as_tipo="B"){
		   $ls_filtro="ced_bene='".$as_codprobene."'";
		}

        for($j=0;$j<count($aa_rd);$j++)
		{
			$ls_coddoc=$aa_rd[$j]["numrecdoc"];
			$ls_sql=" SELECT numrecdoc ".
					" FROM cxp_rd_scg ". 
					" WHERE codemp='".$_SESSION["la_empresa"]["codemp"]."'".
					"   AND numrecdoc='".$ls_coddoc."'". 
					"   AND ".$ls_filtro."".
					"   AND (estasicon='M' OR estasicon='A')".
					"   AND debhab='H'";
			$resultado = $this->conexionBaseDatos->Execute($ls_sql);
		    if ($resultado===false)
		    {
				$this->mensaje .= '  CLASE->Editar Comprobate MÉTODO->que valida la recepcion de documento ERROR->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido = false;
		    }
		    else{
		    	if(!$resultado->EOF){
		    		$this->valido=true;
		    	}
		    }
		}
		return $this->valido;	
	}
	
	/* (non-PHPdoc)
	 * Funcion que ubica el monto de el detalle manual incluido por el haber para balancear
	 * el monto total presentado en el comprobante
	 */	
	function uf_buscar_monto_rdmanual($as_codprobene,$as_numrd,$as_tipo)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
	    $ld_monto=0;
		if($as_tipo=="P"){
		   $ls_filtro="cod_pro='".$as_codprobene."'";
		}
		else if($as_tipo="B"){
		   $ls_filtro="ced_bene='".$as_codprobene."'";
		}
		
		$ls_sql="SELECT SUM(monto) AS monto ". 
		        "FROM cxp_rd_scg ".
			    "WHERE codemp='".$_SESSION["la_empresa"]["codemp"]."'".
				"  AND numrecdoc='".$as_numrd."'". 
				"  AND ".$ls_filtro."".
				"  AND estasicon='M'".
				"  AND debhab='H'";
		
		$resultado = $this->conexionBaseDatos->Execute($ls_sql);		
		if($resultado->fields['monto']!='')
		{
			$ld_monto=$resultado->fields['monto'];
		}
		return $ld_monto;	
	}
	
	/* (non-PHPdoc)
	 * Funcion que valida un grupo de detalles en el caso de las recepciones manuales
	 */
	function uf_validar_dt_rdmanual($as_codprobene,$as_numrd,$as_cuenta,$as_tipo)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
	    if($as_tipo=="P"){
		   $ls_filtro="cod_pro='".$as_codprobene."'";
		}
		else if($as_tipo="B"){
		   $ls_filtro="ced_bene='".$as_codprobene."'";
		}
		$ls_sql="SELECT estasicon,debhab ". 
		        "FROM cxp_rd_scg ".
			    "WHERE codemp='".$_SESSION["la_empresa"]["codemp"]."'".
				"  AND numrecdoc='".$as_numrd."'". 
				"  AND ".$ls_filtro."".
				"  AND sc_cuenta='".$as_cuenta."'";
		
		$resultado = $this->conexionBaseDatos->Execute($ls_sql);
		if($resultado===false)
		{
			$this->mensaje .= ' CLASE->Editar Comprobate MÉTODO->uf_validar_dt_rdmanual ERROR->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido=false;
		}
		else
		{
			if(!$resultado->EOF){
				$ls_estasi=$resultado->fields['estasicon'];
				$ls_debhab=$resultado->fields['debhab'];
				if($ls_estasi=='A')
				{
					$this->valido=true;  
				}
				else if($ls_estasi=='M')
				{
					if($ls_debhab=='D')
					{
						$this->valido=true;  
					} 
				}
			}
		}
		return $this->valido;	
	}
	
	/* (non-PHPdoc)
	 * Funcion que verifica si existen notas de debito o credito asociadas al pago
	 */
	function uf_procesar_ndnc($as_numsop,$as_coddoc,$as_codtipdoc,$as_cod_pro,$as_ced_bene,$ai_i,$as_nrocomp,$as_fecha,$as_numref,$as_codded)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$this->valido=true;
		$ls_sql="SELECT cxp_sol_dc.codope,cxp_sol_dc.numrecdoc,cxp_sol_dc.numdc,cxp_sol_dc.fecope,cxp_sol_dc.monto, ".
				"       cxp_sol_dc.moncar,cxp_dc_cargos.porcar ".
				"FROM cxp_sol_dc,cxp_dc_cargos ".
				"WHERE cxp_sol_dc.codemp='".$_SESSION["la_empresa"]["codemp"]."' ".
				"  AND cxp_sol_dc.numsol='".$as_numsop."' ".
				"  AND cxp_sol_dc.numrecdoc='".$as_coddoc."' ".
				"  AND cxp_sol_dc.codtipdoc='".$as_codtipdoc."' ".
				"  AND cxp_sol_dc.cod_pro='".$as_cod_pro."' ".
				"  AND cxp_sol_dc.ced_bene='".$as_ced_bene."' ".
				"  AND cxp_sol_dc.estnotadc='C' ".
				"  AND cxp_sol_dc.codemp=cxp_dc_cargos.codemp ".
				"  AND cxp_sol_dc.numsol=cxp_dc_cargos.numsol ".
				"  AND cxp_sol_dc.numrecdoc=cxp_dc_cargos.numrecdoc ".
				"  AND cxp_sol_dc.ced_bene=cxp_dc_cargos.ced_bene ".
				"  AND cxp_sol_dc.cod_pro=cxp_dc_cargos.cod_pro ".
				"  AND cxp_sol_dc.codope=cxp_dc_cargos.codope ".
				"  AND cxp_sol_dc.numdc=cxp_dc_cargos.numdc ";
		
		$resultado = $this->conexionBaseDatos->Execute($ls_sql);
		if($resultado===false)
		{
			$this->mensaje .= '  CLASE->Crear Comprobate MÉTODO->uf_procesar_ndnc ERROR->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido=false;
		}
		else
		{
			while(!$resultado->EOF)
			{
				$ai_i=$ai_i+1;
				$ls_codope=$resultado->fields['codope'];
				$ls_numdc=$resultado->fields['numdc'];
				$ld_fecope=$resultado->fields['fecope'];
				$li_monto=$resultado->fields['monto'];
				$li_moncar=$resultado->fields['moncar'];
				$ls_porcar=$resultado->fields['porcar'];
				$li_basimp=$li_monto-$li_moncar;
				$ls_numope=agregarUno($ai_i,10);
				if($ls_codope=="NC")
				{
					$ls_numnd="";
					$ls_numnc=$ls_numdc;
					$li_monto=$li_monto*(-1);
					$li_basimp=$li_basimp*(-1);
					$li_moncar=$li_moncar*(-1);
				}
				else
				{
					$ls_numnd=$ls_numdc;
					$ls_numnc="";
				}
				$this->valido=$this->guardar_detallecmp($as_nrocomp,$as_codded,$ls_numope,$ld_fecope,$as_coddoc,$as_numref,
													    $ls_numnd,$ls_numnc,"01-reg",0,$li_monto,$li_basimp,$ls_porcar,$li_moncar,
													    0,"",$as_numsop,"","",$as_coddoc,"01");
				$resultado->MoveNext();
			}	
		}
		return $this->valido;
	}

	/* (non-PHPdoc)
	 * Funcion que verifica si existen notas de debito o credito asociadas al pago
	 */
	function uf_update_datos_proveedor($as_codded,$as_nrocomp,$as_numsop,$as_codproalt)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$ls_sql="SELECT cxp_rd.codproalt, rpc_proveedor.cod_pro, rpc_proveedor.nompro, ".
				"       rpc_proveedor.dirpro, rpc_proveedor.rifpro, rpc_proveedor.nitpro ".
				"FROM cxp_solicitudes,cxp_dt_solicitudes,cxp_rd,rpc_proveedor  ".
				"WHERE cxp_solicitudes.codemp='".$_SESSION["la_empresa"]["codemp"]."' ".
				"  AND cxp_solicitudes.numsol='".$as_numsop."'".
				"  AND cxp_rd.codproalt='".$as_codproalt."'".
				"  AND cxp_solicitudes.codemp=cxp_dt_solicitudes.codemp".
				"  AND cxp_solicitudes.numsol=cxp_dt_solicitudes.numsol".
				"  AND cxp_dt_solicitudes.codemp=cxp_rd.codemp".
				"  AND cxp_dt_solicitudes.numrecdoc=cxp_rd.numrecdoc".
				"  AND cxp_dt_solicitudes.ced_bene=cxp_rd.ced_bene".
				"  AND cxp_dt_solicitudes.cod_pro=cxp_rd.cod_pro".
				"  AND cxp_dt_solicitudes.codtipdoc=cxp_rd.codtipdoc".
				"  AND cxp_rd.codemp=rpc_proveedor.codemp".
				"  AND cxp_rd.codproalt=rpc_proveedor.cod_pro";
		
		$resultado = $this->conexionBaseDatos->Execute($ls_sql);
		if($resultado===false)
		{
			$this->mensaje .= '  CLASE->Crear Comprobate MÉTODO->uf_update_datos_proveedor ERROR->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido=false;
		}
		else
		{
			if(!$resultado->EOF){
				$ls_codproalt=$resultado->fields['cod_pro'];
				$ls_nomproalt=$resultado->fields['nompro'];
				$ls_dirproalt=$resultado->fields['dirpro'];
				$ls_rifproalt=$resultado->fields['rifpro'];
				$ls_nitproalt=$resultado->fields['nitpro'];
				$this->valido=$this->uf_update_cabecera($as_codded,$as_nrocomp,$ls_codproalt,$ls_nomproalt,$ls_dirproalt,$ls_rifproalt,$ls_nitproalt);
			}
		}
		return $this->valido;
	}
	
	/* (non-PHPdoc)
	 * Funcion que actualiza la cabecera del comprobante que fue anteriormente incluido 
	*/
	function uf_update_cabecera($as_codded,$as_nrocomp,$as_codproalt,$as_nomproalt,$as_dirproalt,$as_rifproalt,$as_nitproalt)
	{
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$ls_sql="UPDATE scb_cmp_ret".
				"   SET codsujret='".$as_codproalt."',nomsujret='".$as_nomproalt."',".
				"       dirsujret='".$as_dirproalt."',rif='".$as_rifproalt."',nit='".$as_nitproalt."'".
		        "WHERE codemp='".$_SESSION["la_empresa"]["codemp"]."'".
				"  AND codret='".$as_codded."'". 
				"  AND numcom='".$as_nrocomp."'";
		
		$resultado = $this->conexionBaseDatos->Execute($ls_sql);
		if($li_result===false)
		{	
			$this->mensaje .= '  CLASE->Crear Comprobate MÉTODO->uf_update_cabecera ERROR->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido=false;
		}
		return $this->valido;
    }
	
}
?>