<?php
$dirsrvscb = "";
$dirsrvscb = dirname(__FILE__);
$dirsrvscb = str_replace("\\","/",$dirsrvscb);
$dirsrvscb = str_replace("/modelo/servicio/scb","",$dirsrvscb); 
require_once ($dirsrvscb."/base/librerias/php/general/sigesp_lib_fabricadao.php");
require_once ($dirsrvscb.'/base/librerias/php/general/sigesp_lib_funciones.php');
require_once ($dirsrvscb."/modelo/servicio/scb/sigesp_srv_scb_icarta_orden_mnd.php");
require_once ($dirsrvscb."/modelo/servicio/sss/sigesp_srv_sss_evento.php");
require_once ($dirsrvscb.'/modelo/servicio/scb/sigesp_srv_scb_movimientos_scb.php');
require_once ($dirsrvscb.'/modelo/servicio/scb/sigesp_srv_scb_emision_chq.php');


/**
 * @author Ing. Gerardo Cordero
 * @desc clase que sirve a la pantalla parametro de clasificacion, esta implementa
 *       la logica del negocio y maneja los recursos de base de datos
 */
class servicioCartaOrden implements icartaorden_mnd {
	private $daoBanco;
	private $daoCartaOrd;
	private $daoRegistroEvento;
	private $daoRegistroFalla;
	public  $mensaje; 
	public  $valido; 
	
	public function servicioCartaOrden() {
		$this->daoBanco = null;
		$this->daoCartaOrd = null;
		$this->daoRegistroEvento = null;
		$this->daoRegistroFalla  = null;
		$this->mensaje = '';
		$this->valido = true;
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		//$this->conexionBaseDatos->debug=true;
	}
	
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarCodigoParametro()
	 */
	public function buscarMetBancos() {
		
		$cadenasql = "SELECT codemp,codmet,desmet,tipmet  ".
				  "  FROM sno_metodobanco              ".
				  " WHERE codemp='".$_SESSION["la_empresa"]["codemp"]."'      ".
				  "   AND codmet like '%%' ".
				  "   AND desmet like '%%' ".
				  "   AND tipmet='0'                   ".
				  "   AND codmet<>'0100'               ".				 
				  " ORDER BY codmet ASC                ";
	//	echo $cadenasql;
	//	break;		   
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		unset($conexionbd);
		return $resultado;

	}
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarCodigoParametro()
	 */
	public function buscarReporteCarta($sistema,$seccion,$variable,$valor,$tipo,$arrevento)
	{
		$lb_valido=false;
		$ls_valor="";
		$cadenasql="SELECT value ".
				"  FROM sigesp_config ".
				" WHERE codemp='".$_SESSION["la_empresa"]["codemp"]."' ".
				"   AND codsis='".$sistema."' ".
				"   AND seccion='".$seccion."' ".
				"   AND entry='".$variable."' ";

		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
		}
		else
		{
			$li_i=0;
			while((!$resultado->EOF))
			{
				$ls_valor=$resultado->fields["value"];
				$li_i=$li_i+1;
				$resultado->MoveNext();
			}
			if($li_i==0)
			{
				$resultado = 0;
				$codemp   = $_SESSION["la_empresa"]["codemp"];
				//Creacion del Dao con la tabla y campos a insertar.
				$this->daoConfig=FabricaDao::CrearDAO("N","sigesp_config");
				$this->daoConfig->codemp       = $codemp;
				$this->daoConfig->codsis       = $sistema; 
				$this->daoConfig->seccion      = $seccion; 
				$this->daoConfig->entry        = $variable; 
				//Iniciar transaccion
				DaoGenerico::iniciarTrans();
				//Eliminamos el config
				$resultado = $this->daoConfig->eliminar();
				
				$servicioEvento = new ServicioEvento();
				$servicioEvento->evento=$arrevento['evento'];
				$servicioEvento->codemp=$arrevento['codemp'];
				$servicioEvento->codsis=$arrevento['codsis'];
				$servicioEvento->nomfisico=$arrevento['nomfisico'];
				$servicioEvento->desevetra=$arrevento['desevetra'];
				
				if ($resultado)
				{
					$servicioEvento->tipoevento=true;
					$servicioEvento->incluirEvento();
					switch ($tipo)
					{
						case "C"://Caracter
							$value = $valor;
							break;
		
						case "D"://Double
							$value=str_replace(".","",$valor);
							$value=str_replace(",",".",$valor);
							$value = $valor;
							break;
		
						case "B"://Boolean
							$value = $valor;
							break;
		
						case "I"://Integer
							$value = intval($valor);
							break;
					}
					$this->daoConfig=FabricaDao::CrearDAO("N","sigesp_config");
					$this->daoConfig->codemp     = $codemp;
					$this->daoConfig->codsis     = $sistema; 
					$this->daoConfig->seccion    = $seccion; 
					$this->daoConfig->entry      = $variable; 
					$this->daoConfig->value      = $value; 
					$this->daoConfig->type       = $tipo; 
					$resultado = $this->daoConfig->incluir();
					if($resultado)
					{
						$lb_valido=true;	
					}
					else
					{
						$lb_valido=false;
					}
				}
				else
				{
					$lb_valido=false;
					$arrevento ['desevetra'] = $this->daoConfig->ErrorMsg();
					$servicioEvento->tipoevento=false;
					$servicioEvento->desevetra=$arrevento['desevetra'];
					$servicioEvento->incluirEvento();
				}
				
				if (DaoGenerico::completarTrans($lb_valido)) 
				{
					$resultado = 1;
					$servicioEvento->tipoevento=true;
					$servicioEvento->incluirEvento(); 		
				}
				else
				{
					$arrevento ['desevetra'] = $this->daoConfig->ErrorMsg();
					$servicioEvento->tipoevento=false;
					$servicioEvento->desevetra=$arrevento['desevetra'];
					$servicioEvento->incluirEvento();
				}  
				if ($lb_valido)
				{
					$ls_valor=$this->buscarReporteCfg($sistema, $seccion, $variable, $valor, $tipo);
				}
			}
		}
		unset($conexionbd);
		unset($resultado);
		return rtrim($ls_valor);
	}

	//--------------------------------------------------------------------------------------------------------------------------------------
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarCodigoParametro()
	 */
	public function buscarReporteC()
	{
		$cadenasql = " SELECT codigo ".
					 " FROM scb_cartaorden ".
					 " WHERE codemp='".$_SESSION["la_empresa"]["codemp"]."' AND status=1";

		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
		}
		else
		{
			while((!$resultado->EOF))
			{
				$ls_codigo  = $resultado->fields["codigo"];
				$resultado->MoveNext();
			}
		}
		unset($conexionbd);
		unset($resultado);
		return $ls_codigo;
	}

/* (non-PHPdoc)
     * @see modelo/servicio/rpc/iparametroclasificacion::buscarCodigoParametro()
     */
	public function uf_select_solcxp_montocancelado($ls_codemp,$ls_numsol,$ls_codban,$ls_ctaban)
	{
		$ls_codemp = $_SESSION["la_empresa"]["codemp"];
		$ldec_montocancelado=0;
		$cadenasql = "SELECT sum(monto) as monto
					 FROM cxp_sol_banco 
					WHERE codemp='".$ls_codemp."'
					  AND numsol='".$ls_numsol."'
					  AND estmov<>'A' 
					  AND estmov<>'O'";
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
		}
		else
		{
			while((!$resultado->EOF))
			{
				$ldec_montocancelado = $resultado->fields["monto"];
				$resultado->MoveNext();
			}
		}
		
		unset($conexionbd);
		unset($resultado);
		return $ldec_montocancelado;
			
	}//Fin de uf_select_solcxp_montocancelado

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	public function uf_load_fuentefinancimiento($as_codemp,$as_numsol)
	{
			//////////////////////////////////////////////////////////////////////////////
			//	          Metodo:  uf_load_fuentefinancimiento
			//	          Access:  public
			//	        Arguments  as_codemp //  Codigo de la Empresa.
			//                     as_numsol //  Número de Identificacion de la Solicitud de Pago.
			//                     as_codfuefin //  fuente de financiemiento
			//	         Returns:  lb_valido.
			//	     Description:  Funcion que se encarga de buscar las notas de debito y crédito asociadas a la solicitud de pago. 
			//     Elaborado Por:  Ing. Yesenia Moreno
			// Fecha de Creacion:  26/09/2007       Fecha Última Actualizacion:
			////////////////////////////////////////////////////////////////////////////// 
			$lb_valido=true;
			$as_codfuefin="--";
			$cadenasql= "SELECT codfuefin ".
				   "  FROM cxp_solicitudes ".
				   " WHERE codemp='".$as_codemp."' ".
				   "   AND numsol='".$as_numsol."' ";
			$conexionbd = ConexionBaseDatos::getInstanciaConexion();
			$resultado = $conexionbd->Execute ( $cadenasql );
			if ($resultado===false)
			{
				$mensaje .= '  ->'.$conexionbd->ErrorMsg();
			}
			else
			{
				while((!$resultado->EOF))
				{
					$as_codfuefin=$resultado->fields["codfuefin"];
					$resultado->MoveNext();
				}
			}
			unset($conexionbd);
			unset($resultado);
			return $as_codfuefin;
	}	
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/* (non-PHPdoc)
     * @see modelo/servicio/rpc/iparametroclasificacion::buscarCodigoParametro()
     */
	public function  buscarSolicitudesProgCarta($provbene,$tipvia,$numordpagmin)
	{
	    $arrSolProgCarta=array();
		$li_estciespg = $_SESSION["la_empresa"]["estciespg"];
	    $li_estciespi = $_SESSION["la_empresa"]["estciespi"];
	    $li_estciescg = $_SESSION["la_empresa"]["estciescg"];

	    $ls_codemp = $_SESSION["la_empresa"]["codemp"];
	    $ls_cadaux    = $ls_straux = $ls_sqlaux = "";
		if ($tipvia=='1')
		   {
		     $ls_sqlaux = " AND scb_prog_pago.esttipvia = '1'";
		   }
		else
		   {
		     $ls_sqlaux = " AND scb_prog_pago.esttipvia <> '1'";
		   }
		if ($provbene=='B')
		   {
		     $ls_tabla  = ', rpc_beneficiario';
		     $ls_straux = ' rpc_beneficiario.nombene, rpc_beneficiario.apebene,';
		     $ls_sqlaux = $ls_sqlaux.' AND cxp_solicitudes.codemp=rpc_beneficiario.codemp AND cxp_solicitudes.ced_bene=rpc_beneficiario.ced_bene';
		   }
		else
		   {
		     $ls_tabla  = ', rpc_proveedor';
		     $ls_straux = ' rpc_proveedor.nompro, ';
		     $ls_sqlaux = $ls_sqlaux.' AND cxp_solicitudes.codemp=rpc_proveedor.codemp AND cxp_solicitudes.cod_pro=rpc_proveedor.cod_pro';
		   }
	    if (!empty($numordpagmin) && !empty($as_codtipfon) && $numordpagmin!='-' && $as_codtipfon!='----')
		   {
		     $ls_sqlaux = $ls_sqlaux." AND trim(cxp_solicitudes.numordpagmin) = '".$numordpagmin."' 
			                		   AND cxp_solicitudes.codtipfon = '".$as_codtipfon."'";
		   }
		else
		   {
		     /*$ls_sqlaux = $ls_sqlaux." AND trim(cxp_solicitudes.numordpagmin) = '-' 
			                		   AND cxp_solicitudes.codtipfon = '----'";*/
		   }
		
		$cadenasql = "SELECT cxp_solicitudes.numsol, cxp_solicitudes.cod_pro, cxp_solicitudes.ced_bene, $ls_straux
					      cxp_solicitudes.codfuefin, cxp_solicitudes.consol, cxp_solicitudes.monsol,
					      scb_prog_pago.codban, scb_banco.nomban, scb_prog_pago.ctaban, scb_ctabanco.dencta,
					      scb_ctabanco.codtipcta, scb_ctabanco.sc_cuenta, scb_tipocuenta.nomtipcta, '' AS numrecdoc,
						  (SELECT count(cxp_rd_spg.spg_cuenta) 
						     FROM cxp_rd_spg, cxp_rd, cxp_dt_solicitudes
						    WHERE cxp_solicitudes.codemp=cxp_dt_solicitudes.codemp
						      AND cxp_solicitudes.numsol=cxp_dt_solicitudes.numsol
						      AND cxp_dt_solicitudes.codemp=cxp_rd_spg.codemp
						      AND cxp_dt_solicitudes.numrecdoc=cxp_rd_spg.numrecdoc
						      AND cxp_dt_solicitudes.codtipdoc=cxp_rd_spg.codtipdoc
						      AND cxp_dt_solicitudes.cod_pro=cxp_rd_spg.cod_pro
						      AND cxp_dt_solicitudes.ced_bene=cxp_rd_spg.ced_bene
						      AND cxp_rd.codemp=cxp_rd_spg.codemp
						      AND cxp_rd.numrecdoc=cxp_rd_spg.numrecdoc
						      AND cxp_rd.codtipdoc=cxp_rd_spg.codtipdoc
						      AND cxp_rd.cod_pro=cxp_rd_spg.cod_pro
						      AND cxp_rd.ced_bene=cxp_rd_spg.ced_bene) as detspg
				     FROM cxp_solicitudes, scb_prog_pago, scb_banco, scb_ctabanco, scb_tipocuenta $ls_tabla					 
				    WHERE cxp_solicitudes.codemp='".$ls_codemp."'
				      AND cxp_solicitudes.estprosol='S'
				      AND scb_prog_pago.estmov='P'
				      AND cxp_solicitudes.tipproben='".$provbene."'
					  AND cxp_solicitudes.codemp=scb_prog_pago.codemp
				      AND cxp_solicitudes.numsol=scb_prog_pago.numsol
				   	  AND scb_banco.codemp=scb_prog_pago.codemp
				   	  AND scb_banco.codban=scb_prog_pago.codban
				   	  AND scb_banco.codemp=scb_ctabanco.codemp
				   	  AND scb_banco.codban=scb_ctabanco.codban
				      AND scb_prog_pago.codemp=scb_ctabanco.codemp
				      AND scb_prog_pago.ctaban=scb_ctabanco.ctaban
				      AND scb_ctabanco.codtipcta=scb_tipocuenta.codtipcta  $ls_sqlaux";
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
		}
		else
		{
		    $j=0;
			while((!$resultado->EOF))
			{
			 $li_detspg = $resultado->fields["detspg"];
			 if (($li_estciespg==1 || $li_estciespi==1) && ($li_detspg==0 && $li_estciescg==0) || 
				($li_estciespg==0 && $li_estciespi==0 && $li_estciescg==0))
				{
				  if ($provbene=='P')
					 {
					   $ls_codproben = $resultado->fields["cod_pro"];
					   $ls_nomproben = $resultado->fields["nompro"];
					 }
				  else
					 { 
					   $ls_codproben = $resultado->fields["ced_bene"];
					   $ls_nomproben = $resultado->fields["nombene"];
					   $ls_apebene   = $resultado->fields["apebene"];
					   if (!empty($ls_apebene))
						  {
							$ls_nomproben = $ls_nomproben.', '.$ls_apebene;
						  }
					 }
				  $ls_numsol	 = trim($resultado->fields["numsol"]);
				  $ls_consol	 = $resultado->fields["consol"];
				  $ldec_monsol   = $resultado->fields["monsol"];
				  $ls_codban	 = trim($resultado->fields["codban"]);
				  $ls_nomban	 = $resultado->fields["nomban"];
				  $ls_ctaban	 = trim($resultado->fields["ctaban"]);
				  $ls_denctaban  = $resultado->fields["dencta"];
				  $ls_codtipcta  = trim($resultado->fields["codtipcta"]);
				  $ls_nomtipcta  = $resultado->fields["nomtipcta"];
				  $ls_sccuenta   = trim($resultado->fields["sc_cuenta"]);
				  $ls_codfuefin  = "--";
				  //Busco el monto que ya se abono a la solicitud programada
				  $li_montonotas=0;
				  $li_montonotas=$this->uf_load_monto_notas_asociadas($ls_codemp,$ls_numsol);
				  $ls_codfuefin=$this->uf_load_fuentefinancimiento($ls_codemp,$ls_numsol);
				  $ldec_montocancelado = $this->uf_select_solcxp_montocancelado($ls_codemp,$ls_numsol,$ls_codban,$ls_ctaban);
				  //Calculo el monto pendiente
				  $ldec_montopendiente = ($ldec_monsol-$ldec_montocancelado)+$li_montonotas;
				  if ($ldec_montopendiente>0) 
					 {
					   $arrSolProgCarta[$j]['numsolicitud']  = $ls_numsol;
					   $arrSolProgCarta[$j]['consolicitud']  = $ls_consol;
					   $arrSolProgCarta[$j]['codproben']     = $ls_codproben;
					   $arrSolProgCarta[$j]['nomproben']     = $ls_nomproben;
					   $arrSolProgCarta[$j]['monsolicitud']  = number_format($ldec_monsol,2,',','.');
					   $arrSolProgCarta[$j]['montopendiente']= number_format($ldec_montopendiente,2,',','.');
					   $arrSolProgCarta[$j]['montop']  		 = number_format($ldec_montopendiente,2,',','.');
					   $arrSolProgCarta[$j]['codbanco']	     = $ls_codban;
					   $arrSolProgCarta[$j]['nombanco']      = $ls_nomban;
					   $arrSolProgCarta[$j]['ctabanco']      = $ls_ctaban;
					   $arrSolProgCarta[$j]['denctaban']     = $ls_denctaban;
					   $arrSolProgCarta[$j]['codtipcta']     = $ls_codtipcta;
					   $arrSolProgCarta[$j]['nomtipcta']     = $ls_nomtipcta;
					   $arrSolProgCarta[$j]['codfuefin']     = $ls_codfuefin;
					   $j++;
					 }
				}
			   
			   $resultado->MoveNext();
			}
		 }
		unset($conexionbd);
		unset($resultado);
		return $arrSolProgCarta;
	}//Fin de uf_cargar_programaciones


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarCodigoParametro()
	 */
	public function uf_load_monto_notas_asociadas($as_codemp,$as_numsol)
	{
		$lb_valido=true;
		$as_codemp = $_SESSION["la_empresa"]["codemp"];
		$ai_montonotas=0;
		$cadenasql = "SELECT SUM(CASE cxp_sol_dc.codope WHEN 'NC' THEN (-1*cxp_sol_dc.monto) ".
			   "  ELSE (cxp_sol_dc.monto) END) as total ".
			   "  FROM cxp_dt_solicitudes, cxp_sol_dc ".
			   " WHERE cxp_dt_solicitudes.codemp='".$as_codemp."' ".
			   "   AND cxp_dt_solicitudes.numsol='".$as_numsol."' ".
			   "   AND cxp_sol_dc.estnotadc= 'C' ".
			   "   AND cxp_dt_solicitudes.codemp = cxp_sol_dc.codemp ".
			   "   AND cxp_dt_solicitudes.numsol = cxp_sol_dc.numsol ".
			   "   AND cxp_dt_solicitudes.numrecdoc = cxp_sol_dc.numrecdoc ".
			   "   AND cxp_dt_solicitudes.codtipdoc = cxp_sol_dc.codtipdoc ".
			   "   AND cxp_dt_solicitudes.ced_bene = cxp_sol_dc.ced_bene ".
			   "   AND cxp_dt_solicitudes.cod_pro = cxp_sol_dc.cod_pro";
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
		}
		else
		{
			while((!$resultado->EOF))
			{
				$ai_montonotas=$resultado->fields["total"];
				$resultado->MoveNext();
			}
		}
		unset($conexionbd);
		unset($resultado);
		return $ai_montonotas;
	}

	
//-----------------------------------------------------------------------------------------------------------------------------------
	public function procesar_dt_mov($codban,$ctaban,$numdoc,$codope,$estmov,$ls_codpro,$ls_cedbene,$ls_numsolp,$ldec_montop,$ls_ctaprovbene,$arrevento)
	{
	//////////////////////////////////////////////////////////////////////////////
	//	Function:	    uf_procesar_emision_scq
	// Access:			public
	//	Returns:		Boolean Retorna si proceso correctamente
	//	Description:	Funcion que se encarga de guardar los detalles d ela emision de cheque
	//////////////////////////////////////////////////////////////////////////////
	
	///////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valido=false;
		$resultado = 0;
		$ls_codemp   = $_SESSION["la_empresa"]["codemp"];
	    $ls_codusu   = $_SESSION["la_logusr"];			 
		//Creacion del Dao con la tabla y campos a insertar.
		
		$this->daoInsertCarta=FabricaDao::CrearDAO("N","scb_dt_movbco");
		$this->daoInsertCarta->codemp       = $ls_codemp;
		$this->daoInsertCarta->codban    	= $codban; 
		$this->daoInsertCarta->ctaban       = $ctaban; 
		$this->daoInsertCarta->numdoc       = $numdoc; 
		$this->daoInsertCarta->codope       = $codope; 
		$this->daoInsertCarta->estmov       = $estmov; 
		$this->daoInsertCarta->cod_pro      = $ls_codpro; 
		$this->daoInsertCarta->ced_bene     = $ls_cedbene; 
		$this->daoInsertCarta->numsolpag    = $ls_numsolp; 
		$this->daoInsertCarta->monsolpag    = $ldec_montop; 
		$this->daoInsertCarta->ctabanbene   = $ls_ctaprovbene;
		
		//Iniciar transaccion
		//--DaoGenerico::iniciarTrans();
		//Insertamos la programacion de pago
		$resultado = $this->daoInsertCarta->incluir();
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];
		
		if ($resultado)
		{
			$lb_valido=true;
		}
		else
		{
			$arrevento ['desevetra'] = $this->daoInsertCarta->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
			$lb_valido=false;
		}
		
	//liberando variables y retornando el resultado de la operacion
	unset($this->daoInsertCarta);	
    return $lb_valido;	

	}//Fin de  procesar_emision_chq	

//--------------------------------------------------------------------------------------------------------------------------------------
	public function procesar_carta_orden($ls_codban,$ls_ctaban,$ls_numdoc,$ls_codope,$ls_numsol,$ls_estmov,$ldec_monto,$ls_estdoc,$arrevento)
	{
	//////////////////////////////////////////////////////////////////////////////
	//	Function:	    uf_procesar_emision_scq
	// Access:			public
	//	Returns:		Boolean Retorna si proceso correctamente
	//	Description:	Funcion que se encarga de guardar los detalles d ela emision de cheque
	//////////////////////////////////////////////////////////////////////////////
	
	///////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valido=false;
		$resultado = 0;
		$ls_codemp   = $_SESSION["la_empresa"]["codemp"];
	    $ls_codusu   = $_SESSION["la_logusr"];			 
		//Creacion del Dao con la tabla y campos a insertar.
		
		$this->daoInsertCarta=FabricaDao::CrearDAO("N","cxp_sol_banco");
		$this->daoInsertCarta->codemp       = $ls_codemp;
		$this->daoInsertCarta->codban    	= $ls_codban; 
		$this->daoInsertCarta->ctaban       = $ls_ctaban; 
		$this->daoInsertCarta->numdoc       = $ls_numdoc; 
		$this->daoInsertCarta->codope       = $ls_codope; 
		$this->daoInsertCarta->numsol       = $ls_numsol; 
		$this->daoInsertCarta->estmov       = $ls_estmov; 
		$this->daoInsertCarta->monto        = $ldec_monto; 
		//Iniciar transaccion
		//--DaoGenerico::iniciarTrans();
		//Insertamos la programacion de pago
		$resultado = $this->daoInsertCarta->incluir();
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];
		
		if ($resultado)
		{
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento();
			$strPk = "codemp='{$ls_codemp}' AND numsol='{$ls_numsol}'";
			$this->daoInsertCarta = FabricaDao::CrearDAO("C", "scb_prog_pago", '', $strPk);
			$this->daoInsertCarta->estmov = $ls_estmov ;
			$resultado = $this->daoInsertCarta->modificar();
			
			if ($resultado)
			{
				$servicioEvento->tipoevento=true;
				$servicioEvento->incluirEvento();
				$strPk = "codemp='{$ls_codemp}' AND numsol='{$ls_numsol}'";
				$this->daoInsertCarta = FabricaDao::CrearDAO("C", "cxp_solicitudes", '', $strPk);
				$this->daoInsertCarta->estprosol = 'P' ;
				$resultado = $this->daoInsertCarta->modificar();
				if ($resultado)
				{
					$lb_valido=true;
				}
				else
				{
					$lb_valido=false;
				}
			}
			else
			{
				$arrevento ['desevetra'] = $this->daoInsertCarta->ErrorMsg();
				$servicioEvento->tipoevento=false;
				$servicioEvento->desevetra=$arrevento['desevetra'];
				$servicioEvento->incluirEvento();
				$lb_valido=false;
			}
			
			 
		}
		else
		{
			$arrevento ['desevetra'] = $this->daoInsertCarta->ErrorMsg();
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
			$lb_valido=false;
		}
		
	//liberando variables y retornando el resultado de la operacion
	unset($this->daoInsertCarta);	
    return $lb_valido;	

	}//Fin de  procesar_emision_chq	
//--------------------------------------------------------------------------------------------------------------------------------------
	 /* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()*/
   public function uf_generar_num_documento($as_codemp,$as_codope)
	{
		$check=0;
		$cadenasql="SELECT numdoc FROM scb_movbco ".
				 " WHERE codemp='".$as_codemp."' AND codope='".$as_codope."' AND substr(numdoc,1,3)='CO0'".
				 " ORDER BY numdoc DESC";

		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
		}
		else
		{
		  while((!$resultado->EOF))
		  { 
			  $codigo=substr($resultado->fields["numdoc"],2,13);
			  settype($codigo,'int'); 
			  $codigo = $codigo + 1;                              // Le sumo uno al entero.
			  settype($codigo,'string');                          // Lo convierto a varchar nuevamente.
			  $ls_codigo= str_pad($codigo,13,"0",LEFT);
			  $ls_codigo="CO".$ls_codigo;
			  $check++;
			  $resultado->MoveNext();
			  break;
		  }
		  if ($check==0)
		  {
			  $codigo="1";
			  $ls_codigo="CO".str_pad($codigo,13,"0",LEFT);
		  }
		}
		return $ls_codigo;
	}

//--------------------------------------------------------------------------------------------------------------------------------------
	public function uf_search_nomproben($ls_codemp,$as_codproben,$tipo)
	{
		$lb_valido=true;
		
		if ($tipo==1)
		{
			$cadenasql= "SELECT nompro ".
				   "  FROM rpc_proveedor ".
				   " WHERE codemp='".$ls_codemp."' ".
				   "   AND cod_pro='".$as_codproben."' ";
		}
		else
		{
			$cadenasql= "SELECT nombene, apebene ".
				   "  FROM rpc_beneficiario ".
				   " WHERE codemp='".$ls_codemp."' ".
				   "   AND ced_bene='".$as_codproben."' "; // Modificado por Ofimatica de Venezuela el 04-05-2011, no pueden comparar contra numsol, ya que ese campo no existe en la table rpc_beneficiario, es contra ced_bene
		}
		$conexionbd = ConexionBaseDatos::getInstanciaConexion();
		$resultado = $conexionbd->Execute ( $cadenasql );
		if ($resultado===false)
		{
			$mensaje .= '  ->'.$conexionbd->ErrorMsg();
		}
		else
		{
			if($tipo==1)
			{
				if(!$resultado->EOF)
				{
					$as_nomproben=$resultado->fields["nompro"];
					$resultado->MoveNext();
				}
			}
			else
			{
				if(!$resultado->EOF)
				{
					$as_nombre=$resultado->fields["nombene"];
					$as_apellido=$resultado->fields["apebene"];
					$as_nomproben=$as_apellido." ".$as_nombre;
					$resultado->MoveNext();
				}
			}
			
		}
		return $as_nomproben;
	}	
//--------------------------------------------------------------------------------------------------------------------------------------
	public function uf_load_datos_recepcion($as_codemp,$as_numsol)
	{
	  $lb_valido  = true;
	  $ls_procede = "";
	  $cadenasql = "SELECT cxp_rd.procede as procedencia ". 
				"	FROM cxp_rd ,cxp_dt_solicitudes ".
				"	WHERE cxp_dt_solicitudes.codemp='".$as_codemp."' ".
				"	AND cxp_dt_solicitudes.numsol='".$as_numsol."' ".
				"	AND cxp_rd.numrecdoc=cxp_dt_solicitudes.numrecdoc ". 
				"	AND cxp_rd.codtipdoc=cxp_dt_solicitudes.codtipdoc ".
				"	AND cxp_rd.ced_bene=cxp_dt_solicitudes.ced_bene ".
				"	AND cxp_rd.cod_pro=cxp_dt_solicitudes.cod_pro "; 
	  
	  $conexionbd = ConexionBaseDatos::getInstanciaConexion();
	  $resultado = $conexionbd->Execute ( $cadenasql );
	  if ($resultado===false)
	  {
	   		$mensaje .= '  ->'.$conexionbd->ErrorMsg();
	  }
	  else
	  {
		  if (!$resultado->EOF)
		  {
				$ls_procede = $resultado->fields["procedencia"];
				$resultado->MoveNext();
		  }
	  }
	  return $ls_procede;
	}
//--------------------------------------------------------------------------------------------------------------------------------------
	public function uf_load_datos_beneficiario($as_codemp,$as_cedbene,$ls_procede)
	{
	  $lb_valido  = true;
	  if ($ls_procede=='SCVSOV')
		 {
		   $cadenasql = "SELECT distinct a.codcueban,a.tipcuebanper as tipcuebanper,b.nomper as nomper,b.apeper as apeper,
							 b.nacper as nacben, b.cedper, $adec_monto as monnetres, a.codban as codban, b.coreleper as coreleper
						FROM sno_personalnomina a , sno_personal b, sno_nomina c
					   WHERE b.codemp='".$as_codemp."' 
						 AND b.cedper='".trim($as_cedbene)."'
						 AND c.espnom = '0'
						 AND b.codemp=a.codemp 
						 AND b.codper=a.codper 
						 AND a.codnom=c.codnom";
		 }
	  else
		 {
		   $cadenasql = "SELECT ctaban as codcueban,tipcuebanben as tipocta, nombene,apebene,nacben ".
					 "  FROM rpc_beneficiario ".
					 " WHERE codemp='".$as_codemp."'".
					 "   AND ced_bene='".$as_cedbene."'";
		 }
	  $conexionbd = ConexionBaseDatos::getInstanciaConexion();
	  $resultado = $conexionbd->Execute ( $cadenasql );
	  if ($resultado===false)
	  {
	   		$mensaje .= '  ->'.$conexionbd->ErrorMsg();
	  }
	  else
		 {
		 }
	  return $resultado;
	}
//--------------------------------------------------------------------------------------------------------------------------------------
	 /* (non-PHPdoc)
	 * @see modelo/servicio/rpc/iparametroclasificacion::buscarParametros()*/
	public function emitirCartaOrden($codban,$ctaban,$codmet,$numdoc,$fecmov,$codope,$estmov,$montomov,$tipodes,
								     $monobjret,$monret,$concepto,$codconmov,$numordpagmin,$desmet,$modageret,$estretmil,
									 $sc_cuenta,$arrcartamnd,$arrededucciones,$arrevento)
	{
		//////////////////////////////////////////////////////////////////////////////
		//	Function:	uf_procesar_programacion
		// Access:		public
		//	Returns:	Boolean Retorna si proceso correctamente
		//	Description:	Funcion que se encarga de guardar el movimiento bien sea 
		//						insertando o actualizando
		//////////////////////////////////////////////////////////////////////////////
		$arrCabeceraScb=array();
		$arrDetalleScg=array();
		$arrDetalleSpg=array();
		$arrDetalleSpi=array();
		$resultado = 0;
		$li_cont = 0;
		$li_count_co = count($arrcartamnd);
		$li_count_deducc = count($arrededucciones);
		$li_cont_dtscg = 0;
		$li_cont_dtspg = 0;

		$ls_codemp 	  = $_SESSION["la_empresa"]["codemp"];
		$ls_estretiva = $_SESSION["la_empresa"]["estretiva"];//Indica si las Retenciones IVA se aplican por Cuentas por Pagar o Banco.		
		$ls_clactacon = $_SESSION["la_empresa"]["clactacon"];
		$ls_codemp    = $_SESSION["la_empresa"]["codemp"];
		$ls_numrefcarord = $_SESSION["la_empresa"]["numrefcarord"];		
		$montomov	  = str_replace(".","",$montomov);
		$montomov     = str_replace(",",".",$montomov);
		$monobjret	  = str_replace(".","",$monobjret);
		$monobjret     = str_replace(",",".",$monobjret);
		$monret       = str_replace(".","",$monret);
		$monret       = str_replace(",",".",$monret);
		$li_totalretenido = $monret;
		$fecmov		  = convertirFechaBd($fecmov);
		//$numdoc=str_pad($numdoc,15,"0",LEFT); 
		
		//Iniciar transaccion
		DaoGenerico::iniciarTrans();
		$servicioEvento = new ServicioEvento();
		
		//Creacion del Arreglo de Cabecera
		$arrCabeceraScb["codemp"]	 = $ls_codemp;
		$arrCabeceraScb["codban"]	 = $codban;
		$arrCabeceraScb["ctaban"]	 = $ctaban;
		$arrCabeceraScb["codope"]	 = $codope;
		$ls_probentemp = "";
		$ls_numcarord			     = $this->uf_generar_num_documento($ls_codemp,$codope);
		if ($ls_numrefcarord=='1')
		{
			$arrCabeceraScb["numdoc"]=$ls_numcarord;
		}
		else
		{
			$arrCabeceraScb["numdoc"]=$numdoc;
		}
		$arrCabeceraScb["fecmov"]	 = $fecmov;
		$arrCabeceraScb["conmov"]	 = $concepto;
		$arrCabeceraScb["codconmov"] = $codconmov;
		$arrCabeceraScb["cod_pro"]	 = "----------";
		$arrCabeceraScb["ced_bene"]	 = "----------";
		$arrCabeceraScb["nomproben"] = "-";
		$arrCabeceraScb["monto"]	 = $montomov;
		$arrCabeceraScb["monobjret"] = $monobjret;
		$arrCabeceraScb["monret"]	 = $monret;
		$arrCabeceraScb["chevau"]	 = "";
		$arrCabeceraScb["estmov"]	 = $estmov;
		$arrCabeceraScb["estmovint"] = 0;
		$arrCabeceraScb["estcobing"] = 0;
		$arrCabeceraScb["estbpd"]	 = "T";
		$arrCabeceraScb["procede"]	 = 'SCBCOR';
		$arrCabeceraScb["estreglib"] = "";
		$arrCabeceraScb["tipo_destino"]	 = $tipodes;
		$arrCabeceraScb["numordpagmin"]	 = $numordpagmin;
		$arrCabeceraScb["numcarord"]	 = $ls_numcarord;
		$arrCabeceraScb["codfuefin"] = '--';
		$arrCabeceraScb["codtipfon"] = "";
		$arrCabeceraScb["estmovcob"] = 0;
		$arrCabeceraScb["numconint"] = "";
		$arrCabeceraScb["tranoreglib"] 	 = 0;
		//Creacion del Arreglo de Cabecera
		$ls_solicitudes="";
		$ldec_totmontoret=0;
		$li_mondedtot=0;
		$lb_valido=true;
		if ($lb_valido==true)
		{
			$ls_checklist='';
			for($i=0;$i<$li_count_co;$i++)
			{
				$li_cont++;
				$ld_montotret 		 = 0;
				$ls_numsol   		 = $arrcartamnd[$i]->numsolicitud;
				$ldec_monsol 		 = $arrcartamnd[$i]->monsolicitud;
				$ldec_monsol 		 = str_replace(".","",$ldec_monsol);
				$ldec_monsol		 = str_replace(",",".",$ldec_monsol);
				$ldec_montopendiente = $arrcartamnd[$i]->montopendiente;
				$ldec_montopendiente = str_replace(".","",$ldec_montopendiente);
				$ldec_montopendiente = str_replace(",",".",$ldec_montopendiente);
				$ldec_monto			 = $arrcartamnd[$i]->montop;
				$ldec_monto			 = str_replace(".","",$ldec_monto);
				$ldec_monto			 = str_replace(",",".",$ldec_monto);
				$ls_codproben		 = $arrcartamnd[$i]->codproben;
				$ls_nomproben		 = $arrcartamnd[$i]->nomproben;
				$ls_codfuefin		 = $arrcartamnd[$i]->codfuefin;
				$ls_numsolp			 = $ls_numsol;
				$ldec_montop		 = $ldec_monto;
				if ($ldec_montopendiente==$ldec_monto)
				{
					$ls_estsol='C';	//Cancelado							
				}
				else
				{
					$ls_estsol='P';//Programado
				}
				if($i == 0)
			    {
					$ls_solicitudes=$ls_numsol;
			    }
			    else
			    {
			 		$ls_solicitudes=$ls_numsol."--".$ls_solicitudes;
			    }
			    if($li_cont==1)
			    {
			 		$ls_codprobenaux = $ls_codproben;
			    }
			    if($li_cont > 1)
			    {
					$i2 = $i-1;
					$ls_codprobenaux = $arrcartamnd[$i2]->codproben;
			    }
			    if($ls_codfuefin=="")
			    {
			 		$ls_codfuefin="--";
			    }
				if ($tipodes=='P')
			    {
					if($li_cont==1) 
					{
						$arrCabeceraScb["cod_pro"]	 = $ls_codproben;
						$arrCabeceraScb["nomproben"] = $this->uf_search_nomproben($ls_codemp,$arrCabeceraScb["cod_pro"],1);
					}
					if (($li_cont>1)&&($ls_codproben!=$ls_codprobenaux))
					{
						$arrCabeceraScb["cod_pro"]	 = "----------";
						$arrCabeceraScb["nomproben"] = $this->uf_search_nomproben($ls_codemp,$arrCabeceraScb["cod_pro"],1);
						$lb_cheked=1;
					}
			    }
		        else
			    {
					if($li_cont==1)
					{
						$arrCabeceraScb["ced_bene"]	 = $ls_codproben;
						$arrCabeceraScb["nomproben"] = $this->uf_search_nomproben($ls_codemp,$arrCabeceraScb["cod_pro"],2);
					}
					if (($li_cont>1)&&($ls_cedbene!=$ls_codprobenaux))
					{
						$arrCabeceraScb["ced_bene"]	 = "----------";
						$arrCabeceraScb["nomproben"] = $this->uf_search_nomproben($ls_codemp,$arrCabeceraScb["cod_pro"],2);
						$lb_cheked=1;	
					}
			    }
				$ls_procede = $this->uf_load_datos_recepcion($ls_codemp,$ls_numsol);//Encontrar la procedencia de la Recepcion de Documentos asociadas a la Solicitud de Pago.
				if ($ls_procede=='SCVSOV')
				{
					$rs_datosbene 			     = $this->uf_load_datos_beneficiario($ls_codemp,$arrCabeceraScb["ced_bene"],$ls_procede);
					$aa_seguridad["empresa"]	 = $ls_codemp;
					$aa_seguridad["sistema"]	 = "SCB";
					$aa_seguridad["logusr"]	     = $_SESSION["la_logusr"];
					$aa_seguridad["ventanas"]	 = "sigesp_scb_p_carta_orden_mnd.php";
				}
				if ($lb_valido)
				{
					 $servicioEmisionCh = new servicioBanco();
					 $ls_ctaprovbene=$servicioEmisionCh->uf_select_ctaprovbene($tipodes,$ls_codproben,$codban,$ctaban);
					
					if ($lb_valido)
					   {
						 if ($ls_estretiva=='B')//Retenciones aplicadas desde el Modulo de Cuentas Por Pagar y reflejadas en el Modulo Banco.
						 {
							$ls_procede = "CXPSOP";
							$la_deducciones1 = $servicioEmisionCh->uf_load_retenciones_iva_cxp($ls_codemp,$ls_numsol);
						 }
						 elseif($ls_estretiva=='C')//Retenciones aplicadas desde el Modulo de Cuentas Por Pagar.
						 {
							$ls_procede = "SCBBCH";
							if ($li_count_deducc > 0)
							{
							   $la_deducciones1 = $arrededucciones; 
							}										
						 }
						 $li_total = 0;
						 $ld_montotret = 0;
						 if (!empty($la_deducciones1))
						 {
							$li_total = count($la_deducciones1["codded"]);
						 }
						 for ($j=0;$j<$li_total;$j++)
						 {
								$ls_ctascg	    = trim($la_deducciones1["sc_cuenta"][$j]);
								$ls_dended	    = $la_deducciones1["dended"][$j];
								$ls_codded	    = $la_deducciones1["codded"][$j];
								$ldec_objret    = $la_deducciones1["monobjret"][$j];
								$ldec_montoret  = $la_deducciones1["monret"][$j];
								$ld_montotret  += $ldec_montoret; 
								if ($ls_codded!="")
								{
									$arrDetalleScg["scg_cuenta"][$li_cont_dtscg]	= $ls_ctascg;
									$arrDetalleScg["procede_doc"][$li_cont_dtscg] 	= $ls_procede;
									$arrDetalleScg["desmov"][$li_cont_dtscg]	 	= $ls_dended;
									$arrDetalleScg["documento"][$li_cont_dtscg]	 	= $ls_numsol;
									$arrDetalleScg["debhab"][$li_cont_dtscg]	 	= 'H';
									$arrDetalleScg["monto"][$li_cont_dtscg]	 	    = $ldec_montoret;
									$arrDetalleScg["monobjret"][$li_cont_dtscg]	 	= $ldec_objret;
									$arrDetalleScg["codded"][$li_cont_dtscg]	 	= $ls_codded;
									$li_cont_dtscg++;
									$ldec_totmontoret=$ldec_totmontoret+$ldec_montoret;
								}
						 }
						// Agregado para retenciones aplicadas en Carta Orden	 
						if ($modageret=="B")/// se realiza el calculo de la ret. municipal
						{
							  $la_deducciones2=$arrededucciones;
							  $li_total2 = count($la_deducciones2["codded"]); //VIENEN DE LAS DEDUCCIONES POR BANCO
							  for ($j=0;$j<$li_total2;$j++)
							  { 
								 $ls_ctascg1	 = trim($la_deducciones2["sc_cuenta"][$j]);
								 $ls_dended1	 = $la_deducciones2["dended"][$j];
								 $ls_codded1	 = $la_deducciones2["codded"][$j];
								 $ldec_objret1   = $la_deducciones2["objret"][$j];
								 $ldec_montoret1 = round($la_deducciones2["montotret"][$j],2);										
								 $ld_montotret 	 = $ld_montotret+$ldec_montoret1;
								 if (!empty($ls_codded1))
								 {
									$arrDetalleScg["scg_cuenta"][$li_cont_dtscg]	= $ls_ctascg1;
									$arrDetalleScg["procede_doc"][$li_cont_dtscg] 	= $ls_procede;
									$arrDetalleScg["desmov"][$li_cont_dtscg]	 	= $ls_dended1;
									$arrDetalleScg["documento"][$li_cont_dtscg]	 	= $ls_numsol;
									$arrDetalleScg["debhab"][$li_cont_dtscg]	 	= 'H';
									$arrDetalleScg["monto"][$li_cont_dtscg]	 	    = $ldec_montoret1;
									$arrDetalleScg["monobjret"][$li_cont_dtscg]	 	= $ldec_objret1;
									$arrDetalleScg["codded"][$li_cont_dtscg]	 	= $ls_codded1;
									$li_cont_dtscg++;
									$ldec_totmontoret=$ldec_totmontoret+$ldec_montoret1;
								 }
							  }
						}
						// Agregado para retenciones aplicadas en Carta Orden
						 if ($ls_estretiva=='B')
						 { 
							  $ldec_montotot=$montomov;
							  $li_mondedtot=$li_mondedtot+$ldec_montotot;
						 }
						 elseif($ls_estretiva=='C')
						 {
							  $ldec_montotot=($montomov-$monret);
							  $li_mondedtot=$li_mondedtot+$ldec_montotot;
						 }
						 unset($la_deducciones1);
					   }//FIN DEL IF
					
					if ($lb_valido)
					{
						if ($ls_clactacon==1)
						{
							$ls_ctaprovbene = $servicioEmisionCh->uf_select_ctacxpclasificador($ls_numsol,$tipodes,$ls_codproben);
						}
						else
						{
							$ls_ctaprovbene = $servicioEmisionCh->uf_select_ctaprovbene($tipodes,$ls_codproben,$codban,$ctaban);
						}
						 if ($lb_valido)
						 {
							 $ldec_monto_spg=0;
							 $ldec_montospg2=0;
							 $aa_dt_spgcxp=$servicioEmisionCh->uf_buscar_dt_cxpspg($ls_numsol);
							 
							 //CALCULO TOTAL PRESUPUESTARIO
							 $ld_totpre=0;
							 foreach($aa_dt_spgcxp as $dt_cxpspg)
							 {
								$ld_mon_aux    = $dt_cxpspg["monto"];
								$ld_totpre     = $ld_totpre + doubleval($ld_mon_aux);
							 }										
							 if ($ls_estsol=="C")
							 {
								foreach($aa_dt_spgcxp as $dt_cxpspg)
								{
									$ls_codestpro1 = $dt_cxpspg["codestpro1"];
									$ls_codestpro2 = $dt_cxpspg["codestpro2"];
									$ls_codestpro3 = $dt_cxpspg["codestpro3"];
									$ls_codestpro4 = $dt_cxpspg["codestpro4"];
									$ls_codestpro5 = $dt_cxpspg["codestpro5"];
									$ls_estcla     = $dt_cxpspg["estcla"];
									$ls_cuentaspg  = trim($dt_cxpspg["spg_cuenta"]);
									$ls_descripcion = $dt_cxpspg["descripcion"];
									$ld_monto_par   = $dt_cxpspg["monto"];
									$ls_programa    = $ls_codestpro1.$ls_codestpro2.$ls_codestpro3.$ls_codestpro4.$ls_codestpro5;
									
									// Se envia el arreglo de detalles presupuestarios
									$arrDetalleSpg["codestpro"][$li_cont_dtspg] = $ls_programa;
									$arrDetalleSpg["spgcuenta"][$li_cont_dtspg] = $ls_cuentaspg;
									$arrDetalleSpg["documento"][$li_cont_dtspg] = $ls_numsol;
									$arrDetalleSpg["desmov"][$li_cont_dtspg]    = $ls_descripcion;
									$arrDetalleSpg["procede_doc"][$li_cont_dtspg] = 'CXPSOP';
									$arrDetalleSpg["monto"][$li_cont_dtspg] = $ld_monto_par;
									$arrDetalleSpg["operacion"][$li_cont_dtspg] = 'PG';
									$arrDetalleSpg["estcla"][$li_cont_dtspg] = $ls_estcla;
									$arrDetalleSpg["codfuefin"][$li_cont_dtspg] = "";
									$li_cont_dtspg++;
								}
							 }
							 else
							 {
								if($ldec_monto<$ld_totpre)
								{
									foreach($aa_dt_spgcxp as $dt_cxpspg)
									{
										$ls_codestpro1 = $dt_cxpspg["codestpro1"];
										$ls_codestpro2 = $dt_cxpspg["codestpro2"];
										$ls_codestpro3 = $dt_cxpspg["codestpro3"];
										$ls_codestpro4 = $dt_cxpspg["codestpro4"];
										$ls_codestpro5 = $dt_cxpspg["codestpro5"];
										$ls_estcla     = $dt_cxpspg["estcla"];
										$ls_cuentaspg  = trim($dt_cxpspg["spg_cuenta"]);
										$ls_descripcion = $dt_cxpspg["descripcion"];
										$ld_monto_par   = $dt_cxpspg["monto"];
										$ld_monto_spg   = round(round($ld_monto_par , 2 ) *($ldec_monto  / $ld_totpre),2);
										$ls_programa    = $ls_codestpro1.$ls_codestpro2.$ls_codestpro3.$ls_codestpro4.$ls_codestpro5;
										
										// Se envia el arreglo de detalles presupuestarios
										$arrDetalleSpg["codestpro"][$li_cont_dtspg] = $ls_programa;
										$arrDetalleSpg["spgcuenta"][$li_cont_dtspg] = $ls_cuentaspg;
										$arrDetalleSpg["documento"][$li_cont_dtspg] = $ls_numsol;
										$arrDetalleSpg["desmov"][$li_cont_dtspg]    = $ls_descripcion;
										$arrDetalleSpg["procede_doc"][$li_cont_dtspg] = 'CXPSOP';
										$arrDetalleSpg["monto"][$li_cont_dtspg] = $ld_monto_spg;
										$arrDetalleSpg["operacion"][$li_cont_dtspg] = 'PG';
										$arrDetalleSpg["estcla"][$li_cont_dtspg] = $ls_estcla;
										$arrDetalleSpg["codfuefin"][$li_cont_dtspg] = "";
										$li_cont_dtspg++;
									}
								 }
								 elseif ($ldec_monto>=$ld_totpre)
								 {
									foreach($aa_dt_spgcxp as $dt_cxpspg)
									{
										$ls_codestpro1 = $dt_cxpspg["codestpro1"];
										$ls_codestpro2 = $dt_cxpspg["codestpro2"];
										$ls_codestpro3 = $dt_cxpspg["codestpro3"];
										$ls_codestpro4 = $dt_cxpspg["codestpro4"];
										$ls_codestpro5 = $dt_cxpspg["codestpro5"];
										$ls_estcla     = $dt_cxpspg["estcla"];
										$ls_cuentaspg  = trim($dt_cxpspg["spg_cuenta"]);
										$ls_descripcion = $dt_cxpspg["descripcion"];
										$ld_monto_spg   = $dt_cxpspg["monto"];
										$ls_programa    = $ls_codestpro1.$ls_codestpro2.$ls_codestpro3.$ls_codestpro4.$ls_codestpro5;
										if($ld_monto_spg>0)
										{
											// Se envia el arreglo de detalles presupuestarios
											$arrDetalleSpg["codestpro"][$li_cont_dtspg] = $ls_programa;
											$arrDetalleSpg["spgcuenta"][$li_cont_dtspg] = $ls_cuentaspg;
											$arrDetalleSpg["documento"][$li_cont_dtspg] = $ls_numsol;
											$arrDetalleSpg["desmov"][$li_cont_dtspg]    = $ls_descripcion;
											$arrDetalleSpg["procede_doc"][$li_cont_dtspg] = 'CXPSOP';
											$arrDetalleSpg["monto"][$li_cont_dtspg] = $ld_monto_spg;
											$arrDetalleSpg["operacion"][$li_cont_dtspg] = 'PG';
											$arrDetalleSpg["estcla"][$li_cont_dtspg] = $ls_estcla;
											$arrDetalleSpg["codfuefin"][$li_cont_dtspg] = "";
											$li_cont_dtspg++;
										}
										else
										{
											$lb_valido = true;
										}
									}
									
								 }
							 }
							 unset($aa_dt_spgcxp);
						 }
					}
				}
				
				$arrDetalleScg["scg_cuenta"][$li_cont_dtscg]	= $ls_ctaprovbene;
				$arrDetalleScg["procede_doc"][$li_cont_dtscg] 	= 'CXPSOP';
				$arrDetalleScg["desmov"][$li_cont_dtscg]	 	= $concepto;
				$arrDetalleScg["documento"][$li_cont_dtscg]	 	= $ls_numsol;
				$arrDetalleScg["debhab"][$li_cont_dtscg]	 	= 'D';
				$arrDetalleScg["monto"][$li_cont_dtscg]	 	    = $ldec_monto;
				$arrDetalleScg["monobjret"][$li_cont_dtscg]	 	= $monobjret;
				$arrDetalleScg["codded"][$li_cont_dtscg]	 	= '00000';
				
				if ($li_cont==$li_count_co)
				{
					$li_cont_dtscg++;
					$arrDetalleScg["scg_cuenta"][$li_cont_dtscg]  = $sc_cuenta;
					$arrDetalleScg["procede_doc"][$li_cont_dtscg] = 'SCBBCH';
					$arrDetalleScg["desmov"][$li_cont_dtscg]	  = $concepto;
					$arrDetalleScg["documento"][$li_cont_dtscg]	  = $numdoc;
					$arrDetalleScg["debhab"][$li_cont_dtscg]	  = 'H';
					$arrDetalleScg["monto"][$li_cont_dtscg]	 	  = $ldec_montotot;
					$arrDetalleScg["monobjret"][$li_cont_dtscg]	  = $monobjret;
					$arrDetalleScg["codded"][$li_cont_dtscg]	  = '00000';
				}
				else
				{
					$li_cont_dtscg++;
				}
				if($lb_valido)
				{
					$li_origen=$servicioEmisionCh->uf_validar_monto_cancelado($ls_numsol,$arrCabeceraScb["numdoc"],$arrCabeceraScb["codban"],$arrCabeceraScb["ctaban"],$ldec_monto);
					if($li_origen==1)
					{
						$lb_valido=false;
						$this->mensaje .=  'La solicitud de pago '.$ls_numsol.' ya ha sido cancelada en su totalidad.';
						break;
					}
					elseif($li_origen==2)
					{
						$lb_valido=false;
						$this->mensaje .=  'El pago excede el monto estipulado en la solicitud de pago '.$ls_numsol;
						break;
					}
				}
			}//Fin del Ciclo
		}//Fin de valido
		if ($lb_valido)
		{
			// Llamado al Servicio de Movimientos Bancarios
			$servicioBancario = new ServicioMovimientoScb();
			$lb_valido = $servicioBancario->GuardarAutomatico($arrCabeceraScb,$arrDetalleScg,$arrDetalleSpg,$arrDetalleSpi,$arrevento);
			$this->mensaje.= $servicioBancario->mensaje;
			// Llamado al Servicio de Movimientos Bancarios
		}
		if ($lb_valido)
		{												
			for($i=0;$i<$li_count_co;$i++)
			{
				$ls_numsol   		 = $arrcartamnd[$i]->numsolicitud;
				$ldec_montopendiente = $arrcartamnd[$i]->montopendiente;
				$ldec_montopendiente = str_replace(".","",$ldec_montopendiente);
				$ldec_montopendiente = str_replace(",",".",$ldec_montopendiente);
				$ldec_monto			 = $arrcartamnd[$i]->montop;
				$ldec_monto			 = str_replace(".","",$ldec_monto);
				$ldec_monto			 = str_replace(",",".",$ldec_monto);
				$ls_codproben		 = $arrcartamnd[$i]->codproben;
				$ls_numsolp			 = $ls_numsol;
				$ldec_montop		 = $ldec_monto;
				if ($ldec_montopendiente==$ldec_monto)
				{
					$ls_estsol='C';	//Cancelado							
				}
				else
				{
					$ls_estsol='P';//Programado
				}
				$ls_estsolp			= $ls_estsol;
				$lb_valido=$this->procesar_carta_orden($codban,$ctaban,$arrCabeceraScb["numdoc"],$codope,$ls_numsolp,$estmov,$ldec_montop,$ls_estsolp,$arrevento);
				if ($tipodes=='P')
			    {
					$ls_codpro=$ls_codproben;
					$ls_cedbene='----------';
				}
				else
				{
					$ls_codpro='----------';
					$ls_cedbene=$ls_codproben;
				}
				$lb_valido=$this->procesar_dt_mov($codban,$ctaban,$numdoc,$codope,$estmov,$ls_codpro,$ls_cedbene,$ls_numsolp,$ldec_montop,$ls_ctaprovbene,$arrevento);
			}
		}
		if (DaoGenerico::completarTrans($lb_valido)) 
		{
			$resultado = 1;
			$servicioEvento->tipoevento=true;
			$servicioEvento->incluirEvento();
			$lb_valido=true; 		
		}
		else
		{
			$arrevento ['desevetra'] = $this->mensaje;
			$servicioEvento->tipoevento=false;
			$servicioEvento->desevetra=$arrevento['desevetra'];
			$servicioEvento->incluirEvento();
			$lb_valido=false;
		}  
		//liberando variables y retornando el resultado de la operacion
		//unset($this->daoCartaOrd);	
		return $lb_valido;
	}
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////VERSION 1///////////////////////////////////////////////////////
/*
	 if ($lb_valido)
		{
			$in_classmovbanco->io_sql->commit();
			$io_msg->message("Movimiento registrado !!!");
		    if ($lb_valido)
			   {
				      //$ds_banco_nomina->data = $ds_banco;
					  //$li_numrows = $ds_banco_nomina->getRowCount("codper");
					  $li_numrows=count($rs_datosbene);
					  if ($li_numrows>0 && $li_tipvia=='1')
						 { 
						   $ls_ruta	 = "txt/disco_banco/carta_orden";
						   @mkdir($ls_ruta,0755);
						   require_once("../sno/sigesp_sno_c_metodo_banco.php");
						   $io_metodobanco=new sigesp_sno_c_metodo_banco();
						   $lb_valido = $io_metodobanco->uf_metodo_banco($ls_ruta,$ls_nommetban,$ls_codban,'','',$ld_fecha,$ldec_montomov,$ls_cuenta_banco,$rs_datosbene,$ls_metban,'',0,'',$ls_numdoc,$la_seguridad);
						 } 												// $as_ruta,$as_metodo,$ac_codperi,$ad_fdesde,$ad_fhasta,$ad_fecproc,$adec_montot,$as_codcueban,$rs_data,$as_codmetban,$as_desope,$as_quincena,$as_ref,$aa_seguridad
					
			   }
			$ls_codigo=$in_classconfig->uf_buscar_seleccionado();
			if($ls_codigo!="000")//distinto de chequevoucher
				$ls_pagina="reportes/".$ls_report."?codigo=$ls_codigo&codban=$ls_codban&ctaban=$ls_cuenta_banco&numdoc=$ls_numcarord&chevau=&codope=ND&tipproben=$ls_tipo&solicitud=$ls_solicitudes&fecha=$ld_fecha";
			else
				$ls_pagina="reportes/".$ls_report_voucher."?codban=$ls_codban&ctaban=$ls_cuenta_banco&numdoc=$ls_numdoc&chevau=&codope=ND";			
		}*/
	/////////////////////////////////////////////////VERSION 1///////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
}
?>