<?php
/**
 * @author Neneskha Salas
 * @desc Interfaz del servicio de Transferencias personales, este tiene la finalidad 
 *       de describir de manera abstracta los metodos que definen el comportamiento
 *       del servicio
 */
interface itransferencia
{	
	/**
	 * @author Neneskha Salas
	 * @desc Metodo que busca el personal de Nomina de la empresa
     * @param string $codemp - codigo de la empresa
     * @param string $cedperdes - cedula del personal para filtrar desde
	 * @param string $cedperhas - cedula del personal para filtrar hasta
	 */
	
	public function buscarFiltroPersonal($codemp,$cedperdes,$cedperhas);
	
	/**
	 * @author Neneskha Salas
	 * @desc Metodo que transfiere el personal a Beneficiario
	 * @param string $codemp - codigo de la empresa
	 * @param json $arrjson - json con los datos de la interfaz
	 * @param array $arrevento - arreglo con los datos del log
	*/
	
	public function trasferirPersonalBeneficiario($codemp, $arrjson, $arrEvento);
}