<?php
/**
 * @author Neneskha Salas
 * @desc Interfaz del servicio Tipo de Empresa, este tiene la finalidad
 *       de describir de manera abstracta los metodos que definen el comportamiento
 *       del servicio
 */
interface itipoempresa
{	
	/**
	 * @author Neneskha Salas
	 * @desc Metodo que busca un codigo de tipode empresa para insertar
	 * @param string $codemp - codigo de empresa
	 * @return string $codigo - codigo de parametro de clasificacion
	 */
	public function buscarCodigoTipoempresa($codemp);
	
	/**
	 * @author Ing. Luis Anibal Lang
	 * @desc Metodo que busca todos los registros de especialidad
	 * @return resultset $data - arreglo de registros de especialidad
	 */
	public function buscarTipoempresa($codemp);
	
	/**
	 * @author Ing. Luis Anibal Lang
	 * @desc Metodo que inserta un registro de especialidad
	 * @param json $objson - json con los datos de la interfaz
	 * @param array $arrevento - arreglo con los datos del log
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function guardarTipoempresa($codemp,$objson,$arrevento);
	
	/**
	 * @author Ing. Luis Anibal Lang
	 * @desc Metodo que modifica un registro de especialidad
	 * @param json $objson - json con los datos de la interfaz
	 * @param array $arrevento - arreglo con los datos del log
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function modificarTipoempresa($codemp,$objson,$arrevento);
	
	/**
	 * @author Ing. Luis Anibal Lang
	 * @desc Metodo que elimina un registro de especialidad
	 * @param json $objson - json con los datos de la interfaz
	 * @param array $arrevento - arreglo con los datos del log
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function eliminarTipoempresa($codemp,$objson,$arrevento);
}