<?php
/**
 * @author Ing. Luis Anibal Lang
 * @desc Interfaz del servicio especialidad, este tiene la finalidad
 *       de describir de manera abstracta los metodos que definen el comportamiento
 *       del servicio
 */
interface iespecialidad
{
	
	/**
	 * @author Ing. Luis Anibal Lang
	 * @desc Metodo que busca un codigo de parametro para insertar
	 * * @param string $codemp - codigo de empresa
	 */
	public function buscarCodigoEspecialidad($codemp);
	
	/**
	 * @author Neneskha Salas
	 * @desc Metodo que busca todos los registros de tipo de empresa
	 * @return resultset $data - arreglo de registros de especialidad
	 */
	public function buscarEspecialidad();
	
	/**
	 * @author Neneskha Salas
	 * @desc Metodo que inserta un registro de tipo de empresa
	 * * @param string $codemp - codigo de empresa
	 * @param json $objson - json con los datos de la interfaz
	 * @param array $arrevento - arreglo con los datos del log
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function guardarEspecialidad($codemp,$objson,$arrevento);
	
	/**
	 * @author Ing. Luis Anibal Lang
	 * @desc Metodo que modifica un registro de especialidad
	 * * @param string $codemp - codigo de empresa
	 * @param json $objson - json con los datos de la interfaz
	 * @param array $arrevento - arreglo con los datos del log
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function modificarEspecialidad($codemp,$objson,$arrevento);
	
	/**
	 * @author Ing. Luis Anibal Lang
	 * @desc Metodo que elimina un registro de especialidad
	 * * @param string $codemp - codigo de empresa
	 * @param json $objson - json con los datos de la interfaz
	 * @param array $arrevento - arreglo con los datos del log
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function eliminarEspecialidad($codemp,$objson,$arrevento);
}