<?php
/**
 * @author Ing. Gerardo Cordero
 * @desc Interfaz del servicio parametro clasificacion, este tiene la finalidad
 *       de describir de manera abstracta los metodos que definen el comportamiento
 *       del servicio
 */
interface idocumento
{
	
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo que busca un codigo de parametro para insertar
	 * @param string $codemp - codigo de empresa
	 * @return string $codigo - codigo de parametro de clasificacion
	 */
	public function buscarCodigoDocumento($codemp);
	
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo que busca todos los registros de parametro clasificacion
	 * @return resultset $data - arreglo de registros de parametros de clasificacion
	 */
	public function buscarDocumento($codemp);
	
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo que inserta un registro de parametro clasificacion
	 * @param string $codemp - codigo de empresa
	 * @param json $objson - json con los datos de la interfaz
	 * @param array $arrevento - arreglo con los datos del log
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function guardarDocumento($codemp,$objson,$arrevento);
	
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo que modifica un registro de parametro clasificacion
	 * @param string $codemp - codigo de empresa
	 * @param json $objson - json con los datos de la interfaz
	 * @param array $arrevento - arreglo con los datos del log
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function modificarDocumento($codemp,$objson,$arrevento);
	
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo que elimina un registro de parametro clasificacion
	 * @param string $codemp - codigo de empresa
	 * @param json $objson - json con los datos de la interfaz
	 * @param array $arrevento - arreglo con los datos del log
	 * @return integer $resultado - numero que indica si el proceso fue efectivo valor 1 y 0
	 */
	public function eliminarDocumento($codemp,$objson,$arrevento);
}