<?php
/**
 * @author Neneskha Salas
 * @desc Interfaz del servicio de cambio de estatus de proveedor, este tiene la finalidad 
 *       de describir de manera abstracta los metodos que definen el comportamiento
 *       del servicio
 */
interface icambioestatus
{	
	/**
	 * @author Neneskha Salas
	 * @desc Metodo que verifica si existe un Proveedor
	 */ 
	public function buscarProveedor($as_cedprov,$as_nomprov,$as_dirprov,$as_rifprov);
        
    /**
     * @author Neneskha Salas
     * @desc Metodo que actualiza todos los registros de proveedores segun el estatus nuevo seleccionado
     * @param string $cod_prodesde - codigo de empresa
	 * @param string $cod_prohasta - json con los datos del proveedor
     * @param int $estprovnew - nuevo estatus que sera asignado al o a los proveedores
	 * @param array $arrevento - arreglo con los datos del log
     * */

	public function cargarProveedores($cod_prodesde,$cod_prohasta,$estprovnew);
	
    /**
     * @author Neneskha Salas
     * @desc Metodo que actualiza todos los registros de proveedores segun el estatus nuevo seleccionado
     * @param string $codemp - codigo de empresa
	 * @param json $objson - json con los datos del proveedor
     * @param int $estprovnew - nuevo estatus que sera asignado al o a los proveedores
	 * @param array $arrevento - arreglo con los datos del log
     * */
	public function actualizarEstatus($codemp,$arrProveedor,$estprovnew, $arrEvento);
        
}