<?php
/**
 * @author Ing. Gerardo Cordero
 * @desc Interfaz del servicio para el reporte de documentos contabilizados .
 */
interface IReporteDocumento {
	 
	 /**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo que busca los documentos contailizados.
	 * @param string     $numcom  - Nro de Comprobante de rentas 
	 * @param date       $fecha   - Fecha del Comprobante de rentas
	 * @param string     $estatus - Estatus que indica si el documento de rentas fue o no procesado
	 *                              (0 por procesar, 1 procesada)
	 * @return Resulset Adodb con los documentos de rentas segun los parametros
	 *         indicados.
	 */
	public function buscarDocumentos($codusu, $fecdes, $fechas, $modulo, $concepto, $order);
	
	
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo que busca los usuarios del sistema.
	 * @return Resulset Adodb con los usuarios del sistema
	 */
	public function buscarUsuarios();
	
}
?>