<?php
/**
 * @author Ing. Gerardo Cordero
 * @desc Interfaz del servicio Integracion para la contabilizacion de los movimiento
 *       registrados en el modulo de rentas municipales .
 */
interface IIntegracionSRM {
	 
	 /**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo que busca los Movimiento generados por el modulo de rentas municipales.
	 * @param string     $numcom  - Nro de Comprobante de rentas 
	 * @param date       $fecha   - Fecha del Comprobante de rentas
	 * @param string     $estatus - Estatus que indica si el documento de rentas fue o no procesado
	 *                              (0 por procesar, 1 procesada)
	 * @return Resulset Adodb con los documentos de rentas segun los parametros
	 *         indicados.
	 */
	public function buscarCobranzas($numcom, $fecha, $estatus );
	
}
?>