<?php
/**
 * @author Ing. Yesenia Morenoo
 * @desc Interfaz del servicio Integracion de Ordenes de Compra o Servicio, 
 * 		 este tiene la finalidad de describir de manera abstracta los metodos que 
 * 		 definen el comportamiento del servicio
 */
interface IIntegracionSNO {
	 /**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que busca las SOC por contabilizar
	 * @param string $estcondat - Estatus si es orden de Compra o Servicio
	 * @param string $numordcom - Número de Orden de Compra
	 * @param string $codprov - Codigo del Proveedor
	 * @param date $fecaprord - Fecha de Aprobacion
	 * @return resultset $data - arreglo con las SOC que cumplan con las condiciones dadas
	 */
	public function buscarContabilizar($codcomp,$codnom,$codperi,$tipnom,$estatus);
	
	 /**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que busca los periodos dependiendo de la nomina
	 * @return resultset $data - arreglo con las SNO que cumplan con las condiciones dadas
	 */
	public function buscarPeriodos($codnom,$estatus);
	
	/**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que busca los periodos dependiendo de la nomina
	 * @return resultset $data - arreglo con las SNO que cumplan con las condiciones dadas
	 */
	public function buscarInformacionDetalle($as_codcom,$as_codcomapo,$fecha);
	
	/**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que busca los periodos dependiendo de la nomina
	 * @return resultset $data - arreglo con las SNO que cumplan con las condiciones dadas
	 */
	public function detalleContable($as_codcom,$as_codcomapo);
}
?>