<?php
/**
 * @author Ing. Yesenia Morenoo
 * @desc Interfaz del servicio Integracion de Solicitud de Ejcucion Presupuestaria, 
 * 		 este tiene la finalidad de describir de manera abstracta los metodos que 
 * 		 definen el comportamiento del servicio
 */
interface IIntegracionSEP {

	/**
	 * @author Ing. Yesenia Moreno
	 * @desc   Metodo que busca las SEP por contabilizar
	 * @param  string    $numsol - número de Solicitud
	 * @param  date      $fecreg - Fecha de Registro
	 * @param  string    $tipo - si es proveedor o beneficiario
	 * @param  string    $codigo - Codigo del proveedor o beneficiario
	 * @return resultset $data - arreglo con las sep que cumplan con las condiciones dadas
	 */
	public function buscarContabilizar($numsol,$fecreg,$fecapr,$tipo,$codigo);

	 /**
	 * @author Ing. Yesenia Moreno
	 * @desc   Metodo que busca las SEP por contabilizar
	 * @param  string    $numsol - número de Solicitud
	 * @param  date      $fecreg - Fecha de Registro
	 * @param  string    $tipo - si es proveedor o beneficiario
	 * @param  string    $codigo - Codigo del proveedor o beneficiario
	 * @return resultset $data - arreglo con las sep que cumplan con las condiciones dadas
	 */
	public function buscarRevContabilizacion($numsol,$fecreg,$fecapr,$tipo,$codigo,$fechaconta);

	 /**
	 * @author Ing. Yesenia Moreno
	 * @desc   Metodo que busca las SEP por Anular
	 * @param  string    $numsol - número de Solicitud
	 * @param  date      $fecreg - Fecha de Registro
	 * @param  string    $tipo - si es proveedor o beneficiario
	 * @param  string    $codigo - Codigo del proveedor o beneficiario
	 * @return resultset $data - arreglo con las sep que cumplan con las condiciones dadas
	 */
	public function buscarAnular($numsol,$fecreg,$fecapr,$tipo,$codigo);

	 /**
	 * @author Ing. Yesenia Moreno
	 * @desc   Metodo que busca las SEP por Reversar la anulacion
	 * @param  string    $numsol - número de Solicitud
	 * @param  date      $fecreg - Fecha de Registro
	 * @param  string    $tipo - si es proveedor o beneficiario
	 * @param  string    $codigo - Codigo del proveedor o beneficiario
	 * @return resultset $data - arreglo con las sep que cumplan con las condiciones dadas
	 */
	public function buscarRevAnulacion($numsol,$fecreg,$fecapr,$tipo,$codigo,$fechaanula);

	 /**
	 * @author Ing. Luis Anibal Lang
	 * @desc   Metodo que busca los detalles presupuestarios de la sep 
	 * @param  string    $numsol - número de Solicitud
	 * @return resultset $cabecera||$detalleSpg - Resulset con la informacion de la cabecera y el detalle
	 */
	public function buscarDetallePresupuesto($numsol);

	 /**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo acumula el monto de las cuentas presupuestarias de la SEP
	 * @param string $numsol - número de Solicitud
	 * @return boolean $montocuenta - Variable indicando el monto acumulado
	 */
	public function validarMontoSEP($numsol);		
	
	 /**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo busca los detalles presupuestarios de la SEP
	 * @param string  $numsol - número de Solicitud
	 * @param array   $arrcabecera - Arreglo con la cabecera del comprobante
	 * @return array $arregloSPG - Arreglo con los detalles presupuestarios de la SEP
	 */
	public function buscarDetallePresupuestario($numsol,$arrcabecera);
	
	 /**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que Procesa la Sep por contabilizar
	 * @param Json $objson - json con los datos de la interfaz
	 * @return boolean $resultado - Variable indicando si se pudo o no contabilizar la SEP
	 */
	public function Contabilizar($objson);	
	
	 /**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que Procesa la Sep por reversar la contabilizacion
	 * @param Json $objson - json con los datos de la interfaz
	 * @return boolean $resultado - Variable indicando si se pudo o no reversar la contabilizacion de la SEP
	 */
	public function revContabilizacion($objson);	
	
	 /**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que Procesa la Sep por Anular
	 * @param Json $objson - json con los datos de la interfaz
	 * @return boolean $resultado - Variable indicando si se pudo o no contabilizar la SEP
	 */
	public function Anular($objson);	
	
	 /**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que Procesa la Sep por reversar la anulacion
	 * @param Json $objson - json con los datos de la interfaz
	 * @return boolean $resultado - Variable indicando si se pudo o no reversar la anulacion de la SEP
	 */
	public function revAnulacion($objson);	
	
	 /**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que Procesa el reverso de un precompromiso de la SEP 
	 * @param string $numsol - número de Solicitud
	 * @param date   $fecha - Reverso del precompromiso
	 * @param array   $arrevento - Arreglo del evento
	 * @return boolean $resultado - Variable indicando si se pudo o no reversar el compromiso de la SEP
	 */
	public function revPrecompromiso($numsol,$fecha,$numordcom,$estcondat,$arrevento);
	
	 /**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que Elimina el reverso de un precompromiso de la SEP 
	 * @param string $numsol - número de Solicitud
	 * @param array   $arrevento - Arreglo del evento
	 * @return boolean $resultado - Variable indicando si se pudo o no reversar el compromiso de la SEP
	 */
	public function eliminarRevPrecompromiso($numsol,$numordcom,$estcondat,$arrevento);
	
	 /**
	 * @author Ing. Luis Anibal Lang
	 * @desc Metodo que Busca los detalles del comprobante
	 * @param string $numsol - número de Solicitud
	 * @return boolean $resultado - Variable indicando si se pudo o no reversar el compromiso de la SEP
	 */
	public function buscarInformacionDetalleC($numsol);
	 
        /**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que verifica si la se esta relacionada con otra
	 * @param string $numsol - nï¿½mero de Solicitud
	 * @return boolean $existe
	 */
	public function verificarSEPRelacionadas($numsol,$estsol);
}
?>