<?php
/**
 * @author Ing. Carlos Zambrano
 * @desc Interfaz del servicio Integracion de depreciacion de Activos Fijos, colocaciones y Orden de Pago Directo, 
 * 		 este tiene la finalidad de describir de manera abstracta los metodos que 
 * 		 definen el comportamiento del servicio
 */
interface IIntegracionSAF {
	 /**
	 * @author Ing. Carlos Zambrano
	 * @desc Metodo que busca las depreciaciones por contabilizar
	 * @param string     $numdoc - Nro de Documento 
	 * @param date       $fecdoc - Fecha del Documento
	 * @param string     $codope - Codigo de la operacion
	 * @param string     $numcarord - Fecha de Aprobacion
	 * @return resultset $data - arreglo con los Movimientos de Banco que cumplan con las condiciones dadas
	 */
	public function buscarContabilizarDepSaf($mes,$anio,$estatus);
	 /**
	 * @author Ing. Carlos Zambrano
	 * @desc Metodo que busca las depreciaciones por contabilizar
	 * @param string     $numdoc - Nro de Documento 
	 * @param date       $fecdoc - Fecha del Documento
	 * @param string     $codope - Codigo de la operacion
	 * @param string     $numcarord - Fecha de Aprobacion
	 * @return resultset $data - arreglo con los Movimientos de Banco que cumplan con las condiciones dadas
	 */
	public function buscarRevContabilizacionDepSaf($mes,$anio,$estatus);
	
	/**
	 * @author Ing. Carlos Zambrano
	 * @desc Metodo que busca las depreciaciones por contabilizar
	 * @param string     $numdoc - Nro de Documento 
	 * @param date       $fecdoc - Fecha del Documento
	 * @param string     $codope - Codigo de la operacion
	 * @param string     $numcarord - Fecha de Aprobacion
	 * @return resultset $data - arreglo con los Movimientos de Banco que cumplan con las condiciones dadas
	 */
	public function buscarContabilizarDesSaf($numcmp,$feccmp,$estatus);
	/**
	 * @author Ing. Carlos Zambrano
	 * @desc Metodo que busca las depreciaciones por contabilizar
	 * @param string     $numdoc - Nro de Documento 
	 * @param date       $fecdoc - Fecha del Documento
	 * @param string     $codope - Codigo de la operacion
	 * @param string     $numcarord - Fecha de Aprobacion
	 * @return resultset $data - arreglo con los Movimientos de Banco que cumplan con las condiciones dadas
	 */
	public function buscarRevContabilizacionDesSaf($numcmp,$feccmp,$estatus);
	/**
	 * @author Ing. Carlos Zambrano
	 * @desc Metodo que busca las depreciaciones por contabilizar
	 * @param string     $numdoc - Nro de Documento 
	 * @param date       $fecdoc - Fecha del Documento
	 * @param string     $codope - Codigo de la operacion
	 * @param string     $numcarord - Fecha de Aprobacion
	 * @return resultset $data - arreglo con los Movimientos de Banco que cumplan con las condiciones dadas
	 */
	public function procesoContabilizarDepSaf($arrjson);
	/**
	 * @author Ing. Carlos Zambrano
	 * @desc Metodo que busca las depreciaciones por contabilizar
	 * @param string     $numdoc - Nro de Documento 
	 * @param date       $fecdoc - Fecha del Documento
	 * @param string     $codope - Codigo de la operacion
	 * @param string     $numcarord - Fecha de Aprobacion
	 * @return resultset $data - arreglo con los Movimientos de Banco que cumplan con las condiciones dadas
	 */
	public function procesoRevContabilizarDepSaf($arrjson);
	/**
	 * @author Ing. Carlos Zambrano
	 * @desc Metodo que busca las depreciaciones por contabilizar
	 * @param string     $numdoc - Nro de Documento 
	 * @param date       $fecdoc - Fecha del Documento
	 * @param string     $codope - Codigo de la operacion
	 * @param string     $numcarord - Fecha de Aprobacion
	 * @return resultset $data - arreglo con los Movimientos de Banco que cumplan con las condiciones dadas
	 */
	public function procesoContabilizarDesSaf($arrjson);
	/**
	 * @author Ing. Carlos Zambrano
	 * @desc Metodo que busca las depreciaciones por contabilizar
	 * @param string     $numdoc - Nro de Documento 
	 * @param date       $fecdoc - Fecha del Documento
	 * @param string     $codope - Codigo de la operacion
	 * @param string     $numcarord - Fecha de Aprobacion
	 * @return resultset $data - arreglo con los Movimientos de Banco que cumplan con las condiciones dadas
	 */
	public function procesoRevContabilizarDesSaf($arrjson);
	/**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que busca los detalles de presupuesto de gasto
	 * @param array     $arrcabecera - Cabecera del documento
	 * @return array $arregloSPG - arreglo con los Movimientos de presupuesto de gasto
	 */
	public function buscarDetalleGasto($arrcabecera,$anio,$mes);

	/**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que busca los detalles de Contabilidad
	 * @param array     $arrcabecera - Cabecera del documento
	 * @return array $arregloSCG - arreglo con los Movimientos de contabilidad
	 */
	public function buscarDetalleContable($arrcabecera,$anio,$mes,$as_depreciacion);	

	/**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que busca los pagos directos por contabilizar
	 * @param string     $as_numdoc - Número de documento
	 * @param string     $as_codban - Codigo de Banco
	 * @param string     $as_ctaban - Cuenta de Banco
	 * @param string     $as_codope - Codigo de operacion
	 * @return valido 	 $boolean - devuelve válido si se pudo contabilizar el movimiento de banco
	 */
	public function buscarInformacionDetalle($as_anio,$as_mes);	
	
	/**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que busca los pagos directos por contabilizar
	 * @param string     $as_numdoc - Número de documento
	 * @param string     $as_codban - Codigo de Banco
	 * @param string     $as_ctaban - Cuenta de Banco
	 * @param string     $as_codope - Codigo de operacion
	 * @return valido 	 $boolean - devuelve válido si se pudo contabilizar el movimiento de banco
	 */
	public function detalleContable($as_anio,$as_mes);
	
	/**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que busca los pagos directos por contabilizar
	 * @param string     $as_numdoc - Número de documento
	 * @param string     $as_codban - Codigo de Banco
	 * @param string     $as_ctaban - Cuenta de Banco
	 * @param string     $as_codope - Codigo de operacion
	 * @return valido 	 $boolean - devuelve válido si se pudo contabilizar el movimiento de banco
	 */
	public function detalleContableDes($as_comp,$as_fecha);
	
}
?>