<?php
/**
 * @author Ing. Yesenia Morenoo
 * @desc Interfaz del servicio creacion de comprobante , 
 * 		 este tiene la finalidad de describir de manera abstracta los metodos que 
 * 		 definen el comportamiento del servicio
 */
interface IComprobante
{
		
	 /**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que verifica si existe un comprobante
	 * @param string $codemp - codigo de empresa
	 * @param string $procede - procede
	 * @param string $comprobante - nro de comprobante
	 * @param string $codban - codigo de banco
	 * @param string $ctaban - cuenta de banco
	 * @return boolean $existe - Si existe el comprobante o no
	 */	
	public function existeComprobante($codemp,$procede,$comprobante,$codban,$ctaban);
	
	 /**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que verifica si existe un procede
	 * @param string $codemp - codigo de empresa
	 * @param string $procede - procede
	 * @return boolean $existe - Si existe la procedencia
	 */	
	public function existeProcedencia($procede);	
	
	 /**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que verifica si la informacion del comprobante esta correcta
	 * @return boolean $valido - Si la informacion del comprobante es válida
	 */	
	public function validarComprobante($arrdetallespg,$arrdetallescg,$arrdetallespi);		

	 /**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que obtiene los detalles de un comprobante presupuestario
	 * @param arreglo $arrdetallespg - Arreglo con la informacion del detalle presupuestario de gasto
	 * @param arreglo $arrdetallescg - Arreglo con la informacion del detalle contable
	 * @param arreglo $arrdetallespi - Arreglo con la informacion del detalle presupuestario de ingreso
	 * @param string  $tipoevento    - tipo de evento si es para normal o si es para anular
	 * @param string  $fechaanula    - Fecha de anulacion para el caso de que el tipo evento sea de anulacion 
	 * @param string  $procedeanula  - Procede de anulacion para el caso de que el tipo evento sea de anulacion
	 * @param string  $conceptoanula - Concepto de anulacion para el caso de que el tipo evento sea de anulacion
	 * @return boolean $valido - Si se obtuvieron los detalles de manera exitosa.
	 */
	public function cargarDetallesComprobante($tipoevento='',$fechaanula='',$procedeanula='',$conceptoanula='');	
	
	 /**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que guarda un comprobante
	 * @param arreglo $arrcabecera - Arreglo con la informacion de la cabecera
	 * @param arreglo $arrdetallespg - Arreglo con la informacion del detalle presupuestario de gasto
	 * @param arreglo $arrdetallescg - Arreglo con la informacion del detalle contable
	 * @param arreglo $arrdetallespi - Arreglo con la informacion del detalle presupuestario de ingreso
	 * @param  arreglo $arrevento - Arreglo con la informacion del evento que se está ejecutando 
	 * @return boolean $valido - Si el comprobante se guardo de manera exitosa
	 */
	public function guardarComprobante($arrcabecera,$arrdetallespg,$arrdetallescg,$arrdetallespi,$arrevento);

	 /**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que guarda un comprobante
	 * @param arreglo $arrcabecera - Arreglo con la informacion de la cabecera
	 * @param  arreglo $arrevento - Arreglo con la informacion del evento que se está ejecutando
	 * @return boolean $valido - Si se elimino el comprobante de manera exitosa
	 */
	public function eliminarComprobante($arrcabecera,$arrevento);

	 /**
	 * @author Ing. Yesenia Moreno
	 * @desc Metodo que guarda un comprobante de anulado
	 * @param arreglo $arrcabecera - Arreglo con la informacion de la cabecera
	 * @param string  $fechaanula    - Fecha de anulacion  
	 * @param string  $procedeanula  - Procede de anulacion 
	 * @param string  $conceptoanula - Concepto de anulacion 
	 * @param arreglo $arrevento - Arreglo con la informacion del evento que se está ejecutando 
	 * @return boolean $valido - Si el comprobante se guardo de manera exitosa
	 */
	public function anularComprobante($arrcabecera,$fechaanula,$procedeanula,$conceptoanula,$arrevento);
	
	
}
?>