<?php
$dirsrv = $_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION['sigesp_sitioweb'];
require_once ($dirsrv.'/base/librerias/php/general/sigesp_lib_funciones.php');
require_once ($dirsrv.'/modelo/servicio/cxp/sigesp_srv_cxp_isolicitudpago.php');
require_once ($dirsrv.'/modelo/servicio/sss/sigesp_srv_sss_evento.php');

class ServicioSolicitudPago implements ISolicitudPago 
{

	public  $mensaje; 
	public  $valido; 
	public  $conexionBaseDatos;
	public $daoDetalle;
	public $daoRegistroSolPag;
		
	public function ServicioSolicitudPago() 
	{
		$this->mensaje = '';
		$this->valido = true;
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$this->daoDetalle = null;
		$this->daoRegistroSolPag = null;
	}
	
	public function buscarSolicitudes($codemp,$numsol,$fecsoldes,$fecsolhas,$tipo,$proben,$tipope,$repcon,$catalogo)
	{
		$cadena = $this->conexionBaseDatos->Concat('nombene',"' '",'apebene');
		if (!empty($fecsoldes) && !empty($fecsolhas)){
			$fecemides = convertirFechaBd($fecsoldes);
			$fecemihas = convertirFechaBd($fecsolhas);
		}
		if(!empty($tipo)){
			if($tipo=="B")
			{
				$cadena_filtro= $cadena_filtro." AND cxp_solicitudes.ced_bene LIKE '".$proben."' ";
			}
			else
			{
				$cadena_filtro= $cadena_filtro." AND cxp_solicitudes.cod_pro LIKE'".$proben."' ";
			}
		}
		if($catalogo=='Aprobacion'){
			$cadena_filtro = $cadena_filtro."   AND cxp_solicitudes.estprosol='E'".
											"   AND cxp_solicitudes.estaprosol='".$tipope."' ";
		}
		if($catalogo=='Anulacion'){
				$cadena_filtro = $cadena_filtro."   AND cxp_solicitudes.estprosol='".$tipope."' ";
		}
		//FILTRO RECEPCIONES CONTABLE
		if($repcon=='1') {
			$filtrofrom = " ,cxp_dt_solicitudes, cxp_rd, cxp_documento";
			$filtroest = " AND cxp_rd.codemp = cxp_dt_solicitudes.codemp ".
			   		     " AND cxp_rd.numrecdoc = cxp_dt_solicitudes.numrecdoc ".
						 " AND cxp_rd.codtipdoc = cxp_dt_solicitudes.codtipdoc ".
						 " AND cxp_rd.ced_bene = cxp_dt_solicitudes.ced_bene ".
						 " AND cxp_rd.cod_pro = cxp_dt_solicitudes.cod_pro ".
						 " AND cxp_solicitudes.codemp = cxp_dt_solicitudes.codemp ".
						 " AND cxp_solicitudes.numsol = cxp_dt_solicitudes.numsol ".
						 " AND cxp_rd.codtipdoc = cxp_documento.codtipdoc AND cxp_documento.estcon=1 AND cxp_documento.estpre=4";
		} 
		//FILTRO RECEPCIONES CONTABLE
		$cadenasql="SELECT DISTINCT cxp_solicitudes.*,".
				"       (CASE WHEN cxp_solicitudes.tipproben='B' THEN (SELECT ".$cadena." ".
				"                                                        FROM rpc_beneficiario".
				"                                                       WHERE cxp_solicitudes.codemp=rpc_beneficiario.codemp".
				"                                                         AND cxp_solicitudes.ced_bene=rpc_beneficiario.ced_bene)".
				"             WHEN cxp_solicitudes.tipproben='P' THEN (SELECT nompro".
				"                                                        FROM rpc_proveedor".
				"                                                       WHERE cxp_solicitudes.codemp=rpc_proveedor.codemp".
				"                                                         AND cxp_solicitudes.cod_pro=rpc_proveedor.cod_pro)".
				"                                                ELSE 'NINGUNO'".
				"         END) AS nombre,".
		        "       (CASE WHEN cxp_solicitudes.tipproben='B' THEN (SELECT rifben ".
				"                                                        FROM rpc_beneficiario".
				"                                                       WHERE cxp_solicitudes.codemp=rpc_beneficiario.codemp".
				"                                                         AND cxp_solicitudes.ced_bene=rpc_beneficiario.ced_bene)".
				"             WHEN cxp_solicitudes.tipproben='P' THEN (SELECT rifpro ".
				"                                                        FROM rpc_proveedor".
				"                                                       WHERE cxp_solicitudes.codemp=rpc_proveedor.codemp".
				"                                                         AND cxp_solicitudes.cod_pro=rpc_proveedor.cod_pro)".
				"                                                ELSE 'NINGUNO'".
				"         END) AS rifpro".
				"  FROM cxp_solicitudes ".$filtrofrom.
				" WHERE cxp_solicitudes.codemp = '".$codemp."'".
				"   AND cxp_solicitudes.numsol LIKE '%".$numsol."%' ".
				"   AND cxp_solicitudes.fecemisol >= '".$fecemides."' ".
				"   AND cxp_solicitudes.fecemisol <= '".$fecemihas."' ".$cadena_filtro.$filtroest.
				" ORDER BY cxp_solicitudes.numsol ";
		$data = $this->conexionBaseDatos->Execute($cadenasql);
		if ($data===false)
		{
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
	}
	
	public function buscarRecepciones($codemp,$numsol)
	{
		$cadenasql="SELECT cxp_dt_solicitudes.numrecdoc, cxp_dt_solicitudes.monto, cxp_dt_solicitudes.codtipdoc,".
				"          cxp_documento.dentipdoc,cxp_dt_solicitudes.cod_pro,cxp_dt_solicitudes.ced_bene,cxp_rd.codproalt,cxp_rd.numexprel ".
				"   FROM cxp_dt_solicitudes,cxp_documento,cxp_rd ".	
				"   WHERE cxp_dt_solicitudes.codemp='".$codemp."' ".
				"     AND cxp_dt_solicitudes.numsol= '".trim($numsol)."' ".
				"     AND cxp_dt_solicitudes.codtipdoc=cxp_documento.codtipdoc".
				"     AND cxp_dt_solicitudes.codemp=cxp_rd.codemp".
				"     AND cxp_dt_solicitudes.numrecdoc=cxp_rd.numrecdoc".
				"     AND cxp_dt_solicitudes.codtipdoc=cxp_rd.codtipdoc".
				"     AND cxp_dt_solicitudes.cod_pro=cxp_rd.cod_pro".
				"     AND cxp_dt_solicitudes.ced_bene=cxp_rd.ced_bene";
		$data = $this->conexionBaseDatos->Execute($cadenasql);
		if ($data===false)
		{
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
	}
	
	function eliminar($codemp,$numsol,$tabla){
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();
		$cadenaSQL = '';
		
		$cadenaSQL = "DELETE FROM {$tabla} ".
				" 	  WHERE codemp='{$codemp}' ".
		        "       AND numsol='{$numsol}' ";
		
		$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= ' Error al eliminar en la tabla '.$tabla.' ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
			return false;
		}
		else{
			return true;
		}
	}
	
	public function guardarSolPag($codemp,$objJson,$arrevento)
	{
		$resultado = 0;//variable que indica el resultado de la operacion
		$i=0;
		$this->valido=true;
		$arreglo = array();
		$arrDetalle = $objJson->detalle;
		$numero = count($arrDetalle);
		$fecha = convertirFechaBd($objJson->fecemisol);
		DaoGenerico::iniciarTrans();
		
		if(!(validarFechaPeriodo($fecha))){
			$this->mensaje .=  'Verifique que el periodo, y el mes de la empresa est&#233;n abiertos';
			$this->valido = false;	
		}
		if($this->valido){
			//obteniendo las instacias de los dao's
			$this->daoRegistroSolPag = FabricaDao::CrearDAO("N","cxp_solicitudes");
			//seteando la data e iniciando transaccion de base de datos
			$this->daoRegistroSolPag->setData($objJson);
			$this->daoRegistroSolPag->codemp=$codemp;
			$this->daoRegistroSolPag->fecemisol = $fecha;
			if($objJson->tipproben=='P'){
				$this->daoRegistroSolPag->cod_pro=$objJson->cod_pro;
				$this->daoRegistroSolPag->ced_bene='----------';
			}
			else{
				$this->daoRegistroSolPag->ced_bene=$objJson->cod_pro;
				$this->daoRegistroSolPag->cod_pro='----------';
			}
			$this->daoRegistroSolPag->monant = formatoNumericoBd($objJson->monsol,1); 
			
			if($objJson->evento=='INSERT'){
				$resultado = $this->daoRegistroSolPag->incluir(true,"numsol",true,15);
				$arrcadres = explode(",",$resultado);
				//insertando el registro y escribiendo en el log
			}
			else{
				$this->daoRegistroSolPag->modificar();
				//insertando el registro y escribiendo en el log
			}	
			if($numero>0){
				if($objJson->evento=='UPDATE'){
					$this->valido = $this->eliminar($codemp,$this->daoRegistroSolPag->numsol,'cxp_dt_solicitudes');
				}
				if($this->valido){
					foreach ($arrDetalle as $arreglo)
					{
						$this->daoDetalle = FabricaDao::CrearDAO("N","cxp_dt_solicitudes");
						$this->daoDetalle->setData($arreglo);
						$this->daoDetalle->codemp = $codemp;
						if($objJson->tipproben=='P'){
							$this->daoDetalle->cod_pro=$objJson->cod_pro;
							$this->daoDetalle->ced_bene='----------';
						}
						else{
							$this->daoDetalle->ced_bene=$objJson->cod_pro;
							$this->daoDetalle->cod_pro='----------';
						}
						$this->daoDetalle->monto = formatoNumericoBd($arreglo->monto,1); 
						if(!$this->daoDetalle->incluir())
						{
							$this->mensaje .= 'Error al guardar el detalle de cuentas en cxp_dt_solicitudes->';
							break;
						}
					}
				}
			}
			$servicioEvento = new ServicioEvento();
			$servicioEvento->evento=$arrevento['evento'];
			$servicioEvento->codemp=$arrevento['codemp'];
			$servicioEvento->codsis=$arrevento['codsis'];
			$servicioEvento->nomfisico=$arrevento['nomfisico'];
			$servicioEvento->desevetra=$arrevento['desevetra'];
	
			//completando la transaccion retorna 1 si no hay errores
			if(DaoGenerico::completarTrans($this->valido)) {
				$servicioEvento->tipoevento=true;
				$servicioEvento->incluirEvento();
				if($arrcadres[0]==1 || $objJson->evento=='UPDATE'){
					$this->mensaje.='Registro guardado con exito';
				}
				else{
					$this->mensaje.='Registro guardado con exito, con el c&#243;digo '.$arrcadres[1];
				}	 		
			}
			else{
				$arrevento ['desevetra'] = $mensaje.$this->daoRegistroSolPag->ErrorMsg();
				$servicioEvento->tipoevento=false;
				$servicioEvento->desevetra=$arrevento['desevetra'];
				$servicioEvento->incluirEvento();
				$this->valido=false;
				$this->mensaje.=$this->daoRegistroSolPag->ErrorMsg();
			}
			 
			//liberando variables y retornando el resultado de la operacion
			unset($this->daoRegistroSolPag);
			unset($this->daoRegistroEvento);
		}
		return $this->valido;
	}
	
	public function eliminarSolPag($codemp,$objJson,$arrevento)
	{
		$resultado = 0;//variable que indica el resultado de la operacion
		$i=0;
		$this->valido=true;
		$fecha = convertirFechaBd($objJson->fecemisol);
		DaoGenerico::iniciarTrans();
		
		if(!(validarFechaPeriodo($fecha))){
			$this->mensaje .=  'Verifique que el periodo, y el mes de la empresa est&#233;n abiertos';
			$this->valido = false;	
		}
		if($this->valido){
			//obteniendo las instacias de los dao's
			$this->daoRegistroSolPag = FabricaDao::CrearDAO("N","cxp_solicitudes");
			//seteando la data e iniciando transaccion de base de datos
			$this->daoRegistroSolPag->setData($objJson);
			$this->daoRegistroSolPag->codemp=$codemp;
			$this->daoRegistroSolPag->fecemisol = $fecha;
			if($objJson->tipproben=='P'){
				$this->daoRegistroSolPag->cod_pro=$objJson->cod_pro;
				$this->daoRegistroSolPag->ced_bene='----------';
			}
			else{
				$this->daoRegistroSolPag->ced_bene=$objJson->cod_pro;
				$this->daoRegistroSolPag->cod_pro='----------';
			}
			$this->daoRegistroSolPag->monant = formatoNumericoBd($objJson->monsol,1); 
			$this->valido = $this->eliminar($codemp,$this->daoRegistroSolPag->numsol,'cxp_dt_solicitudes');
			if($this->valido){
				$this->daoRegistroSolPag->eliminar();
			}
			$servicioEvento = new ServicioEvento();
			$servicioEvento->evento=$arrevento['evento'];
			$servicioEvento->codemp=$arrevento['codemp'];
			$servicioEvento->codsis=$arrevento['codsis'];
			$servicioEvento->nomfisico=$arrevento['nomfisico'];
			$servicioEvento->desevetra=$arrevento['desevetra'];
	
			//completando la transaccion retorna 1 si no hay errores
			if(DaoGenerico::completarTrans($this->valido)) {
				$servicioEvento->tipoevento=true;
				$servicioEvento->incluirEvento();
				$this->mensaje.='Registro eliminado con exito'; 		
			}
			else{
				$arrevento ['desevetra'] = $mensaje.$this->daoRegistroSolPag->ErrorMsg();
				$servicioEvento->tipoevento=false;
				$servicioEvento->desevetra=$arrevento['desevetra'];
				$servicioEvento->incluirEvento();
				$this->valido=false;
				$this->mensaje.=$this->daoRegistroSolPag->ErrorMsg();
			}
			 
			//liberando variables y retornando el resultado de la operacion
			unset($this->daoRegistroSolPag);
			unset($this->daoRegistroEvento);
		}
		return $this->valido;
	}
}
?>