<?php
$dirsrv = $_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION['sigesp_sitioweb'];
require_once ($dirsrv.'/base/librerias/php/general/sigesp_lib_fabricadao.php');
require_once ($dirsrv.'/base/librerias/php/general/sigesp_lib_funciones.php');
require_once ($dirsrv.'/modelo/servicio/sss/sigesp_srv_sss_evento.php');
require_once ($dirsrv."/modelo/servicio/cxp/sigesp_srv_cxp_ianulacionsolicitudpago.php");



class ServicioAnulacionSolPag implements IServicioAnulacionSolPag
{

	public  $mensaje; 
	public  $valido; 
	public  $conexionBaseDatos;
	public  $servicioComprobante;
		
	public function ServicioAnulacionSolPag() 
	{
		$this->mensaje = '';
		$this->valido = true;
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();		
	}
	
	public function ActualizarEstatus($objson) 
	{
		$arrRespuesta= array();
		$nSol = count($objson->arrRecepciones);
		$h = 0;
		$nOk = 0;
		$nEr = 0;
		$this->valido=true;
		$this->mensaje='';
		$arrevento['codemp']    = $_SESSION['la_empresa']['codemp'];
		$arrevento['codusu']    = $_SESSION['la_logusr'];
		$arrevento['codsis']    = $objson->codsis;
		$arrevento['evento']    = 'UPDATE';
		$arrevento['nomfisico'] = $objson->nomven;
		$fecha=convertirFechaBd($objson->fecha);
		if($objson->estatus=='E'){
			for($j=0;$j<=$nSol-1;$j++)
			{
				$arrevento['desevetra'] = "Anular la solicitud de pago numero {$objson->arrRecepciones[$j]->numsol}, asociado a la empresa {$_SESSION['la_empresa']['codemp']}";
				if($this->anular($_SESSION['la_empresa']['codemp'],$objson->arrRecepciones[$j]->numsol,$objson->arrRecepciones[$j]->fecemisol,
				                  $objson->arrRecepciones[$j]->cod_pro,$objson->arrRecepciones[$j]->ced_bene,
				                  $objson->arrRecepciones[$j]->tipproben,$objson->arrRecepciones[$j]->estaprosol,$fecha,$arrevento)) 
				{
					$nOk++;
					$arrRespuesta[$h]['estatus'] = 1;
					$arrRespuesta[$h]['documento'] = $objson->arrRecepciones[$j]->numsol;
					$arrRespuesta[$h]['mensaje'] = 'Solicitud anulada satisfactoriamente';
				}
				else 
				{
					$nEr++;
					$arrRespuesta[$h]['estatus'] = 0;
					$arrRespuesta[$h]['documento'] = $objson->arrRecepciones[$j]->numsol;
					$arrRespuesta[$h]['mensaje'] = "La Solicitud no pudo ser anulada, {$this->mensaje} ";
				}
				$h++;
			}
		}
		else{
			for($j=0;$j<=$nSol-1;$j++)
			{
				$arrevento['desevetra'] = "Reversar la anulacion de la solicitud de pago numero {$objson->arrRecepciones[$j]->numsol}, asociado a la empresa {$_SESSION['la_empresa']['codemp']}";
				if($this->reversar_anulacion($_SESSION['la_empresa']['codemp'],$objson->arrRecepciones[$j]->numsol,$objson->arrRecepciones[$j]->fecemisol,
				                             $objson->arrRecepciones[$j]->cod_pro,$objson->arrRecepciones[$j]->ced_bene,
				                             $objson->arrRecepciones[$j]->tipproben,$objson->arrRecepciones[$j]->estaprosol,$fecha,$arrevento)) 
				{
					$nOk++;
					$arrRespuesta[$h]['estatus'] = 1;
					$arrRespuesta[$h]['documento'] = $objson->arrRecepciones[$j]->numsol;
					$arrRespuesta[$h]['mensaje'] = 'Solicitud reversada satisfactoriamente';
				}
				else 
				{
					$nEr++;
					$arrRespuesta[$h]['estatus'] = 0;
					$arrRespuesta[$h]['documento'] = $objson->arrRecepciones[$j]->numsol;
					$arrRespuesta[$h]['mensaje'] = "La Solicitud no pudo ser reversada, {$this->mensaje} ";
				}
				$h++;
			}
		}
		$detalleResultado = generarJsonArreglo($arrRespuesta);
		
		return $nSol.'|'.$nOk.'|'.$nEr.'|'.$detalleResultado;
	}
	
    public function anular($codemp,$numsol,$fecemisol,$codpro,$cedbene,$tipproben,$estaprosol,$fecha,$arrevento)
	{
 		DaoGenerico::iniciarTrans();  
 		$fecemisol=convertirFechaBd($fecemisol);
 		$this->valido=true;
 		// VERIFICO QUE LA FECHA DE ANULACIoN DE LA SOLICITUD SEA MAYOR O IGUAL A LA FECHA DE REGISTRO
 		if($fecemisol>$fecha){
 			$this->mensaje .= 'ERROR -> La Fecha de Registro de la Solicitud '.$numsol.' debe ser menor a la fecha de Anulaci&#243;n ';
			$this->valido = false;
 		}	
 		if($this->valido){
 			// OBTENGO LA SOLICITUD DE PAGO
			$criterio="codemp = '".$_SESSION['la_empresa']['codemp']."' AND numsol='".$numsol."' AND cod_pro='".$codpro."' ".
			          "  AND ced_bene='".$cedbene."' AND tipproben='".$tipproben."' AND estaprosol='".$estaprosol."' ";
			$this->daoSolicitud = FabricaDao::CrearDAO('C','cxp_solicitudes','',$criterio);
			if($this->daoSolicitud->numrecdoc=='')
			{
				$this->mensaje .= 'ERROR -> La Solicitud '.$numsol.', no Existe';
				$this->valido = false;			
			}	
 		}	
		if($this->valido){
			$this->valido=validarFechaPeriodo($fecha);
			if($this->valido){
				$this->daoSolicitud->estprosol="N";
				$this->daoSolicitud->fechaanula=$fecha;
				$this->valido = $this->daoSolicitud->modificar();
				if(!$this->valido)
				{
					$this->mensaje .= $this->daoSolicitud->ErrorMsg;
				}
			}
			else{
				$this->mensaje .= 'Verifique que el mes este abierto ';
				$this->valido = false;
			}
		}
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->tipoevento=$this->valido; 
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];			
		if (DaoGenerico::completarTrans($this->valido)) 
		{
			$servicioEvento->incluirEvento();
		}
		else
		{
			$servicioEvento->desevetra=$this->mensaje;
			$servicioEvento->incluirEvento();
		}
		unset($servicioEvento);
		return $this->valido;
    }
    
	public function reversar_anulacion($codemp,$numsol,$fecemisol,$codpro,$cedbene,$tipproben,$estaprosol,$fecha,$arrevento)
	{
 		DaoGenerico::iniciarTrans();  
 		$fecemisol=convertirFechaBd($fecemisol);
 		$this->valido=true;
 		if($this->valido){
 			// OBTENGO LA RECEPCION DE DOCUMENTO
			$criterio="codemp = '".$_SESSION['la_empresa']['codemp']."' AND numsol='".$numsol."' AND cod_pro='".$codpro."' ".
			          "  AND ced_bene='".$cedbene."' AND tipproben='".$tipproben."' AND estaprosol='".$estaprosol."' ";
			$this->daoSolicitud = FabricaDao::CrearDAO('C','cxp_solicitudes','',$criterio);
			if($this->daoSolicitud->numrecdoc=='')
			{
				$this->mensaje .= 'ERROR -> La Solicitud '.$numsol.', no Existe';
				$this->valido = false;			
			}	
 		}	
		if($this->valido){
			$this->valido=validarFechaPeriodo($fecha);
			if($this->valido){
				$this->daoSolicitud->estprosol="E";
				$this->daoSolicitud->fechaanula="1900-01-01";
				$this->valido = $this->daoSolicitud->modificar();
				if(!$this->valido)
				{
					$this->mensaje .= $this->daoSolicitud->ErrorMsg;
				}
			}
			else{
				$this->mensaje .= 'Verifique que el mes este abierto ';
				$this->valido = false;
			}
		}
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->tipoevento=$this->valido; 
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];			
		if (DaoGenerico::completarTrans($this->valido)) 
		{
			$servicioEvento->incluirEvento();
		}
		else
		{
			$servicioEvento->desevetra=$this->mensaje;
			$servicioEvento->incluirEvento();
		}
		unset($servicioEvento);
		return $this->valido;
    }
}
?>