<?php
$dirsrv = $_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION['sigesp_sitioweb'];
require_once ($dirsrv.'/base/librerias/php/general/sigesp_lib_fabricadao.php');
require_once ($dirsrv.'/base/librerias/php/general/sigesp_lib_funciones.php');
require_once ($dirsrv."/modelo/servicio/cxp/sigesp_srv_cxp_ianulacionrecepcion.php");



class ServicioAnulacionRecDoc implements IServicioAnulacionRecDoc
{

	public  $mensaje; 
	public  $valido; 
	public  $conexionBaseDatos;
	public  $servicioComprobante;
		
	public function ServicioAnulacionRecDoc() 
	{
		$this->mensaje = '';
		$this->valido = true;
		$this->conexionBaseDatos = ConexionBaseDatos::getInstanciaConexion();		
	}
	
	
	
	public function ActualizarEstatus($objson) 
	{
		$arrRespuesta= array();
		$nSol = count($objson->arrRecepciones);
		$h = 0;
		$nOk = 0;
		$nEr = 0;
		$this->valido=true;
		$this->mensaje='';
		$arrevento['codemp']    = $_SESSION['la_empresa']['codemp'];
		$arrevento['codusu']    = $_SESSION['la_logusr'];
		$arrevento['codsis']    = $objson->codsis;
		$arrevento['evento']    = 'UPDATE';
		$arrevento['nomfisico'] = $objson->nomven;
		$fecha=convertirFechaBd($objson->fecha);
		for($j=0;$j<=$nSol-1;$j++)
		{
			$arrevento['desevetra'] = "Anular la recepcion de documento numero {$objson->arrRecepciones[$j]->numrecdoc}, asociado a la empresa {$_SESSION['la_empresa']['codemp']}";
			if($this->anular($_SESSION['la_empresa']['codemp'],$objson->arrRecepciones[$j]->numrecdoc,$objson->arrRecepciones[$j]->fecregdoc,
			                  $objson->arrRecepciones[$j]->cod_pro,$objson->arrRecepciones[$j]->ced_bene,
			                  $objson->arrRecepciones[$j]->codtipdoc,$fecha,$arrevento)) 
			{
				$nOk++;
				$arrRespuesta[$h]['estatus'] = 1;
				$arrRespuesta[$h]['documento'] = $objson->arrRecepciones[$j]->numrecdoc;
				$arrRespuesta[$h]['mensaje'] = 'Recepci&#243;n anulada satisfactoriamente';
			}
			else 
			{
				$nEr++;
				$arrRespuesta[$h]['estatus'] = 0;
				$arrRespuesta[$h]['documento'] = $objson->arrRecepciones[$j]->numrecdoc;
				$arrRespuesta[$h]['mensaje'] = "La Recepci&#243;n no pudo ser anulada, {$this->mensaje} ";
			}
			$h++;
		}
		$detalleResultado = generarJsonArreglo($arrRespuesta);
		
		return $nSol.'|'.$nOk.'|'.$nEr.'|'.$detalleResultado;
	}
	
    public function anular($codemp,$numrecdoc,$fecregdoc,$codpro,$cedbene,$codtipdoc,$fecha,$arrevento)
	{
 		DaoGenerico::iniciarTrans();  
 		$fecregdoc=convertirFechaBd($fecregdoc);
 		$this->valido=true;
 		// VERIFICO QUE LA FECHA DE Aprobacion DE LA RECEPCIoN SEA MAYOR O IGUAL A LA FECHA DE REGISTRO
 		if($fecregdoc>$fecha){
 			$this->mensaje .= 'ERROR -> La Fecha de Registro de la Recepc&#243;n '.$numrecdoc.' debe ser menor a la fecha de Anulaci&#243;n ';
			$this->valido = false;
 		}	
 		if($this->valido){
 			// OBTENGO LA RECEPCION DE DOCUMENTO
			$criterio="codemp = '".$_SESSION['la_empresa']['codemp']."' AND numrecdoc='".$numrecdoc."' AND cod_pro='".$codpro."' ".
			          "  AND ced_bene='".$cedbene."' AND codtipdoc='".$codtipdoc."' ";
			$this->daoRecepcion = FabricaDao::CrearDAO('C','cxp_rd','',$criterio);
			if($this->daoRecepcion->numrecdoc=='')
			{
				$this->mensaje .= 'ERROR -> La Recepc&#243;n '.$numrecdoc.', no Existe';
				$this->valido = false;			
			}	
 		}	
		if($this->valido){
			$numrecdocnew="";
			$numrecdocnew=$this->numero_anulado($codemp,$numrecdoc,'1',$codpro,$cedben,$codtipdoc);
			if($numrecdocnew!=""){
				$this->valido=$this->insertar_rd_anulada($codemp,$numrecdoc,$numrecdocnew,$codpro,$cedbene,$codtipdoc,$this->daoRecepcion,$fecha);
				if($this->valido){
					$this->valido=$this->insertar_dt_cargos_anulada($codemp,$numrecdoc,$fecregdoc,$codpro,$cedbene,$codtipdoc,$fecha);
				}
				if($this->valido){
					$this->valido=$this->insertar_dt_deducciones_anulada($codemp,$numrecdoc,$fecregdoc,$codpro,$cedbene,$codtipdoc,$fecha);
				}
				if($this->valido){
					$this->valido=$this->insertar_dt_spg_anulada($codemp,$numrecdoc,$fecregdoc,$codpro,$cedbene,$codtipdoc,$fecha);
				}
				if($this->valido){
					$this->valido=$this->insertar_dt_scg_anulada($codemp,$numrecdoc,$fecregdoc,$codpro,$cedbene,$codtipdoc,$fecha);
				}
				if($this->valido){
					$this->valido=$this->insertar_dt_solicitud_anulada($codemp,$numrecdoc,$fecregdoc,$codpro,$cedbene,$codtipdoc,$fecha);
				}
				if($this->valido){
					$this->valido=$this->insertar_dt_amortizacion_anulada($codemp,$numrecdoc,$fecregdoc,$codpro,$cedbene,$codtipdoc,$fecha);
				}
				if($this->valido){
					$this->valido=$this->insertar_dt_anticipo_anulada($codemp,$numrecdoc,$fecregdoc,$codpro,$cedbene,$codtipdoc,$fecha);
				}
				if($this->valido){
					$this->valido=$this->eliminar($codemp,$numrecdoc,$fecregdoc,$codpro,$cedbene,$codtipdoc,$this->daoRecepcion,$fecha);
				}
			}
		}
		$servicioEvento = new ServicioEvento();
		$servicioEvento->evento=$arrevento['evento'];
		$servicioEvento->tipoevento=$this->valido; 
		$servicioEvento->codemp=$arrevento['codemp'];
		$servicioEvento->codsis=$arrevento['codsis'];
		$servicioEvento->nomfisico=$arrevento['nomfisico'];
		$servicioEvento->desevetra=$arrevento['desevetra'];			
		if (DaoGenerico::completarTrans($this->valido)) 
		{
			$servicioEvento->incluirEvento();
		}
		else
		{
			$servicioEvento->desevetra=$this->mensaje;
			$servicioEvento->incluirEvento();
		}
		unset($servicioEvento);
		return $this->valido;
    }
    
    public function numero_anulado($codemp,$numrecdoc,$estsol,$codpro,$cedben,$codtipdoc) //$estsol=1
	{
		$existe=true;
		$i=0;
		$lonnumrecdoc = strlen(trim($numrecdoc));
		$prenumrec    = substr(trim($numrecdoc),0,4);//Prefijo del Número de la Recepcion de Documentos.
		while($existe)
		{
			$i=$i+1;
			if ($prenumrec=='SCV-' && $lonnumrecdoc>=14)//Para el Caso de las Solicitudes de Viaticos SCV-00000000000.
			{
				$numrecdoc = substr(trim($numrecdoc),0,3).substr(trim($numrecdoc),5,15);
				$numrecdocnew="@".$i.$numrecdoc;
			}
			else
			{
			    $numrecdocnew="@".$i.$numrecdoc;
			}
			$lonnewnumrecdoc = strlen(trim($numrecdocnew));
			if($lonnewnumrecdoc>15)
			{
				$numrecdocnew=substr($numrecdocnew,0,15);			
			}
			$sql="SELECT numrecdoc FROM cxp_rd ".
				 "WHERE codemp='".$codemp."' ".
				 "   AND numrecdoc='".$numrecdocnew."' ".
				 "   AND cod_pro='".$codpro."' ".
				 "   AND ced_bene='".$cedben."' ".
				 "   AND codtipdoc='".$codtipdoc."' ";
			$data = $this->conexionBaseDatos->Execute($sql);
			if ($data===false)
			{
				$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido = false;
			}
			else
			{
				if($data->field['numrecdoc']=='')
				{
					$existe=false;
				}
			}
		}
		return $numrecdocnew;
	}// end function uf_load_numero_anulado
	
    public function insertar_rd_anulada($codemp,$numrecdoc,$numrecdocnew,$codpro,$cedbene,$codtipdoc,$recepcion,$fecha){
    	//obteniendo las instacias de los dao's
    	$this->daoRegistroRecDocAnu = FabricaDao::CrearDAO("N","cxp_rd");
		//seteando la data e iniciando transaccion de base de datos
		$this->daoRegistroRecDocAnu->codemp=$codemp;
		$this->daoRegistroRecDocAnu->numrecdoc=$numrecdocnew;
		$this->daoRegistroRecDocAnu->codtipdoc = $codtipdoc;
		$this->daoRegistroRecDocAnu->numref = $recepcion->numref;
		$this->daoRegistroRecDocAnu->tipproben = $recepcion->tipproben;
		$this->daoRegistroRecDocAnu->cod_pro = $codpro;
		$this->daoRegistroRecDocAnu->ced_bene = $cedbene;
		$this->daoRegistroRecDocAnu->codcla = $recepcion->codcla;
		$this->daoRegistroRecDocAnu->dencondoc = $recepcion->dencondoc;
		$this->daoRegistroRecDocAnu->fecemidoc = convertirFechaBd($recepcion->fecemidoc);
		$this->daoRegistroRecDocAnu->fecregdoc = convertirFechaBd($recepcion->fecregdoc);
		$this->daoRegistroRecDocAnu->fecvendoc = convertirFechaBd($recepcion->fecvendoc);
		$this->daoRegistroRecDocAnu->montotdoc = number_format($recepcion->montotdoc,2,'.','');
		$this->daoRegistroRecDocAnu->mondeddoc = number_format($recepcion->mondeddoc,2,'.','');
		$this->daoRegistroRecDocAnu->moncardoc = number_format($recepcion->moncardoc,2,'.','');
		$this->daoRegistroRecDocAnu->procede = $recepcion->procede; 
		$this->daoRegistroRecDocAnu->estprodoc = 'A';
		$this->daoRegistroRecDocAnu->fecaprord = '1900-01-01';
		$this->daoRegistroRecDocAnu->usuaprord = '-';
		$this->daoRegistroRecDocAnu->estlibcom = '0';
		$this->daoRegistroRecDocAnu->estaprord = '0';
		$this->daoRegistroRecDocAnu->codrecdoc ='000000000000000';
    	if(!$this->daoRegistroRecDocAnu->incluir()){
    		$this->mensaje .= ' CLASE->SPG METODO->insertar_rd_anulada ERROR->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido=false;
		}
		return $this->valido;
    }
    
    public function buscar_cargos($codemp,$numrecdoc,$codpro,$cedbene,$codtipdoc){
    	$data='';
    	$cadenasql="SELECT codemp, numrecdoc, codtipdoc, cod_pro, ced_bene, codcar, procede_doc,".
				" 		numdoccom, monobjret, monret, codestpro1, codestpro2, codestpro3, codestpro4,".
				"		codestpro5, estcla, spg_cuenta, porcar, formula".
				"   FROM cxp_rd_cargos".
				"   WHERE codemp = '".$codemp."'".
				"     AND numrecdoc = '".$numrecdoc."'".
				"     AND cod_pro = '".$codpro."'".
				"     AND ced_bene = '".$cedben."'".
				"     AND codtipdoc = '".$codtipdoc."'";
   		$data = $this->conexionBaseDatos->Execute($cadenasql);
		if ($data===false)
		{
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
    }
    
	public function insertar_dt_cargos_anulada($codemp,$numrecdoc,$numrecdocnew,$codpro,$cedbene,$codtipdoc,$fecha)
	{
    	// OBTENER CARGOS
		$data=$this->buscar_cargos($codemp,$numrecdoc,$codpro,$cedbene,$codtipdoc);
		while(!$data->EOF){
			//obteniendo las instacias de los dao's
			$this->daoRegistroDtCargos = FabricaDao::CrearDAO("N","cxp_rd_cargos");
			//seteando la data e iniciando transaccion de base de datos
			$this->daoRegistroDtCargos->codemp=$codemp;
			$this->daoRegistroDtCargos->numrecdoc=$numrecdocnew;
			$this->daoRegistroDtCargos->codtipdoc = $codtipdoc;
			$this->daoRegistroDtCargos->cod_pro = $codpro;
			$this->daoRegistroDtCargos->ced_bene = $cedbene;
			$this->daoRegistroDtCargos->codcar = $data->fields['codcar'];
			$this->daoRegistroDtCargos->procede_doc = $data->fields['procede_doc']; 
			$this->daoRegistroDtCargos->numdoccom = $data->fields['numdoccom']; 
			$this->daoRegistroDtCargos->monobjret= number_format($data->fields['monobjret'],2,'.',''); 
			$this->daoRegistroDtCargos->monret= number_format($data->fields['monret'],2,'.',''); 
			$this->daoRegistroDtCargos->codestpro1 = $data->fields['codestpro1'];
			$this->daoRegistroDtCargos->codestpro2 = $data->fields['codestpro2'];
			$this->daoRegistroDtCargos->codestpro3 = $data->fields['codestpro3'];
			$this->daoRegistroDtCargos->codestpro4 = $data->fields['codestpro4'];
			$this->daoRegistroDtCargos->codestpro5 = $data->fields['codestpro5'];
			$this->daoRegistroDtCargos->estcla = $data->fields['estcla'];
			$this->daoRegistroDtCargos->spg_cuenta = $data->fields['spg_cuenta'];
			$this->daoRegistroDtCargos->porcar = $data->fields['porcar'];
			$this->daoRegistroDtCargos->formula = $data->fields['formula'];
	    	if(!$this->daoRegistroDtCargos->incluir()){
	    		$this->mensaje .= ' CLASE->SPG METODO->insertar_dt_cargos_anulada ERROR->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido=false;
			}
			$data->MoveNext();
		}
		return $this->valido;
    }
    
	public function buscar_deducciones($codemp,$numrecdoc,$codpro,$cedbene,$codtipdoc){
    	$data='';
    	$cadenasql="SELECT codemp, numrecdoc, codtipdoc, cod_pro, ced_bene, codded, procede_doc,".
				" 		   numdoccom, monobjret, monret, sc_cuenta, porded".
				"   FROM cxp_rd_deducciones".
				"   WHERE codemp = '".$codemp."'".
				"     AND numrecdoc = '".$numrecdoc."'".
				"     AND cod_pro = '".$codpro."'".
				"     AND ced_bene = '".$cedben."'".
				"     AND codtipdoc = '".$codtipdoc."'";
   		$data = $this->conexionBaseDatos->Execute($cadenasql);
		if ($data===false)
		{
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
    }
    
	public function insertar_dt_deducciones_anulada($codemp,$numrecdoc,$numrecdocnew,$codpro,$cedbene,$codtipdoc,$fecha)
	{
    	// OBTENER CARGOS
		$data=$this->buscar_deducciones($codemp,$numrecdoc,$codpro,$cedbene,$codtipdoc);
		while(!$data->EOF){
			//obteniendo las instacias de los dao's
			$this->daoRegistroDtDeducciones = FabricaDao::CrearDAO("N","cxp_rd_deducciones");
			//seteando la data e iniciando transaccion de base de datos
			$this->daoRegistroDtDeducciones->codemp=$codemp;
			$this->daoRegistroDtDeducciones->numrecdoc=$numrecdocnew;
			$this->daoRegistroDtDeducciones->codtipdoc = $codtipdoc;
			$this->daoRegistroDtDeducciones->cod_pro = $codpro;
			$this->daoRegistroDtDeducciones->ced_bene = $cedbene;
			$this->daoRegistroDtDeducciones->codded = $data->fields['codded'];
			$this->daoRegistroDtDeducciones->procede_doc = $data->fields['procede_doc']; 
			$this->daoRegistroDtDeducciones->numdoccom = $data->fields['numdoccom']; 
			$this->daoRegistroDtDeducciones->monobjret= number_format($data->fields['monobjret'],2,'.',''); 
			$this->daoRegistroDtDeducciones->monret= number_format($data->fields['monret'],2,'.','');
			$this->daoRegistroDtDeducciones->sc_cuenta = $data->fields['sc_cuenta'];
			$this->daoRegistroDtDeducciones->porded = $data->fields['porded'];
	    	if(!$this->daoRegistroDtDeducciones->incluir()){
	    		$this->mensaje .= ' CLASE->SPG METODO->insertar_dt_deducciones_anulada ERROR->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido=false;
			}
			$data->MoveNext();
		}
		return $this->valido;
    }
    
	public function buscar_dt_spg($codemp,$numrecdoc,$codpro,$cedbene,$codtipdoc){
    	$data='';
    	$cadenasql="SELECT codemp, numrecdoc, codtipdoc, ced_bene, cod_pro, procede_doc, numdoccom, codestpro, estcla, spg_cuenta, monto ".
				"   FROM cxp_rd_spg".
				"   WHERE codemp = '".$codemp."'".
				"     AND numrecdoc = '".$numrecdoc."'".
				"     AND cod_pro = '".$codpro."'".
				"     AND ced_bene = '".$cedben."'".
				"     AND codtipdoc = '".$codtipdoc."'";
   		$data = $this->conexionBaseDatos->Execute($cadenasql);
		if ($data===false)
		{
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
    }
    
	public function insertar_dt_spg_anulada($codemp,$numrecdoc,$numrecdocnew,$codpro,$cedbene,$codtipdoc,$fecha)
	{
    	// OBTENER CARGOS
		$data=$this->buscar_dt_spg($codemp,$numrecdoc,$codpro,$cedbene,$codtipdoc);
		while(!$data->EOF){
			//obteniendo las instacias de los dao's
			$this->daoRegistroDtSPG = FabricaDao::CrearDAO("N","cxp_rd_spg");
			//seteando la data e iniciando transaccion de base de datos
			$this->daoRegistroDtSPG->codemp=$codemp;
			$this->daoRegistroDtSPG->numrecdoc=$numrecdocnew;
			$this->daoRegistroDtSPG->codtipdoc = $codtipdoc;
			$this->daoRegistroDtSPG->cod_pro = $codpro;
			$this->daoRegistroDtSPG->ced_bene = $cedbene;
			$this->daoRegistroDtSPG->procede_doc = $data->fields['procede_doc']; 
			$this->daoRegistroDtSPG->numdoccom = $data->fields['numdoccom']; 
			$this->daoRegistroDtSPG->monto= number_format($data->fields['monto'],2,'.',''); 
			$this->daoRegistroDtSPG->codestpro = $data->fields['codestpro'];
			$this->daoRegistroDtSPG->estcla = $data->fields['estcla'];
			$this->daoRegistroDtSPG->spg_cuenta = $data->fields['spg_cuenta'];
	    	if(!$this->daoRegistroDtSPG->incluir()){
	    		$this->mensaje .= ' CLASE->SPG METODO->insertar_dt_spg_anulada ERROR->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido=false;
			}
			$data->MoveNext();
		}
		return $this->valido;
    }
    
	public function buscar_dt_scg($codemp,$numrecdoc,$codpro,$cedbene,$codtipdoc){
    	$data='';
    	$cadenasql="SELECT codemp, numrecdoc, codtipdoc, ced_bene, cod_pro, procede_doc, numdoccom,".
				"		   debhab, sc_cuenta, monto, estgenasi, estasicon ".
				"   FROM cxp_rd_scg".
				"   WHERE codemp = '".$codemp."'".
				"     AND numrecdoc = '".$numrecdoc."'".
				"     AND cod_pro = '".$codpro."'".
				"     AND ced_bene = '".$cedben."'".
				"     AND codtipdoc = '".$codtipdoc."'";
   		$data = $this->conexionBaseDatos->Execute($cadenasql);
		if ($data===false)
		{
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
    }
    
	public function insertar_dt_scg_anulada($codemp,$numrecdoc,$numrecdocnew,$codpro,$cedbene,$codtipdoc,$fecha)
	{
    	// OBTENER CARGOS
		$data=$this->buscar_dt_scg($codemp,$numrecdoc,$codpro,$cedbene,$codtipdoc);
		while(!$data->EOF){
			//obteniendo las instacias de los dao's
			$this->daoRegistroDtSCG = FabricaDao::CrearDAO("N","cxp_rd_scg");
			//seteando la data e iniciando transaccion de base de datos
			$this->daoRegistroDtSCG->codemp=$codemp;
			$this->daoRegistroDtSCG->numrecdoc=$numrecdocnew;
			$this->daoRegistroDtSCG->codtipdoc = $codtipdoc;
			$this->daoRegistroDtSCG->cod_pro = $codpro;
			$this->daoRegistroDtSCG->ced_bene = $cedbene;
			$this->daoRegistroDtSCG->procede_doc = $data->fields['procede_doc']; 
			$this->daoRegistroDtSCG->numdoccom = $data->fields['numdoccom']; 
			$this->daoRegistroDtSCG->monto= number_format($data->fields['monto'],2,'.',''); 
			$this->daoRegistroDtSCG->debhab = $data->fields['debhab'];
			$this->daoRegistroDtSCG->estasicon = $data->fields['estasicon'];
			$this->daoRegistroDtSCG->sc_cuenta = $data->fields['sc_cuenta'];
			$this->daoRegistroDtSCG->estgenasi = $data->fields['estgenasi'];
	    	if(!$this->daoRegistroDtSCG->incluir()){
	    		$this->mensaje .= ' CLASE->SPG METODO->insertar_dt_scg_anulada ERROR->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido=false;
			}
			$data->MoveNext();
		}
		return $this->valido;
    }
    
	public function buscar_dt_solicitudes($codemp,$numrecdoc,$codpro,$cedbene,$codtipdoc){
    	$data='';
    	$cadenasql="SELECT codemp, numsol, numrecdoc, codtipdoc, ced_bene, cod_pro, monto ".
				"   FROM cxp_dt_solicitudes".
				"   WHERE codemp = '".$codemp."'".
				"     AND numrecdoc = '".$numrecdoc."'".
				"     AND cod_pro = '".$codpro."'".
				"     AND ced_bene = '".$cedben."'".
				"     AND codtipdoc = '".$codtipdoc."'";
   		$data = $this->conexionBaseDatos->Execute($cadenasql);
		if ($data===false)
		{
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
    }
    
	public function insertar_dt_solicitud_anulada($codemp,$numrecdoc,$numrecdocnew,$codpro,$cedbene,$codtipdoc,$fecha)
	{
    	// OBTENER CARGOS
		$data=$this->buscar_dt_solicitudes($codemp,$numrecdoc,$codpro,$cedbene,$codtipdoc);
		while(!$data->EOF){
			//obteniendo las instacias de los dao's
			$this->daoRegistroDtSolicitudes = FabricaDao::CrearDAO("N","cxp_dt_solicitudes");
			//seteando la data e iniciando transaccion de base de datos
			$this->daoRegistroDtSolicitudes->codemp=$codemp;
			$this->daoRegistroDtSolicitudes->numrecdoc=$numrecdocnew;
			$this->daoRegistroDtSolicitudes->numsol=$data->fields['numsol'];
			$this->daoRegistroDtSolicitudes->codtipdoc = $codtipdoc;
			$this->daoRegistroDtSolicitudes->cod_pro = $codpro;
			$this->daoRegistroDtSolicitudes->ced_bene = $cedbene;
			$this->daoRegistroDtSolicitudes->monto= number_format($data->fields['monto'],2,'.',''); 
	    	if(!$this->daoRegistroDtSolicitudes->incluir()){
	    		$this->mensaje .= ' CLASE->SPG METODO->insertar_dt_solicitud_anulada ERROR->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido=false;
			}
			$data->MoveNext();
		}
		return $this->valido;
    }
    
	public function buscar_dt_amortizaciones($codemp,$numrecdoc,$codpro,$cedbene,$codtipdoc){
    	$data='';
    	$cadenasql="SELECT codemp, numrecdoc, codtipdoc, ced_bene, cod_pro,codamo, cuenta, montotamo, monsal, monamo".
				"   FROM cxp_rd_amortizacion".
				"   WHERE codemp = '".$codemp."'".
				"     AND numrecdoc = '".$numrecdoc."'".
				"     AND cod_pro = '".$codpro."'".
				"     AND ced_bene = '".$cedben."'".
				"     AND codtipdoc = '".$codtipdoc."'";
   		$data = $this->conexionBaseDatos->Execute($cadenasql);
		if ($data===false)
		{
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
    }
    
	public function insertar_dt_amortizacion_anulada($codemp,$numrecdoc,$numrecdocnew,$codpro,$cedbene,$codtipdoc,$fecha)
	{
    	// OBTENER CARGOS
		$data=$this->buscar_dt_amortizaciones($codemp,$numrecdoc,$codpro,$cedbene,$codtipdoc);
		while(!$data->EOF){
			//obteniendo las instacias de los dao's
			$this->daoRegistroDtAmortizacion = FabricaDao::CrearDAO("N","cxp_rd_amortizacion");
			//seteando la data e iniciando transaccion de base de datos
			$this->daoRegistroDtAmortizacion->codemp=$codemp;
			$this->daoRegistroDtAmortizacion->numrecdoc=$numrecdocnew;
			$this->daoRegistroDtAmortizacion->codtipdoc = $codtipdoc;
			$this->daoRegistroDtAmortizacion->cod_pro = $codpro;
			$this->daoRegistroDtAmortizacion->ced_bene = $cedbene;
			$this->daoRegistroDtAmortizacion->codamo=$data->fields['codamo'];
			$this->daoRegistroDtAmortizacion->cuenta=$data->fields['cuenta'];
			$this->daoRegistroDtAmortizacion->monamo= number_format($data->fields['monamo'],2,'.',''); 
			$this->daoRegistroDtAmortizacion->monsal= number_format($data->fields['monsal'],2,'.','');
			$this->daoRegistroDtAmortizacion->montotamo= number_format($data->fields['montotamo'],2,'.','');
	    	if(!$this->daoRegistroDtAmortizacion->incluir()){
	    		$this->mensaje .= ' CLASE->SPG METODO->insertar_dt_amortizacion_anulada ERROR->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido=false;
			}
			$data->MoveNext();
		}
		return $this->valido;
    }
    
	public function buscar_dt_anticipo($codemp,$numrecdoc,$codpro,$cedbene,$codtipdoc){
    	$data='';
    	$cadenasql="SELECT codemp, numrecdoc, codtipdoc, ced_bene, cod_pro, codamo, monto".
				"   FROM cxp_dt_amortizacion".
				"   WHERE codemp = '".$codemp."'".
				"     AND numrecdoc = '".$numrecdoc."'".
				"     AND cod_pro = '".$codpro."'".
				"     AND ced_bene = '".$cedben."'".
				"     AND codtipdoc = '".$codtipdoc."'";
   		$data = $this->conexionBaseDatos->Execute($cadenasql);
		if ($data===false)
		{
			$this->mensaje .= '  ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
		}
		return $data;
    }
    
	public function insertar_dt_anticipo_anulada($codemp,$numrecdoc,$numrecdocnew,$codpro,$cedbene,$codtipdoc,$fecha)
	{
    	// OBTENER CARGOS
		$data=$this->buscar_dt_anticipo($codemp,$numrecdoc,$codpro,$cedbene,$codtipdoc);
		while(!$data->EOF){
			//obteniendo las instacias de los dao's
			$this->daoRegistroDtAnticipo = FabricaDao::CrearDAO("N","cxp_dt_amortizacion");
			//seteando la data e iniciando transaccion de base de datos
			$this->daoRegistroDtAnticipo->codemp=$codemp;
			$this->daoRegistroDtAnticipo->numrecdoc=$numrecdocnew;
			$this->daoRegistroDtAnticipo->codtipdoc = $codtipdoc;
			$this->daoRegistroDtAnticipo->cod_pro = $codpro;
			$this->daoRegistroDtAnticipo->ced_bene = $cedbene;
			$this->daoRegistroDtAnticipo->codamo=$data->fields['codamo'];
			$this->daoRegistroDtAnticipo->monto= number_format($data->fields['monto'],2,'.','');
	    	if(!$this->daoRegistroDtAnticipo->incluir()){
	    		$this->mensaje .= ' CLASE->SPG METODO->insertar_dt_anticipo_anulada ERROR->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido=false;
			}
			$data->MoveNext();
		}
		return $this->valido;
    }
    
    public function eliminar_detallesrecepcion($codemp,$numrecdoc,$codtipdoc,$cedbene,$codpro)
    {
   		$this->valido=true;
		$cadenaSQL="DELETE FROM cxp_rd_cargos ".
				"   WHERE codemp='".$codemp."' ".
				"	  AND numrecdoc='".$numrecdoc."' ".
				"	  AND codtipdoc='".$codtipdoc."' ".
				"	  AND cod_pro='".$codpro."' ".
				"	  AND ced_bene='".$cedbene."'";		  
    	$data = $this->conexionBaseDatos->Execute($cadenaSQL);
		if($data === false){
			$this->mensaje .= ' Error al eliminar en la tabla cxp_rd_cargos ->'.$this->conexionBaseDatos->ErrorMsg();
			$this->valido = false;
			return false;
		}
		unset($cadenaSQL);
		unset($data);
		if($this->valido)
		{
			$cadenaSQL="DELETE FROM cxp_rd_deducciones ".
					"   WHERE codemp='".$codemp."' ".
					"	  AND numrecdoc='".$numrecdoc."' ".
					"	  AND codtipdoc='".$codtipdoc."' ".
					"	  AND cod_pro='".$codpro."' ".
					"	  AND ced_bene='".$cedbene."'";		  
			$data = $this->conexionBaseDatos->Execute($cadenaSQL);
			if($data === false){
				$this->mensaje .= ' Error al eliminar en la tabla cxp_rd_deducciones ->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido = false;
				return false;
			}
		}
		unset($cadenaSQL);
		unset($data);
		if($this->valido)
		{
			$cadenaSQL="DELETE FROM cxp_rd_scg ".
					"   WHERE codemp='".$codemp."' ".
					"	  AND numrecdoc='".$numrecdoc."' ".
					"	  AND codtipdoc='".$codtipdoc."' ".
					"	  AND cod_pro='".$codpro."' ".
					"	  AND ced_bene='".$cedbene."'";		  
			$data = $this->conexionBaseDatos->Execute($cadenaSQL);
			if($data === false){
				$this->mensaje .= ' Error al eliminar en la tabla cxp_rd_scg ->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido = false;
				return false;
			}
		}
		unset($cadenaSQL);
		unset($data);
		if($this->valido)
		{
			$cadenaSQL="DELETE FROM cxp_rd_spg ".
					"   WHERE codemp='".$codemp."' ".
					"	  AND numrecdoc='".$numrecdoc."' ".
					"	  AND codtipdoc='".$codtipdoc."' ".
					"	  AND cod_pro='".$codpro."' ".
					"	  AND ced_bene='".$cedbene."'";		  
			$data = $this->conexionBaseDatos->Execute($cadenaSQL);
			if($data === false){
				$this->mensaje .= ' Error al eliminar en la tabla cxp_rd_spg ->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido = false;
				return false;
			}
		}
		unset($cadenaSQL);
		unset($data);
		if($this->valido)
		{
			$cadenaSQL="DELETE FROM cxp_dt_solicitudes ".
					"   WHERE codemp='".$codemp."' ".
					"	  AND numrecdoc='".$numrecdoc."' ".
					"	  AND codtipdoc='".$codtipdoc."' ".
					"	  AND cod_pro='".$codpro."' ".
					"	  AND ced_bene='".$cedbene."'";		  
			$data = $this->conexionBaseDatos->Execute($cadenaSQL);
			if($data === false){
				$this->mensaje .= ' Error al eliminar en la tabla cxp_dt_solicitudes ->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido = false;
				return false;
			}
		}
		unset($cadenaSQL);
		unset($data);
		if($this->valido)
		{
			$cadenaSQL="DELETE FROM cxp_historico_rd ".
					"   WHERE codemp='".$codemp."' ".
					"	  AND numrecdoc='".$numrecdoc."' ".
					"	  AND codtipdoc='".$codtipdoc."' ".
					"	  AND cod_pro='".$codpro."' ".
					"	  AND ced_bene='".$cedbene."'";		  
			$data = $this->conexionBaseDatos->Execute($cadenaSQL);
			if($data === false){
				$this->mensaje .= ' Error al eliminar en la tabla cxp_historico_rd ->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido = false;
				return false;
			}
		}
		unset($cadenaSQL);
		unset($data);
		if($this->valido)
		{
			$cadenaSQL="DELETE FROM cxp_rd_amortizacion ".
					"   WHERE codemp='".$codemp."' ".
					"     AND numrecdoc='".$numrecdoc."' ".
					"     AND codtipdoc='".$codtipdoc."' ".
					"     AND cod_pro='".$codpro."' ".
					"     AND ced_bene='".$cedbene."'";		  
			$data = $this->conexionBaseDatos->Execute($cadenaSQL);
			if($data === false){
				$this->mensaje .= ' Error al eliminar en la tabla cxp_rd_amortizacion ->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido = false;
				return false;
			}
		}
		unset($cadenaSQL);
		unset($data);
		if($this->valido)
		{
			$cadenaSQL="DELETE FROM cxp_dt_amortizacion ".
					"   WHERE codemp='".$codemp."' ".
					"	  AND numrecdoc='".$numrecdoc."' ".
					"	  AND codtipdoc='".$codtipdoc."' ".
					"	  AND cod_pro='".$codpro."' ".
					"	  AND ced_bene='".$cedbene."'";		  
			$data = $this->conexionBaseDatos->Execute($cadenaSQL);
			if($data === false){
				$this->mensaje .= ' Error al eliminar en la tabla cxp_dt_amortizacion ->'.$this->conexionBaseDatos->ErrorMsg();
				$this->valido = false;
				return false;
			}
		}
		unset($cadenaSQL);
		unset($data);
		return $this->valido;
    }
    
    public function eliminar($codemp,$numrecdoc,$fecregdoc,$codpro,$cedbene,$codtipdoc,$recepcion,$fecha)
    {
    	if($recepcion->numrecdoc)
		{
			if($recepcion->estprodoc!="R")
			{
				if($recepcion->estprodoc!="E")
				{
					$this->mensaje.=" La Recepcion de Documentos no se puede eliminar, Tiene Movimientos. ";           
					$this->valido=false;
				}
			}
			if($this->valido)
			{	
				$this->valido=$this->eliminar_detallesrecepcion($codemp,$numrecdoc,$codtipdoc,$cedbene,$codpro);
			}			
			if($this->valido)
			{	
				$cadenaSQL="DELETE FROM cxp_rd ".
						"   WHERE codemp='".$codemp."' ".
						"	  AND numrecdoc='".$numrecdoc."' ".
						"	  AND codtipdoc='".$codtipdoc."' ".
						"	  AND cod_pro='".$codpro."' ".
						" 	  AND ced_bene='".$cedbene."' ";	
				$data = $this->conexionBaseDatos->Execute($cadenaSQL);
				if($data === false){
					$this->mensaje .= ' Error al eliminar en la tabla cxp_rd ->'.$this->conexionBaseDatos->ErrorMsg();
					$this->valido = false;
				}	
			}
		}
		else
		{
			$this->mensaje.=" No se encontro la Recepcion de Documentos ";
			$this->valido=false;	
		}
		return $this->valido;
    }
}
?>