<?php
/**
 * @author Ing. Gerardo Cordero
 * @desc Interfaz del servicio plan de cuneta institucional , 
 * 		 este tiene la finalidad de describir de manera abstracta los metodos que 
 * 		 definen el comportamiento del servicio.
 */
interface IValidacionEstructura {
	
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo que obtiene todas las las estructuras presupuestarias a las cuales aplica validacion.
	 * @param array $dataEmpresa - arreglo con los datos de la empresa
	 * @return retorna resultset de Adodb con el grupo de cuentas perteneciente a las estructura indicada.
	 */
	public function buscarEstructurasValidacion($dataEmpresa);
	
	/**
	 * @author Ing. Gerardo Cordero
	 * @desc Metodo que guarda la configuracion de las estructuras a las cuales aplica validacion para la 
	 *       disponibilidad.
	 * @param string $codemp    - codigo de la empresa
	 * @param json   $arrjson   - objeto json con los parametros captados en la vista para realizar la operacion.
	 * @param array  $arrEvento - arreglo con los datos para el log de seguridad
	 * @return retorna true si la configuracion fue guardada.
	 */
	public function grabarEstructurasValidar($codemp, $arrjson);
	
		
}

?>