<?php
require_once ("../../base/librerias/php/general/sigesp_lib_daogenerico.php");

class servicioPlanCuentaPatrimonial extends DaoGenerico
{
	
	public function __construct()
	{
		parent::__construct ( 'sigesp_plan_unico' );
	}
	
	public function guardarCuenta($arrjson)
	{
		$this->setData($arrjson);
		DaoGenerico::iniciarTrans();
		if(!$this->incluir())
		{
			return false;
		}
		if (DaoGenerico::completarTrans())
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	
	public function modificarCuenta($arrjson)
	{
		$this->setData($arrjson);
		DaoGenerico::iniciarTrans();
		if(!$this->modificar())
		{
			return false;
		}
		if (DaoGenerico::completarTrans())
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	
	public function eliminarCuenta($arrjson, $arrevento, $codemp, $formatoplan)
	{
		$respuesta = '1';
		$this->setData($arrjson);
		if($this->validarRelacionCuenta($codemp, $arrjson->sc_cuenta, $formatoplan))
		{
			$respuesta = '-9';
		}
		else
		{
			DaoGenerico::iniciarTrans();
			if (!$this->eliminar())
			{
				$resultado = '0';
			}
			if (DaoGenerico::completarTrans())
			{
				$respuesta = '1';
			}
			else
			{
				$respuesta = 0;
			}
		}
		return $respuesta;
	}
	
	public function validarRelacionCuenta($codemp, $cuenta, $formatoplan)
	{
		$valido   = false;
		$formato  = str_replace( "-", "",$formatoplan);
		$longitud = strlen($formato);
		
		$cadenaSql = "SELECT sc_cuenta ".
  					 "  FROM scg_cuentas ".
					 " WHERE codemp = '{$codemp}' ".
					 "   AND substr(sc_cuenta,1,{$longitud})='{$cuenta}'";
		$data = $this->buscarSql( $cadenaSql );
		if ($data->_numOfRows > 0)
		{
			$valido = true;
		}
		return $valido;		
	}
	
	public function buscarCuenta($cuenta, $denominacion)
	{
		$cadenaSql = "SELECT sc_cuenta, denominacion ".
  					 "	FROM sigesp_plan_unico ".
					 " WHERE sc_cuenta like '{$cuenta}%' ".
					 "   AND denominacion like '%{$denominacion}%' ".
					 " ORDER BY sc_cuenta";
		return $this->buscarSql( $cadenaSql );
	}
	
	public function buscarCuentaP21($p21, $denp21)
	{
		$cadenaSql = "SELECT p21, denp21 ".
  					 "	FROM scg_pub21 ".
					 " WHERE p21 like '{$p21}%' ".
					 "   AND denp21 like '%{$denp21}%' ".
					 " ORDER BY p21";
		return $this->buscarSql( $cadenaSql );
	}
	
	public function leerTodos($campoorden="",$tipoorden=0)
	{
		$cadena="";
		if($campoorden != "")
		{
			$cadena = " order by ".$campoorden;
			switch($tipoorden)
			{
				case 1: $cadena = $cadena." ASC";
						break;
						
				case 2: $cadena = $cadena." DESC";
						break;
						
				default: $cadena = $cadena." ASC";
			}
		}
		return $this->buscarSql("select * from {$this->_table} ".$cadena);
	}
}
?>
