<?php
/*****************************************************************************
* @Modelo para las funciones de cuenta de banco.
* @fecha de creacion: 01/10/2008.
* @autor: Ing.Gusmary Balza
****************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
*****************************************************************************/
require_once($_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION["sigesp_sitioweb"].'/base/librerias/php/general/sigesp_lib_conexion.php');
require_once($_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION["sigesp_sitioweb"].'/modelo/sss/sigesp_dao_sss_registroeventos.php');
require_once($_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION["sigesp_sitioweb"].'/modelo/sss/sigesp_dao_sss_registrofallas.php');

class CuentaBanco extends DaoGenerico
{
	var $_table = 'scb_ctabanco';
	public $valido = true;
	public $seguridad = true;
	public $mensaje;
	public $codsis;
	public $nomfisico;
	public $criterio;	
	public $servidor;
	public $usuario;
	public $clave;
	public $basedatos;
	public $gestor;
	public $puerto;
	public $tipoconexionbd = 'DEFECTO';
	
	/**
	 * @desc Metodo constructor de la clase, hace uso del constructor de la clase padre
	 * 		 para convertirse en un objeto active record del adodb
	 * @author Ing. Gerardo Cordero
	 */
	public function __construct() {
		parent::__construct ( 'scb_ctabanco' );
		$this->conexionbd = $this->obtenerConexionBd(); 
		$this->objlibcon = new ConexionBaseDatos();
	}

/***********************************************************************************
 * @Funcion para seleccionar con que conexion a Base de Datos se va a trabajar
 * @parametros:
 * @retorno:
 * @fecha de creacion: 06/11/2008.
 * @autor: Ing. Yesenia Moreno de Lang
 ************************************************************************************
 * @fecha modificacion:
 * @descripcion:
 * @autor:
 ***********************************************************************************/
	public function seleccionarConexion()
	{
		if ($this->tipoconexionbd != 'DEFECTO')
		{
			$this->conexionbd = $this->objlibcon->conectarBD($this->servidor, $this->usuario, $this->clave, $this->basedatos, $this->gestor, $this->puerto);
		}
	}
	
		
/***********************************************************************************
* @Funcion para insertar un tipo de cuenta.
* @parametros: 
* @retorno:
* @fecha de creacion: 01/10/2008.
* @autor: Ing.Gusmary Balza
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/			
	function incluir()
	{
		$this->mensaje = 'Incluyo la Cuenta de Banco '.$this->ctaban.' asociada al Banco'.$this->codban;
		$this->conexionbd->StartTrans();
		try 
		{ 
			$this->save();
		}	
		catch (exception $e) 
	   	{
			$this->valido  = false;				
			$this->mensaje='Error al Incluir la Cuenta de Banco '.$this->ctaban.' '.$this->conexionbd->ErrorMsg();
		} 
		$this->conexionbd->CompleteTrans();
		$this->incluirSeguridad('INSERTAR',$this->valido);
	}
	
	
/***********************************************************************************
* @Funcion que Busca cuentas de banco.
* @parametros: 
* @retorno:
* @fecha de creacion: 04/12/2008
* @autor: Ing. Gusmary Balza
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
************************************************************************************/		
	public function leer() 
 	{	
 		$this->seleccionarConexion(); 		
 		try
		{	
			$consulta = "SELECT {$this->_table}.*,1 as valido ".
						"  FROM {$this->_table} ".
						" WHERE codemp='{$this->codemp}'";
			$cadena=" ";
            $total = count($this->criterio);
            for ($contador = 0; $contador < $total; $contador++)
			{
            	$cadena.= $this->criterio[$contador]['operador']." ".$this->criterio[$contador]['criterio']." ".
 			               $this->criterio[$contador]['condicion']." ".$this->criterio[$contador]['valor']." ";
            }
            $consulta.= $cadena;
            $consulta.= " ORDER BY ctaban ";
           	$result = $this->conexionbd->Execute($consulta);
		 	return $result;
		}
		catch (exception $e) 
		{ 
			$this->valido  = false;	
			$this->mensaje='Error al consultar el Banco '.$consulta.' '.$this->conexionbd->ErrorMsg();
			$this->incluirSeguridad('CONSULTAR',$this->valido);
	   	} 
 	}

/***********************************************************************************
* @Funcion que Busca cuentas de banco.
* @parametros: 
* @retorno:
* @fecha de creacion: 04/12/2008
* @autor: Ing. Gusmary Balza
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
************************************************************************************/		
	public function leerCuentaBanco() 
 	{	
 		$this->seleccionarConexion(); 		
 		try
		{	
			$consulta = "SELECT {$this->_table}.*,scb_banco.nomban, 1 as valido ".
						"  FROM {$this->_table}, scb_banco ".
						" WHERE {$this->_table}.codemp='{$this->codemp}' ".
						"   AND {$this->_table}.codemp = scb_banco.codemp ".
						"   AND {$this->_table}.codban = scb_banco.codban ";
			$cadena=" ";
            $total = count($this->criterio);
            for ($contador = 0; $contador < $total; $contador++)
			{
            	$cadena.= $this->criterio[$contador]['operador']." ".$this->criterio[$contador]['criterio']." ".
 			               $this->criterio[$contador]['condicion']." ".$this->criterio[$contador]['valor']." ";
            }
            $consulta.= $cadena;
            $consulta.= " ORDER BY ctaban ";
           	$result = $this->conexionbd->Execute($consulta);
		 	return $result;
		}
		catch (exception $e) 
		{ 
			$this->valido  = false;	
			$this->mensaje='Error al consultar el Banco '.$consulta.' '.$this->conexionbd->ErrorMsg();
			$this->incluirSeguridad('CONSULTAR',$this->valido);
	   	} 
 	}	
	
/***********************************************************************************
* @Funcion que Incluye el registro de la transaccion exitosa
* @parametros: $evento
* @retorno:
* @fecha de creacion: 10/10/2008
* @autor: Ing. Yesenia Moreno de Lang
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
************************************************************************************/
	function incluirSeguridad($evento,$tipotransaccion)
	{
		if($tipotransaccion) // Transaccion Exitosa
		{
			$objEvento = new RegistroEventos();
		}
		else // Transaccion fallida
		{
			$objEvento = new RegistroFallas();
		}
		// Registro del Evento
		$objEvento->codemp = $this->codemp;
		$objEvento->codsis = $this->codsis;
		$objEvento->nomfisico = $this->nomfisico;
		$objEvento->evento = $evento;
		$objEvento->desevetra = $this->mensaje;
		$objEvento->incluir();
		unset($objEvento);
	}	
}	
?>