<?php
/*****************************************************************************
* @Modelo para las funciones de solicitudes de cuentas por pagar.
* @fecha de creacion: 27/11/2008.
* @autor: Ing.Gusmary Balza
*****************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
******************************************************************************/
require_once($_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION["sigesp_sitioweb"].'/base/librerias/php/general/sigesp_lib_conexion.php');
require_once($_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION["sigesp_sitioweb"].'/modelo/sss/sigesp_dao_sss_registroeventos.php');
require_once($_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION["sigesp_sitioweb"].'/modelo/sss/sigesp_dao_sss_registrofallas.php');

class Solicitud extends DaoGenerico
{
	var $_table = 'cxp_solicitudes';
	public $valido = true;
	public $mensaje;
	public $seguridad = true;
	public $codsis;
	public $nomfisico;
	public $criterio;
	public $estatus;
	public $servidor;
	public $usuario;
	public $clave;
	public $basedatos;
	public $gestor;
	public $puerto;
	public $tipoconexionbd = 'DEFECTO';

	/**
	 * @desc Metodo constructor de la clase, hace uso del constructor de la clase padre
	 * 		 para convertirse en un objeto active record del adodb
	 * @author Ing. Gerardo Cordero
	 */
	public function __construct() {
		parent::__construct ( 'cxp_solicitudes' );
		$this->conexionbd = $this->obtenerConexionBd(); 
		$this->objlibcon = new ConexionBaseDatos();
	}
	
/***********************************************************************************
* @Funcion para seleccionar con que conexion a Base de Datos se va a trabajar
* @parametros: 
* @retorno:
* @fecha de creacion: 06/11/2008.
* @autor: Ing. Yesenia Moreno de Lang
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/			
	public function seleccionarConexion($conexionbd)
	{
		global $conexionbd;
		
		if ($this->tipoconexionbd != 'DEFECTO')
		{
			$conexionbd = $this->objlibcon->conectarBD($this->servidor, $this->usuario, $this->clave, $this->basedatos, $this->gestor, $this->puerto);
		}
	}	
	
	
/***********************************************************************************
* @Funcion que Busca uno o todas las solicitudes
* @parametros: 
* @retorno:
* @fecha de creacion: 27/11/2008
* @autor: Ing. Gusmary Balza
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
************************************************************************************/		
	public function leer() 
 	{	
 		global $conexionbd; 		
		$this->seleccionarConexion($conexionbd);			
		if ($this->estatus===C)
		{				
			$consulta = " SELECT 0 as marcado,numsol, fecemisol, consol, monsol, 	".
						" 0.00 as pagado,1 as valido 							 	".
						" FROM {$this->_table} 										".
						" WHERE codemp='{$this->codemp}'							";
		}
		else
		{					
			$consulta = " SELECT 0 as marcado,numsol, fecemisol, consol, monsol,1 as valido, 	".
						" 	(SELECT COALESCE(SUM(cxp_sol_banco.monto), 0.00)       			    ".
						"		FROM cxp_sol_banco 												".
						"		WHERE cxp_sol_banco.numsol=cxp_solicitudes.numsol 				".
						"		AND cxp_sol_banco.estmov<>'A' 									".
						"		AND cxp_sol_banco.estmov<>'O') as Pagado 						".
						" FROM {$this->_table} 													".
						" WHERE codemp='{$this->codemp}'										".
						" AND monsol>(SELECT COALESCE(SUM(cxp_sol_banco.monto), 0.00) as pagado 			".
						"		FROM cxp_sol_banco 												".
						"		WHERE cxp_sol_banco.numsol=cxp_solicitudes.numsol 				".
						"		AND cxp_sol_banco.estmov<>'A' 									".
						"		AND cxp_sol_banco.estmov<>'O')";
		}				
		$cadena=" ";
        $total = count($this->criterio);
        for ($contador = 0; $contador < $total; $contador++)
		{
            $cadena.= $this->criterio[$contador]['operador']." ".$this->criterio[$contador]['criterio']." ".
 		               $this->criterio[$contador]['condicion']." ".$this->criterio[$contador]['valor']." ";
        }
        $consulta.= $cadena;            
        $consulta.= " ORDER BY numsol";
        $result = $conexionbd->Execute($consulta);           	  
		return $result;
 	}

 	
	
/***********************************************************************************
* @Funcion que Incluye el registro de la transaccion exitosa
* @parametros: $evento
* @retorno:
* @fecha de creacion: 10/10/2008
* @autor: Ing. Yesenia Moreno de Lang
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/
	function incluirSeguridad($evento,$tipotransaccion)
	{
		if($tipotransaccion) // Transaccion Exitosa
		{
			$objEvento = new RegistroEventos();
		}
		else // Transaccion fallida
		{
			$objEvento = new RegistroFallas();
		}
		// Registro del Evento
		$objEvento->codemp = $this->codemp;
		$objEvento->codsis = $this->codsis;
		$objEvento->nomfisico = $this->nomfisico;
		$objEvento->evento = $evento;
		$objEvento->desevetra = $this->mensaje;
		$objEvento->incluir();
		unset($objEvento);
	}
}	
?>