<?php
require_once ("../../base/librerias/php/general/sigesp_lib_daogenerico.php");

class ServicioSpi {
	private $daogenerico;
	
	public function ServicioSpi($tabla) {
		$this->daogenerico = new DaoGenerico ( $tabla );
	}
	
	public function getCodemp() {
		return $this->daogenerico->codemp;
	}
	
	public function setCodemp($codemp) {
		
		$this->daogenerico->codemp = $codemp;
	}
	
	/***********************************/
	/* Metodos Estandar DAO Generico   */
	/***********************************/
	
	public static function iniTransaccion() {
		DaoGenerico::iniciarTrans ();
	}
	
	public static function comTransaccion() {
		return DaoGenerico::completarTrans ();
	}
	
	public function incluirDto($dto) {
		
		$this->pasarDatos ( $dto );
		$this->daogenerico->incluir ();
	}
	
	public function modificarDto($dto) {
		
		$this->pasarDatos ( $dto );
		$this->daogenerico->modificar ();
	}
	
	public function eliminarDto($dto) {
		
		$this->pasarDatos ( $dto );
		$this->daogenerico->eliminar ();
	}
	
	function pasarDatos($ObJson) {
		$arratributos = $this->daogenerico->getAttributeNames();
		foreach ( $arratributos as $IndiceDAO ) {
			foreach ( $ObJson as $IndiceJson => $valorJson ) {
				if ($IndiceJson == $IndiceDAO && $IndiceJson != "codemp") {
					$this->daogenerico->$IndiceJson = utf8_decode ( $valorJson );
				} else {
					$GLOBALS [$IndiceJson] = $valorJson;
				}
			}
		}
	}
	
	public function buscarTodos() {
		
		return $this->daogenerico->leerTodos ();
	}
	
	public function buscarCampo($campo, $valor) {
		
		return $this->daogenerico->buscarCampo ( $campo, $valor );
	}
	
	public function buscarCampoRestriccion($restricciones)  {
		
		return $this->daogenerico->buscarCampoRestriccion($restricciones) ;
	}
	
	public function buscarSql($cadenasql)  {
		
		return $this->daogenerico->buscarSql($cadenasql) ;
	}
	/***************************************/
	/* Fin Metodos Estandar DAO Generico   */
	/***************************************/
	
	/***************************************/
	/* Metodos Asociados al Servicio       */
	/***************************************/
	public function buscarCuentasSPI($codemp,$spi_cuenta,$denominacion){
		$cadenasql = "SELECT spi_cuentas.spi_cuenta as spi_cuenta, 
                             spi_cuentas.denominacion
					  FROM 	spi_cuentas
					  WHERE spi_cuentas.codemp='{$codemp}' 
						AND spi_cuentas.spi_cuenta like '%{$spi_cuenta}%' 
						AND spi_cuentas.denominacion like '%{$denominacion}%' 
						AND spi_cuentas.status = 'C'
					  ORDER BY spi_cuentas.spi_cuenta ASC";
		return $this->daogenerico->buscarSql($cadenasql);
	}
	
	public function buscarCuentasEstSpi($codest1,$codest2,$codest3,$codest4,$codest5,$estcla){
		$cadenasql = "SELECT spi_cuentas_estructuras.spi_cuenta as sig_cuenta, 
                             spi_cuentas.denominacion
					  FROM spi_cuentas_estructuras,spi_cuentas
					  WHERE spi_cuentas.codemp = '".$this->daogenerico->codemp."' AND 
					  		spi_cuentas.codemp = spi_cuentas_estructuras.codemp AND
  							spi_cuentas.spi_cuenta = spi_cuentas_estructuras.spi_cuenta AND
  							spi_cuentas_estructuras.codestpro1 ='".$codest1."'  AND 
  							spi_cuentas_estructuras.codestpro2 ='".$codest2."'  AND 
  							spi_cuentas_estructuras.codestpro3 ='".$codest3."'  AND 
  							spi_cuentas_estructuras.codestpro4 ='".$codest4."'  AND 
  							spi_cuentas_estructuras.codestpro5 ='".$codest5."'  AND
							spi_cuentas_estructuras.estcla ='".$estcla."'
						ORDER BY  spi_cuentas_estructuras.spi_cuenta ASC";
		return $this->daogenerico->buscarSql($cadenasql);
	}
	/***************************************/
	/* Fin Metodos Asociados al Servicio   */
	/***************************************/	

}

?>