<?php
session_start();
/**
 * @author Ing. Gerardo Cordero
 * @desc   Controlador para el manejo del registro de solicitudes de cotizacion
 */

require_once('../../base/librerias/php/general/sigesp_lib_funciones.php');
$sessionvalida = validarSession();
if (($_POST['ObjSon']) && ($sessionvalida)) {	
	$dirsrv = $_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION['sigesp_sitioweb'];
	require_once ($dirsrv.'/base/librerias/php/general/Json.php');
	require_once ($dirsrv.'/modelo/servicio/soc/sigesp_srv_soc_comun.php');
	require_once ($dirsrv.'/modelo/servicio/soc/sigesp_srv_soc_solicitud_cotizacion.php');
	require_once ($dirsrv.'/modelo/servicio/mis/sigesp_srv_mis_integracionsno.php');
	
	$_SESSION['session_activa']=time();
    $submit = str_replace('\\', '', $_POST['ObjSon']);
    $json = new Services_JSON;
    $objetoJson = $json->decode($submit);
    
    switch ($objetoJson->operacion) {
    
    	case 'buscarNumero':
    		$servicioSolicitudCotizacion = new ServicioSolicitudCotizacion();
    		echo $servicioSolicitudCotizacion->buscarNumeroCotizacion($_SESSION['la_empresa']['codemp']);
    		unset($servicioSolicitudCotizacion);
    		break;
    	
    	case 'buscarPersonal':
    		$servicioSolicitudCotizacion = new ServicioSolicitudCotizacion();
    		$dataPersonal = $servicioSolicitudCotizacion->buscarPersonal($_SESSION['la_empresa']['codemp'], $objetoJson->ced_per, $objetoJson->nom_per, $objetoJson->ape_per);
    		echo generarJson($dataPersonal);
    		unset($servicioSolicitudCotizacion);
    		unset($dataPersonal);
    		break;
    		
    	case 'buscarTipoArticulo':
    		$servicioComunSOC = new ServicioComunSOC();
    		$dataTipoArticulo = $servicioComunSOC->buscarTipoArticulo();
    		echo generarJson($dataTipoArticulo);
    		unset($servicioComunSOC);
    		unset($dataTipoArticulo);
    		break;
    		
    	case 'buscar_bienes':
    		$servicioComunSOC = new ServicioComunSOC();
    		$dataBienes = $servicioComunSOC->buscarBienes($_SESSION['la_empresa']['codemp'], $objetoJson->origenCat, $objetoJson->codart, $objetoJson->denart, $objetoJson->codtipart, $objetoJson->tipobien, $objetoJson->codestpro1, $objetoJson->codestpro2, $objetoJson->codestpro3, $objetoJson->codestpro4, $objetoJson->codestpro5, $objetoJson->estcla);
    		if($dataBienes !== false){
    			echo generarJson($dataBienes);
    		}
    		else {
    			echo '0';
    		}
    		unset($servicioComunSOC);
    		unset($dataBienes);
    		break;
    	
    	case 'buscar_servicios':
    		$servicioComunSOC = new ServicioComunSOC();
    		$dataServicios = $servicioComunSOC->buscarServicios($_SESSION['la_empresa']['codemp'], $objetoJson->origenCat, $objetoJson->codser, $objetoJson->denser, $objetoJson->codestpro1, $objetoJson->codestpro2, $objetoJson->codestpro3, $objetoJson->codestpro4, $objetoJson->codestpro5, $objetoJson->estcla);
    		echo generarJson($dataServicios);
    		unset($servicioComunSOC);
    		unset($dataServicios);
    		break;
    		
    	case 'buscar_solcot':
    		$servicio = new ServicioSolicitudCotizacion();
    		$dataSolCot = $servicio->buscarSolCot($_SESSION['la_empresa']['codemp'], $objetoJson->numsolcot, $objetoJson->tipsolcot, 
    											  $objetoJson->codpro, $objetoJson->fecdes, $objetoJson->fechas,$objetoJson->obssol,
    											  $objetoJson->estcot,$objetoJson->cedper,$objetoJson->codcar,$objetoJson->soltel,
    											  $objetoJson->solfax,$objetoJson->coduniadm,$objetoJson->codfuefin,$objetoJson->consolcot,
    											  $objetoJson->uniejeaso,$objetoJson->tipsolbie,$objetoJson->origenCat);
    		echo generarJson($dataSolCot);
    		unset($servicio);
    		unset($dataSolCot);
    		break;
    		
    	case 'cargarBienesServicios':
    		$servicioBieSer = new ServicioSolicitudCotizacion();
    		$dataBieSer = $servicioBieSer->cargarBieSerSolCot($_SESSION['la_empresa']['codemp'], $objetoJson->numsolcot, $objetoJson->tipsolcot, $objetoJson->codpro);
    		echo generarJson($dataBieSer);
    		unset($servicioBieSer);
    		unset($dataBieSer);
    		break;
    		
    	case 'cargarProveedores':
    		$servicioPro = new ServicioSolicitudCotizacion();
    		$dataPro = $servicioPro->cargarProSolCot($_SESSION['la_empresa']['codemp'],$objetoJson->numsolcot,$objetoJson->tipsolcot,$objetoJson->codpro,$objetoJson->nompro);
    		echo generarJson($dataPro);
    		unset($servicioPro);
    		unset($dataPro);
    		break;
    	
    	case 'cargarSEP':
    		$servicioSep = new ServicioSolicitudCotizacion();
    		$dataSep = $servicioSep->cargarSepSolCot($_SESSION['la_empresa']['codemp'],$objetoJson->numsolcot);
    		echo generarJson($dataSep);
    		unset($servicioSep);
    		unset($dataSep);
    		break;
    		
    	case "buscarUltimoNumero":
    		$servicioSolicitud = new ServicioSolicitudCotizacion();
    		echo $servicioSolicitud->buscarUltimaSolicitud($_SESSION['la_empresa']['codemp']);
			unset($servicioSolicitud);
    		break;
    		
    	case "validarFecha":
    		$servicioSolicitud = new ServicioSolicitudCotizacion();
    		echo $servicioSolicitud->ValidarFecha($_SESSION['la_empresa']['codemp']);
			unset($servicioSolicitud);
    		break;
    		
    	case 'select_config':
    		$Serviciosobcon = new ServicioIntegracionSNO();
    		echo $Serviciosobcon->SelectConfig($objetoJson->sistema,$objetoJson->seccion,$objetoJson->variable,$objetoJson->valor,$objetoJson->tipo,"");
    		unset($Serviciosobcon);
    		break;
    		
    	case 'incluir':
    		$servicioSolCot = new ServicioSolicitudCotizacion();
    		$arrevento ['codemp']  = $_SESSION['la_empresa']['codemp'];
			$arrevento ['codusu']  = $_SESSION['la_logusr'];
			$arrevento ['codmenu'] = $objetoJson->codmenu;
			$arrevento ['codsis']  = 'SOC';
			$arrevento ['evento']  = 'INSERT';
			$arrevento ['nomven']  = 'sigesp_vis_soc_solicitud_cotizacion.html';
			$arrevento ['desevetra'] = 'Inserto la solicitud de cotizacion con el numero'.$objetoJson->numsolcot.', asociado a la empresa '.$_SESSION['la_empresa']['codemp'];
			echo $servicioSolCot->guardarSolCot($_SESSION['la_empresa']['codemp'],$objetoJson,$arrevento);
    		unset($servicioSolCot);
    		break;
    		
    	case 'actualizar':
    		$servicioSolCot = new ServicioSolicitudCotizacion();
    		$arrevento ['codemp']  = $_SESSION['la_empresa']['codemp'];
			$arrevento ['codusu']  = $_SESSION['la_logusr'];
			$arrevento ['codmenu'] = $objetoJson->codmenu;
			$arrevento ['codsis']  = 'SOC';
			$arrevento ['evento']  = 'UPDATE';
			$arrevento ['nomven']  = 'sigesp_vis_soc_solicitud_cotizacion.html';
			$arrevento ['desevetra'] = 'Modifico la solicitud de cotizacion con el numero'.$objetoJson->numsolcot.', asociado a la empresa '.$_SESSION['la_empresa']['codemp'];
    		$resultado = $servicioSolCot->modificarSolCot($_SESSION['la_empresa']['codemp'],$objetoJson,$arrevento);
    		if ($resultado === 1) {
    			echo "1";
    		}
    		else{
    			echo "0";
    		}
    		unset($servicioSolCot);
    		break;
    	
    	case 'eliminar':
    		$servicioSolCot = new ServicioSolicitudCotizacion();
    		$arrevento ['codemp']  = $_SESSION['la_empresa']['codemp'];
			$arrevento ['codusu']  = $_SESSION['la_logusr'];
			$arrevento ['codmenu'] = $objetoJson->codmenu;
			$arrevento ['codsis']  = 'SOC';
			$arrevento ['evento']  = 'DELETE';
			$arrevento ['nomven']  = 'sigesp_vis_soc_solicitud_cotizacion.html';
			$arrevento ['desevetra'] = 'Elimino la solicitud de cotizacion con el numero'.$objetoJson->numsolcot.', asociado a la empresa '.$_SESSION['la_empresa']['codemp'];
    		$resultado = $servicioSolCot->eliminarSolCot($_SESSION['la_empresa']['codemp'],$objetoJson,$arrevento);
    		if ($resultado === 1) {
    			echo "1";
    		}
    		else{
    			echo "0";
    		}
    		unset($servicioSolCot);
    		break;

	}
}
?>