<?php
session_start();
/**
 *  @author Ing. Maryoly Caceres
 *  @desc Controlador para el manejo del registro de cotizaciones
 **/

require_once('../../base/librerias/php/general/sigesp_lib_funciones.php');
$sessionvalida = validarSession();
if (($_POST['ObjSon']) && ($sessionvalida)) {	
	$dirsrv = $_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION['sigesp_sitioweb'];
	require_once ($dirsrv.'/base/librerias/php/general/Json.php');
	require_once ($dirsrv.'/modelo/servicio/soc/sigesp_srv_soc_comun.php');
	require_once ($dirsrv.'/modelo/servicio/soc/sigesp_srv_soc_registro_cotizacion.php');
	require_once ($dirsrv.'/modelo/servicio/soc/sigesp_srv_soc_solicitud_cotizacion.php');
	require_once ($dirsrv.'/modelo/servicio/mis/sigesp_srv_mis_integracionsno.php');
	
	$_SESSION['session_activa']=time();
    $submit = str_replace('\\', '', $_POST['ObjSon']);
    $json = new Services_JSON;
    $objetoJson = $json->decode($submit);
    
    switch ($objetoJson->operacion) {
    
    	case 'buscarNumero':
    		$servicioRegistroCotizacion = new ServicioRegistroCotizacion();
    		echo $servicioRegistroCotizacion->buscarNumeroCotizacion($_SESSION['la_empresa']['codemp']);
    		unset($servicioRegistroCotizacion);
    		break;
    		
    	case 'cargarProveedores':
    		$servicioPro = new ServicioSolicitudCotizacion();
    		$dataPro = $servicioPro->cargarProSolCot($_SESSION['la_empresa']['codemp'],$objetoJson->numsolcot,$objetoJson->tipsolcot,$objetoJson->codpro,$objetoJson->nompro);
    		echo generarJson($dataPro);
    		unset($servicioPro);
    		unset($dataPro);
    		break;
    		
    	case 'select_config':
    		$Serviciosobcon = new ServicioIntegracionSNO();
    		echo $Serviciosobcon->SelectConfig($objetoJson->sistema,$objetoJson->seccion,$objetoJson->variable,$objetoJson->valor,$objetoJson->tipo,"");
    		unset($Serviciosobcon);
    		break;
    		
    	case "incluir":
    		$servicioCotizacion = new servicioRegistroCotizacion();
    		$arrevento ['codemp']  = $_SESSION['la_empresa']['codemp'];
			$arrevento ['codusu']  = $_SESSION["la_logusr"];
			$arrevento ['codmenu'] = $objetoJson->codmenu;
			$arrevento ['codsis']  = "SOC";
			$arrevento ['evento']  = "INSERT";
			$arrevento ['nomven']  = "sigesp_vis_soc_registro_cotizacion.html";
			$arrevento ['desevetra'] = "Inserto la Cotizacion con codigo ".$objetoJson->numcot.", asociado a la empresa ".$_SESSION['la_empresa']['codemp'];
			echo $servicioCotizacion->guardarCotizacion($_SESSION['la_empresa']['codemp'],$objetoJson,$arrevento);
    		unset($servicioCotizacion);
    		break;
    		
    	case 'actualizar':
    		$servicioCotizacion = new servicioRegistroCotizacion();
    		$arrevento ['codemp']  = $_SESSION['la_empresa']['codemp'];
			$arrevento ['codusu']  = $_SESSION["la_logusr"];
			$arrevento ['codmenu'] = $objetoJson->codmenu;
			$arrevento ['codsis']  = "SOC";
			$arrevento ['evento']  = "UPDATE";
			$arrevento ['nomven']  = "sigesp_vis_soc_registro_cotizacion.html";
			$arrevento ['desevetra'] = "Modifico la Cotizacion con codigo ".$objetoJson->numcot.", asociado a la empresa ".$_SESSION['la_empresa']['codemp'];
			$resultado = $servicioCotizacion->modificarCotizacion($_SESSION['la_empresa']['codemp'],$objetoJson,$arrevento);
    		if ($resultado === 1) {
    			echo "1";
    		}
    		else{
    			echo "0";
    		}
    		unset($servicioCotizacion);
    		break;
    	
    	case 'eliminar':
    		$servicioCotizacion = new servicioRegistroCotizacion();
    		$arrevento ['codemp']  = $_SESSION['la_empresa']['codemp'];
			$arrevento ['codusu']  = $_SESSION["la_logusr"];
			$arrevento ['codmenu'] = $objetoJson->codmenu;
			$arrevento ['codsis']  = "SOC";
			$arrevento ['evento']  = "DELETE";
			$arrevento ['nomven']  = "sigesp_vis_soc_registro_cotizacion.html";
			$arrevento ['desevetra'] = "Elimino la Cotizacion con codigo ".$objetoJson->numcot.", asociado a la empresa ".$_SESSION['la_empresa']['codemp'];
			$resultado = $servicioCotizacion->eliminarCotizacion($_SESSION['la_empresa']['codemp'],$objetoJson,$arrevento);
    		if ($resultado === 1) {
    			echo "1";
    		}
    		else{
    			echo "0";
    		}
    		unset($servicioCotizacion);
    		break;
    		
    	case 'cargarBienesServicios':
    		$servicioBieSer = new ServicioRegistroCotizacion();
    		$dataBieSer = $servicioBieSer->cargarBienesServicios($_SESSION['la_empresa']['codemp'], $objetoJson->numcot, $objetoJson->tipcot, $objetoJson->codpro);
    		echo generarJson($dataBieSer);
    		unset($servicioBieSer);
    		unset($dataBieSer);
    		break;
    		
    	case "buscarUltimoNumero":
    		$servicioCot = new ServicioRegistroCotizacion();
    		echo $servicioCot->buscarUltimaCotizacion($_SESSION['la_empresa']['codemp']);
			unset($servicioCot);
    		break;
    			
    	case "validarFecha":
    		$servicioCot = new ServicioRegistroCotizacion();
    		echo $servicioCot->ValidarFecha($_SESSION['la_empresa']['codemp']);
			unset($servicioCot);
    		break;
    		

    	case 'buscar_cotizaciones':
    		$servicioCot = new ServicioRegistroCotizacion();
    		$dataCot = $servicioCot->buscarCotizaciones($_SESSION['la_empresa']['codemp'],$objetoJson->numcot,$objetoJson->numsolcot,
    													$objetoJson->codpro,$objetoJson->tipbieser,$objetoJson->fecdes,$objetoJson->fechas,
    													$objetoJson->obscot,$objetoJson->estcot,$objetoJson->forpagcom,$objetoJson->daivalofe,
    													$objetoJson->estasitec,$objetoJson->estesp,$objetoJson->garanacot,$objetoJson->diaentcom,
    													$objetoJson->origenCat);
    		echo generarJson($dataCot);
    		unset($servicioCot);
    		unset($dataCot);
    		break;
    		
    	case 'cargar_formula_credito':
    		$servicioCot = new ServicioRegistroCotizacion();
    		$dataCot = $servicioCot->cargarFormulaCredito($_SESSION['la_empresa']['codemp'],$objetoJson->codigo, $objetoJson->tipo);
    		echo generarJson($dataCot);
    		unset($servicioCot);
    		unset($dataCot);
    		break;
	}
}
?>