<?php
session_start();
/**
 *  Ing. Maryoly Caceres
 *  Controlador para el manejo del analisis de cotizaciones
 **/

require_once('../../base/librerias/php/general/sigesp_lib_funciones.php');
$sessionvalida = validarSession();
if (($_POST['ObjSon']) && ($sessionvalida)) {	
	$dirsrv = $_SERVER['DOCUMENT_ROOT'].'/'.$_SESSION['sigesp_sitioweb'];
	require_once ($dirsrv.'/base/librerias/php/general/Json.php');
	require_once ($dirsrv.'/modelo/servicio/soc/sigesp_srv_soc_comun.php');
	require_once ($dirsrv.'/modelo/servicio/soc/sigesp_srv_soc_analisis_cotizacion.php');
	require_once ($dirsrv.'/modelo/servicio/mis/sigesp_srv_mis_integracionsno.php');
	
	$_SESSION['session_activa']=time();
    $submit = str_replace('\\', '', $_POST['ObjSon']);
    $json = new Services_JSON;
    $objetoJson = $json->decode($submit);
    
    switch ($objetoJson->operacion) {
    
    	case 'buscarNumero':
    		$servicioAnalisisCotizacion = new ServicioAnalisisCotizacion();
    		echo $servicioAnalisisCotizacion->buscarNumAnaCot($_SESSION['la_empresa']['codemp']);
    		unset($servicioAnalisisCotizacion);
    		break;
    		
    	case 'buscar_anacot':
    		$servicio = new ServicioAnalisisCotizacion();
    		$dataAnaCot = $servicio->buscarAnaCot($_SESSION['la_empresa']['codemp'],$objetoJson->numsolcot,$objetoJson->numanacot,
    											  $objetoJson->tipsolcot,$objetoJson->fecdes,$objetoJson->fechas,$objetoJson->origenCat, 
    											  $objetoJson->tipope,$objetoJson->codpro,$objetoJson->estana,$objetoJson->obsana,
    											  $objetoJson->fecapro,$objetoJson->recanacot,$objetoJson->estasitec,$objetoJson->estesp,
    											  $objetoJson->garanacot);
    		echo generarJson($dataAnaCot);
    		unset($servicio);
    		unset($dataAnaCot);
    		break;
    		
    	case 'buscar_analisis_precios':
    		$servicio = new ServicioAnalisisCotizacion();
    		$data = $servicio->buscarAnaPre($_SESSION['la_empresa']['codemp'],$objetoJson->numcot,$objetoJson->tipcot,$objetoJson->codpro);
    		echo generarJson($data);
    		unset($servicio);
    		unset($data);
    		break;
    		
    	case 'buscar_analisis_cualitativo_items':
    		$servicio = new ServicioAnalisisCotizacion();
    		$data = $servicio->buscarAnaCuaItems($_SESSION['la_empresa']['codemp'],$objetoJson->numcot,$objetoJson->tipcot,$objetoJson->codpro);
    		echo generarJson($data);
    		unset($servicio);
    		unset($data);
    		break;
    		
    	case 'buscar_analisis_cualitativo_cot':
    		$servicio = new ServicioAnalisisCotizacion();
    		$data = $servicio->buscarAnaCuaCot($_SESSION['la_empresa']['codemp'],$objetoJson->numcot,$objetoJson->codpro);
    		echo generarJson($data);
    		unset($servicio);
    		unset($data);
    		break;
    		
    	case "buscarUltimoNumero":
    		$servicio = new ServicioAnalisisCotizacion();
    		echo $servicio->buscarUltimoAnalisis($_SESSION['la_empresa']['codemp']);
			unset($servicio);
    		break;
    		
    	case "validarFecha":
    		$servicio = new ServicioAnalisisCotizacion();
    		echo $servicio->ValidarFecha($_SESSION['la_empresa']['codemp']);
			unset($servicio);
    		break;
    		
    	case 'select_config':
    		$Serviciosobcon = new ServicioIntegracionSNO();
    		echo $Serviciosobcon->SelectConfig($objetoJson->sistema,$objetoJson->seccion,$objetoJson->variable,$objetoJson->valor,$objetoJson->tipo,"");
    		unset($Serviciosobcon);
    		break;
    		
    	case 'incluir':
    		$servicioAnaCot = new ServicioAnalisisCotizacion();
    		$arrevento ['codemp']  = $_SESSION['la_empresa']['codemp'];
			$arrevento ['codusu']  = $_SESSION['la_logusr'];
			$arrevento ['codmenu'] = $objetoJson->codmenu;
			$arrevento ['codsis']  = 'SOC';
			$arrevento ['evento']  = 'INSERT';
			$arrevento ['nomven']  = 'sigesp_vis_soc_analisis_cotizacion.html';
			$arrevento ['desevetra'] = 'Inserto el analisis de cotizacion con el numero'.$objetoJson->numanacot.', asociado a la empresa '.$_SESSION['la_empresa']['codemp'];
			echo $servicioAnaCot->guardarAnaCot($_SESSION['la_empresa']['codemp'],$objetoJson,$arrevento);
    		unset($servicioAnaCot);
    		break;
    		
    	case 'actualizar':
    		$servicioAnaCot = new ServicioAnalisisCotizacion();
    		$arrevento ['codemp']  = $_SESSION['la_empresa']['codemp'];
			$arrevento ['codusu']  = $_SESSION['la_logusr'];
			$arrevento ['codmenu'] = $objetoJson->codmenu;
			$arrevento ['codsis']  = 'SOC';
			$arrevento ['evento']  = 'UPDATE';
			$arrevento ['nomven']  = 'sigesp_vis_soc_analisis_cotizacion.html';
			$arrevento ['desevetra'] = 'Modifico el analisis de cotizacion con el numero'.$objetoJson->numanacot.', asociado a la empresa '.$_SESSION['la_empresa']['codemp'];
    		$resultado = $servicioAnaCot->modificarAnaCot($_SESSION['la_empresa']['codemp'],$objetoJson,$arrevento);
    		if ($resultado === 1) {
    			echo "1";
    		}
    		else{
    			echo "0";
    		}
    		unset($servicioAnaCot);
    		break;
    	
    	case 'eliminar':
    		$servicioAnaCot = new ServicioAnalisisCotizacion();
    		$arrevento ['codemp']  = $_SESSION['la_empresa']['codemp'];
			$arrevento ['codusu']  = $_SESSION['la_logusr'];
			$arrevento ['codmenu'] = $objetoJson->codmenu;
			$arrevento ['codsis']  = 'SOC';
			$arrevento ['evento']  = 'DELETE';
			$arrevento ['nomven']  = 'sigesp_vis_soc_analisis_cotizacion.html';
			$arrevento ['desevetra'] = 'Elimino el analisis de cotizacion con el numero'.$objetoJson->numanacot.', asociado a la empresa '.$_SESSION['la_empresa']['codemp'];
    		$resultado = $servicioAnaCot->eliminarAnaCot($_SESSION['la_empresa']['codemp'],$objetoJson,$arrevento);
    		if ($resultado === 1) {
    			echo "1";
    		}
    		else{
    			echo "0";
    		}
    		unset($servicioAnaCot);
    		break;
    		
    	case 'cargar_cotizaciones':
    		$servicio = new ServicioAnalisisCotizacion();
    		$data = $servicio->cargarCotizaciones($_SESSION['la_empresa']['codemp'],$objetoJson->numanacot);
    		echo generarJson($data);
    		unset($servicio);
    		unset($data);
    		break;
    		
    	case 'cargar_bieser':
    		$servicio = new ServicioAnalisisCotizacion();
    		$data = $servicio->cargarBienesServicios($_SESSION['la_empresa']['codemp'],$objetoJson->numanacot,$objetoJson->tipsolcot);
    		echo generarJson($data);
    		unset($servicio);
    		unset($data);
    		break;
    		
    	case 'cargarProveedores':
    		$servicioPro = new ServicioAnalisisCotizacion();
    		$dataPro = $servicioPro->cargarProveedores($_SESSION['la_empresa']['codemp'], $objetoJson->numsolcot,$objetoJson->tipo,$objetoJson->codigo);
    		echo generarJson($dataPro);
    		unset($servicioPro);
    		unset($dataPro); 
    		break;
    		
    	case 'buscar_den_clasificacion':
    		$servicio = new ServicioAnalisisCotizacion();
    		$data = $servicio->buscarDenClasificacion($_SESSION['la_empresa']['codemp']);
    		echo generarJson($data);
    		unset($servicio);
    		unset($data);
    		break;
    		
    	case 'buscar_niv_clasificacion':
    		$servicio = new ServicioAnalisisCotizacion();
    		$data = $servicio->buscarNivClasificacion($_SESSION['la_empresa']['codemp'],$objetoJson);
    		echo generarJson($data);
    		unset($servicio);
    		unset($data);
    		break;
	}
}
?>