<?php
/**
 * @author Ing. Gerardo Cordero
 * @desc   Controlador para el manejo de la vista del validador de webserver
 */

require_once('../../base/librerias/php/general/sigesp_lib_funciones.php');
if ($_POST['ObjSon']) {	
	require_once ('../../base/librerias/php/general/Json.php');
	
	$submit = str_replace('\\', '', $_POST['ObjSon']);
    $json = new Services_JSON;
    $objetoJson = $json->decode($submit);
    
    switch ($objetoJson->operacion) {
    
    	case 'validar':
    		$arrParametro = array();
    		
    		//parametro 0 - version del PHP
    		$parametro = '';
    		$estado = 0;
    		if (version_compare(PHP_VERSION, '5.1', '<')) {
    			$parametro = "Su version de PHP  ".PHP_VERSION." no es soportada por SIGESP";
    		}
    		else if (version_compare(PHP_VERSION, '5.4', '<')) {
    			$parametro = "Su version de PHP ".PHP_VERSION." es soportada por SIGESP";
    			$estado = 1;
    		}
    		else {
    			$parametro = "Su version de PHP ".PHP_VERSION." no es soportada por SIGESP";
    		}
    		$arrParametro[0]['codigo'] = "001";
    		$arrParametro[0]['parametro'] = $parametro;
    		$arrParametro[0]['estado'] = $estado;
    		
    		
    		//parametro 1 - php_ini (tiempo maximo de ejecucion)
    		$parametro = '';
    		$estado = 0;
    		if(ini_get('max_execution_time')!=0){
    			$parametro = 'Debe editar el php ini y colocar la variable max_execution_time=0';
    		}
    		else {
    			$parametro = 'La variable $max_execution_time fue correctamente configurada';
    			$estado = 1;
    		}
    		$arrParametro[1]['codigo'] = "002";
    		$arrParametro[1]['parametro'] = $parametro;
    		$arrParametro[1]['estado'] = $estado;
    		
    		//parametro 2 - php_ini (tiempo maximo par leer una entrada)
    		$parametro = '';
    		$estado = 0;
    		if(ini_get('max_input_time') < 1024){
    			$parametro = 'Debe editar el php ini y colocar la variable max_input_time=1024';
    		}
    		else {
    			$parametro = 'La variable max_input_time fue correctamente configurada';
    			$estado = 1;
    		}
    		$arrParametro[2]['codigo'] = "003";
    		$arrParametro[2]['parametro'] = $parametro;
    		$arrParametro[2]['estado'] = $estado;
    		
    		//parametro 3 - php_ini (limite de la memoria)
    		$parametro = '';
    		$estado = 0;
    		if(ini_get('memory_limit')+1 >= 2049){
    			$parametro = 'La variable memory_limit fue correctamente configurada';
    			$estado = 1;
    		}
    		else {
    			$parametro = 'Debe editar el php ini y colocar la variable memory_limit=2048M';
    		}
    		$arrParametro[3]['codigo'] = "004";
    		$arrParametro[3]['parametro'] = $parametro;
    		$arrParametro[3]['estado'] = $estado;
    		
    		//parametro 4 - php_ini (limite de variables)
    		$parametro = '';
    		$estado = 0;
    		if(ini_get('max_input_var') >= 20000){
    			$parametro = 'La variable max_input_var fue correctamente configurada';
    			$estado = 1;
    		}
    		else {
    			$parametro = 'Debe editar el php ini y colocar la variable max_input_var=20000';
    		}
    		$arrParametro[4]['codigo'] = "005";
    		$arrParametro[4]['parametro'] = $parametro;
    		$arrParametro[4]['estado'] = $estado;
    		
    		
    		// VALIDAR MODULOS CARGADOS
    		$arrExtensions = get_loaded_extensions();
    		
    		//parametro 5 - Modulo de Base de Datos 
    		$parametro = '';
    		$estado = 0;
    		$valorModulo = '';
    		$nombreModulo = '';
    		switch ($objetoJson->gestor) {
    			case 'M':
    				$valorModulo = 'mysql';
    				$nombreModulo = 'MySQL';
    				break;
    			case 'P':
    				$valorModulo = 'pgsql';
    				$nombreModulo = 'PostgreSQL';
    				break;
    			case 'O':
    				$valorModulo = '';
    				$nombreModulo = 'ORACLE';
    				break;
    		}
    		if(in_array($valorModulo, $arrExtensions)){
    			$parametro = "El modulo de conexion a {$nombreModulo} fue correctamente instalado";
    			$estado = 1;
    		}
    		else {
    			$parametro = "El modulo de conexion a {$nombreModulo} no fue correctamente instalado";
    		}
    		$arrParametro[5]['codigo'] = "006";
    		$arrParametro[5]['parametro'] = $parametro;
    		$arrParametro[5]['estado'] = $estado;
    		
    		echo generarJsonArreglo($arrParametro);
    		unset($arrParametro);
    		break;
    }
}
?>