<?php
class sigesp_spg_c_validacion_estructuras
{
	var $obj="";
	var $io_sql;
	var $siginc;
	var $con;
	function sigesp_spg_c_validacion_estructuras($as_path)
	{
		require_once($as_path."shared/class_folder/class_sql.php");
		require_once($as_path."shared/class_folder/class_datastore.php");
		require_once($as_path."shared/class_folder/class_mensajes.php");
		require_once($as_path."shared/class_folder/sigesp_include.php");
		require_once($as_path."shared/class_folder/sigesp_c_seguridad.php");
		require_once($as_path."shared/class_folder/class_funciones.php");
		require_once($as_path."shared/class_folder/grid_param.php");
		$this->io_msg=new class_mensajes();
		$this->ls_codemp=$_SESSION["la_empresa"]["codemp"];
		$this->ls_estmodest=$_SESSION["la_empresa"]["estmodest"];
		$in=new sigesp_include();
		$this->con=$in->uf_conectar();
		$this->io_sql=new class_sql($this->con);
		$this->seguridad= new sigesp_c_seguridad();
		$this->io_funciones = new class_funciones();
		$this->io_grid = new grid_param();
	}

   //-----------------------------------------------------------------------------------------------------------------------------------
	function uf_select_valor_config()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_select_valor_config
		//		   Access: public
		//	    Arguments: 
		//	      Returns: $ls_resultado variable buscado
		//	  Description: Funcion que obtiene una variable de la tabla config
		// Modificado por: Ing. Luis Anibal Lang
		// Fecha Creacion: 25/05/2012 	 Fecha ltima Modificacion :
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    $lb_valido=false;
		$ls_valor="";
		$ls_sql="SELECT nivvalest ".
	   		    "  FROM sigesp_empresa ".
			    " WHERE codemp='".$this->ls_codemp."'";
		$rs_data=$this->io_sql->select($ls_sql);
		if($rs_data===false)
		{
			$this->io_msg->message("CLASE->Validacion ->uf_select_config ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
			$lb_valido=false;
		}
		else
		{
			if($row=$this->io_sql->fetch_row($rs_data))
			{
				$li_valor=trim($row["nivvalest"]);
				$lb_valido=true; 
			}
			switch($li_valor)
			{
				case"N1":
					$ls_valor="Nivel 1";
				break;
				case"N2":
					$ls_valor="Nivel 2";
				break;
				case"N3":
					$ls_valor="Nivel 3";
				break;
				case"N4":
					$ls_valor="Nivel 4";
				break;
				case"N5":
					$ls_valor="Nivel 5";
				break;
			}
		}
		return $ls_valor;
	}// end function uf_select_config
   //----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_load_estructuras()
	{
		//////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_load_estructuras
		//		   Access: public
		//		 Argument: 
		//	  Description: Funcion que busca las estructuras relacionadas
		//	   Creado Por: Ing. Yesenia Moreno/ Ing. Luis Lang
		// Fecha Creacion: 29/04/2007								Fecha ltima Modificacion : 
		//////////////////////////////////////////////////////////////////////////////
		$lb_valido=true;
		$ls_sql="SELECT codestpro1,codestpro2,codestpro3,codestpro4,codestpro5,estcla,".
				"       (SELECT denestpro3 FROM spg_ep3 WHERE spg_val_estructura.codemp=spg_ep3.codemp".
				" 			AND spg_val_estructura.codestpro1=spg_ep3.codestpro1 AND spg_val_estructura.codestpro2=spg_ep3.codestpro2".
				"           AND spg_val_estructura.codestpro3=spg_ep3.codestpro3 AND spg_val_estructura.estcla=spg_ep3.estcla) AS denestpro3,".
				"       (SELECT denestpro5 FROM spg_ep5 WHERE spg_val_estructura.codemp=spg_ep5.codemp".
				" 			AND spg_val_estructura.codestpro1=spg_ep5.codestpro1 AND spg_val_estructura.codestpro2=spg_ep5.codestpro2".
				"           AND spg_val_estructura.codestpro3=spg_ep5.codestpro3 AND spg_val_estructura.codestpro4=spg_ep5.codestpro4".
				"           AND spg_val_estructura.codestpro5=spg_ep5.codestpro5 AND spg_val_estructura.estcla=spg_ep5.estcla) AS denestpro5".
				"  FROM spg_val_estructura ".	
				" WHERE spg_val_estructura.codemp='".$this->ls_codemp."' ";
		$rs_data=$this->io_sql->select($ls_sql);
		if($rs_data===false)
		{
			$this->io_msg->message("CLASE->Validacion MTODO->uf_load_estructuras ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
			return false;
		}
		return $rs_data;
	}// end function uf_load_recepciones
	//-----------------------------------------------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_guardar_estructuras($ai_totrow,$aa_seguridad)
	{		
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_guardar_estructuras
		//		   Access: public 
		//	    Arguments:ai_totrow // Total de Filas
		//				   aa_seguridad // arreglo de las variables de seguridad
		//	      Returns: lb_valido True si se ejecuto el guardar o False si hubo error en el guardar
		//	  Description: Funcion que valida y guarda la informacion
		//	   Creado Por: Ing. Yesenia Moreno /Ing. Luis Lang
		// Fecha Creacion: 26/04/2007 								Fecha ltima Modificacion : 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valido=false;
		$this->io_sql->begin_transaction();				
		$lb_valido=$this->uf_delete_validacion();
		if($lb_valido)
		{
			for ($li_i=1;$li_i<$ai_totrow;$li_i++)
			{
				$ls_codestpro1=str_pad($_POST["txtcodestpro1".$li_i],25,"0", STR_PAD_LEFT);
				$ls_codestpro2=str_pad($_POST["txtcodestpro2".$li_i],25,"0", STR_PAD_LEFT);
				$ls_codestpro3=str_pad($_POST["txtcodestpro3".$li_i],25,"0", STR_PAD_LEFT);
				$ls_codestpro4=str_pad($_POST["txtcodestpro4".$li_i],25,"0", STR_PAD_LEFT);
				$ls_codestpro5=str_pad($_POST["txtcodestpro5".$li_i],25,"0", STR_PAD_LEFT);
				$ls_estcla=$_POST["txtestcla".$li_i];
				
				$lb_valido=$this->uf_insert_validacion($ls_codestpro1,$ls_codestpro2,$ls_codestpro3,$ls_codestpro4,$ls_codestpro5,
													  $ls_estcla);
				if($lb_valido==false)
				break;
				else
				{
					/////////////////////////////////         SEGURIDAD               /////////////////////////////		
					$ls_evento="INSERT";
					$ls_descripcion ="Inserto una validacion a la estructura ".$ls_codestpro1.$ls_codestpro2.$ls_codestpro3.$ls_codestpro4.$ls_codestpro5.$ls_estcla.
									 " Asociado a la empresa ".$this->ls_codemp;
				/*	$lb_valido= $this->seguridad->uf_sss_insert_eventos_ventana($aa_seguridad["empresa"],
													$aa_seguridad["sistema"],$ls_evento,$aa_seguridad["logusr"],
													$aa_seguridad["ventanas"],$ls_descripcion);*/
					/////////////////////////////////         SEGURIDAD               /////////////////////////////	
				}
			}
		}
		if($lb_valido)
		{	
			$this->io_sql->commit();
		}
		else
		{
			$this->io_sql->rollback();
		}
		return $lb_valido;
	}// end function uf_guardar
	//-----------------------------------------------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_delete_validacion()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_delete_validacion
		//		   Access: private
		//	    Arguments: 
		//	      Returns: lb_valido True si se ejecuto el insert o False si hubo error en el insert
		//	  Description: Funcion que elimina los detalles 
		//	   Creado Por: Ing. Yesenia Moreno/ Ing. Luis Lang
		// Fecha Creacion: 30/04/2007 								Fecha ltima Modificacion : 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valido=true;
		$ls_sql="DELETE FROM spg_val_estructura ".
				" WHERE codemp = '".$this->ls_codemp."'";
		$li_row=$this->io_sql->execute($ls_sql);
		if($li_row===false)
		{
			$lb_valido=false;
			$this->io_msg->message("CLASE->Validacion MTODO->uf_delete_validacion ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
		}
		return $lb_valido;
	}// end function uf_delete_detalles
	//-----------------------------------------------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_insert_validacion($as_codestpro1,$as_codestpro2,$as_codestpro3,$as_codestpro4,$as_codestpro5,$as_estcla)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_insert_validacion
		//		   Access: private
		//	    Arguments: 
		//	      Returns: lb_valido True si se ejecuto el insert o False si hubo error en el insert
		//	  Description: Funcion que inserta las estructutas a validar
		//	   Creado Por: Ing. Yesenia Moreno/ Ing. Luis Lang
		// Fecha Creacion: 25/04/2007 								Fecha ltima Modificacion : 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valido=true;
		$ls_sql="INSERT INTO spg_val_estructura (codemp, codestpro1,codestpro2,codestpro3,codestpro4,codestpro5,estcla)".
				"	  VALUES ('".$this->ls_codemp."','".$as_codestpro1."','".$as_codestpro2."',".
				" 			  '".$as_codestpro3."','".$as_codestpro4."','".$as_codestpro5."','".$as_estcla."')";
		$li_row=$this->io_sql->execute($ls_sql);
		if($li_row===false)
		{
			$lb_valido=false;
			$this->io_msg->message("CLASE->Validacion MTODO->uf_insert_validacion ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
		}
		return $lb_valido;
	}// end function uf_insert_historico_recepciones
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_load_estructuras_nivel($as_valcodestpro1,$as_valcodestpro2,$as_valcodestpro3,$as_valcodestpro4,
									   $as_valcodestpro5,$as_valestcla)
	{
		//////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_load_estructuras_nivel
		//		   Access: public
		//		 Argument: 
		//	  Description: Funcion que busca las estructuras relacionadas
		//	   Creado Por: Ing. Yesenia Moreno/ Ing. Luis Lang
		// Fecha Creacion: 29/04/2007								Fecha ltima Modificacion : 
		//////////////////////////////////////////////////////////////////////////////
		$lb_valido=true;
		$ls_nivvalest=$_SESSION["la_empresa"]["nivvalest"];
		$ls_criterio="";
		$as_valcodestpro1=str_pad($as_valcodestpro1,25,"0", STR_PAD_LEFT);
		$as_valcodestpro2=str_pad($as_valcodestpro2,25,"0", STR_PAD_LEFT);
		$as_valcodestpro3=str_pad($as_valcodestpro3,25,"0", STR_PAD_LEFT);
		$as_valcodestpro4=str_pad($as_valcodestpro4,25,"0", STR_PAD_LEFT);
		$as_valcodestpro5=str_pad($as_valcodestpro5,25,"0", STR_PAD_LEFT);
		switch ($_SESSION["ls_gestor"])
		{
			case "MYSQLT":
				$ls_cadena="CONCAT(codestpro1,codestpro2,codestpro3,codestpro4,codestpro5,estcla)";
				break;
			case "MYSQLI":
				$ls_cadena="CONCAT(codestpro1,codestpro2,codestpro3,codestpro4,codestpro5,estcla)";
				break;
			case "POSTGRES":
				$ls_cadena="codestpro1||codestpro2||codestpro3||codestpro4||codestpro5||estcla";
				break;
		}
		switch ($ls_nivvalest)
		{
			case "N1":
				$ls_criterio="AND codestpro1='".$as_valcodestpro1."'";
			break;
			case "N2":
				$ls_criterio="AND codestpro1='".$as_valcodestpro1."' AND codestpro2='".$as_valcodestpro2."'";
			break;
			case "N3":
				$ls_criterio="AND codestpro1='".$as_valcodestpro1."' AND codestpro2='".$as_valcodestpro2."' AND codestpro3='".$as_valcodestpro3."'";
			break;
			case "N4":
				$ls_criterio="AND codestpro1='".$as_valcodestpro1."' AND codestpro2='".$as_valcodestpro2."' AND codestpro3='".$as_valcodestpro3."' AND codestpro4='".$as_valcodestpro4."'";
			break;
			case "N5":
				$ls_criterio="AND codestpro1='".$as_valcodestpro1."' AND codestpro2='".$as_valcodestpro2."' AND codestpro3='".$as_valcodestpro3."' AND codestpro4='".$as_valcodestpro4."' AND codestpro5='".$as_valcodestpro5."'";
			break;
		}
		
		$ls_sql="SELECT codestpro1,codestpro2,codestpro3,codestpro4,codestpro5,estcla, denestpro5,".
				"       (SELECT denestpro3 FROM spg_ep3 WHERE spg_ep5.codemp=spg_ep3.codemp".
				" 			AND spg_ep5.codestpro1=spg_ep3.codestpro1 AND spg_ep5.codestpro2=spg_ep3.codestpro2".
				"           AND spg_ep5.codestpro3=spg_ep3.codestpro3 AND spg_ep5.estcla=spg_ep3.estcla) AS denestpro3".
				"  FROM spg_ep5 ".	
				" WHERE spg_ep5.codemp='".$this->ls_codemp."'".
				//" AND spg_ep5.estcla='".$as_valestcla."'".
				$ls_criterio.
				"   AND $ls_cadena NOT IN (SELECT $ls_cadena FROM spg_ep5 WHERE codestpro1='".$as_valcodestpro1."' ".
				"							  AND codestpro2='".$as_valcodestpro2."' AND codestpro3='".$as_valcodestpro3."'".
				"                             AND codestpro4='".$as_valcodestpro4."' AND codestpro5='".$as_valcodestpro5."')";
		$rs_data=$this->io_sql->select($ls_sql);
		if($rs_data===false)
		{
			$this->io_msg->message("CLASE->Validacion MTODO->uf_load_estructuras_nivel ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
			return false;
		}
		return $rs_data;
	}// end function uf_load_recepciones
	//-----------------------------------------------------------------------------------------------------------------------------------
		
}
?>