<?php 
class sigesp_cxp_c_otroscreditos
{
var $ls_sql;
var $is_msg_error;
	
		function sigesp_cxp_c_otroscreditos($conn)
		{
		  require_once("../../shared/class_folder/sigesp_c_seguridad.php");
          require_once("../../shared/class_folder/class_funciones.php");
		  require_once("../../shared/class_folder/class_mensajes.php");
		  require_once("../../shared/class_folder/sigesp_c_check_relaciones.php"); 
	      $this->seguridad  = new sigesp_c_seguridad();	
		  $this->io_funcion = new class_funciones();
		  $this->io_sql     = new class_sql($conn);//$conn->debug=true;
		  $this->io_msg     = new class_mensajes($conn);
		  $this->io_chek    = new sigesp_c_check_relaciones($conn);
		  $this->ls_gestor  = strtoupper($_SESSION["ls_gestor"]);
		}

function uf_insert_otroscreditos($as_codemp,$ar_datos,$ai_estmodest,$aa_seguridad,$as_estcla) 
{
//////////////////////////////////////////////////////////////////////////////
//	Metodo: uf_insert_otroscreditos
//	Access:  public
//	Arguments:  $as_codemp,$ar_datos,$aa_seguridad
//	Returns: $lb_valido= Variable booleana que devuelve true si la sentencia
//                       SQL fue ejecutada sin errores de lo contrario devuelve false.
//	Description: Funcion que se encarga de insertar un registro en la tabla
//              sigesp_cargos.     
//////////////////////////////////////////////////////////////////////////////

	$ls_codigo       = $ar_datos["codigo"];
	$ls_denominacion = $ar_datos["denominacion"];
	$ls_spgcuenta    = $ar_datos["spg_cuenta"];
	$ls_codestpro    = $ar_datos["codestpro"];
	$ls_codestpro1   = $ar_datos["codestpro1"];
	$ls_codestpro2   = $ar_datos["codestpro2"];
	$ls_codestpro3   = $ar_datos["codestpro3"];
	$ls_codestpro4   = $ar_datos["codestpro4"];
	$ls_codestpro5   = $ar_datos["codestpro5"];
	$ls_tipo_iva	 = $ar_datos["tipo_iva"];
	
		 $ls_codestpro  = $ls_codestpro1.$ls_codestpro2.$ls_codestpro3.$ls_codestpro4.$ls_codestpro5;
		
	
	$ld_porcentaje = $ar_datos["porcentaje"];
	if (empty($ld_porcentaje))
	   {
	     $ld_porcentaje=0;
	   }
	else
	   {
	     $ld_porcentaje = str_replace('.','',$ld_porcentaje);
 	     $ld_porcentaje = str_replace(',','.',$ld_porcentaje);
	   }
	if (empty($ls_tipo_iva))
	{
		$ls_tipo_iva=0;
	}   
	$li_estlibcompras   = $ar_datos["estlibcompras"];
	$ls_formula         = $ar_datos["formula"];
	$li_estpagele = $ar_datos["estpagele"];	
	$ls_sql             = " INSERT INTO sigesp_cargos                                                                         ".
			              " (codemp,codcar,dencar,codestpro,spg_cuenta,porcar,estlibcom,formula,estcla,tipo_iva,estpagele)                              ".
			              " VALUES                                                                                            ".
			              " ('".$as_codemp."','".$ls_codigo."','".$ls_denominacion."','".$ls_codestpro."','".$ls_spgcuenta."',".
			              " ".$ld_porcentaje.",".$li_estlibcompras.",'".$ls_formula."','".$as_estcla."',".$ls_tipo_iva.",'".$li_estpagele."') "; 
	$this->io_sql->begin_transaction();
	$li_numrows=$this->io_sql->execute($ls_sql);
	if ($li_numrows===false)
	   {
		 $this->io_msg->message("CLASE->SIGESP_CXP_C_OTROSCREDITOS; METODO->uf_insert_otroscreditos; ERROR->".$this->io_funcion->uf_convertirmsg($this->io_sql->message));
		 $lb_valido=false;
	   }
	else
	   {
	     /////////////////////////////////         SEGURIDAD               /////////////////////////////		
	     $ls_evento="INSERT";
	     $ls_descripcion ="Inserto en CXP el Cargo ".$ls_denominacion." con Codigo ".$ls_codigo;
	     $ls_variable= $this->seguridad->uf_sss_insert_eventos_ventana($aa_seguridad["empresa"],
	     $aa_seguridad["sistema"],$ls_evento,$aa_seguridad["logusr"],
	     $aa_seguridad["ventanas"],$ls_descripcion);
	     /////////////////////////////////         SEGURIDAD               ///////////////////////////
		 $lb_valido=true;
	   }
return $lb_valido;
}

function uf_update_otroscreditos($as_codemp,$ar_datos,$ai_estmodest,$aa_seguridad,$as_estcla) 
{
//////////////////////////////////////////////////////////////////////////////
//	     Metodo:  uf_update_otroscreditos
//	     Access:  public
//	  Arguments:  $as_codemp,$ar_datos,$aa_seguridad
//	    Returns:  $lb_valido= Variable booleana que devuelve true si la sentencia
//                SQL fue ejecutada sin errores de lo contrario devuelve false.
//	Description:  Funcion que se encarga de actualizar registros en la tabla
//                sigesp_cargos.   
//////////////////////////////////////////////////////////////////////////////
	$ls_codigo       = $ar_datos["codigo"];
	$ls_denominacion = $ar_datos["denominacion"];
	$ls_spgcuenta    = $ar_datos["spg_cuenta"];
	$ls_codestpro    = $ar_datos["codestpro"];
	$ls_codestpro1   = $ar_datos["codestpro1"];
	$ls_codestpro2   = $ar_datos["codestpro2"];
	$ls_codestpro3   = $ar_datos["codestpro3"];
	$ls_codestpro4   = $ar_datos["codestpro4"];
	$ls_codestpro5   = $ar_datos["codestpro5"];
	$ls_tipo_iva	 = $ar_datos["tipo_iva"];
	$ls_codestpro  = $ls_codestpro1.$ls_codestpro2.$ls_codestpro3.$ls_codestpro4.$ls_codestpro5;
	
	$ld_porcentaje    = $ar_datos["porcentaje"];
	$li_estlibcompras = $ar_datos["estlibcompras"];	
	$li_estpagele = $ar_datos["estpagele"];	
	$ls_formula       = $ar_datos["formula"];
	$ls_sql=" UPDATE sigesp_cargos ".
			" SET  dencar='".$ls_denominacion."',codestpro='".$ls_codestpro."',spg_cuenta='".$ls_spgcuenta."',estpagele='".$li_estpagele."',".
			" porcar=".$ld_porcentaje.",estlibcom=".$li_estlibcompras.",formula='".$ls_formula."', estcla='".$as_estcla."', tipo_iva=$ls_tipo_iva  ".
			" WHERE codemp='" .$as_codemp. "' AND codcar = '" .$ls_codigo. "'";
	$this->io_sql->begin_transaction();
	$li_numrows=$this->io_sql->execute($ls_sql);
	if ($li_numrows===false)
	   {
		 $this->io_msg->message("CLASE->SIGESP_CXP_C_OTROSCREDITOS; METODO->uf_update_otroscreditos; ERROR->".$this->io_funcion->uf_convertirmsg($this->io_sql->message));
		 $lb_valido=false;
	   }
	else
	   {
		 /////////////////////////////////         SEGURIDAD               /////////////////////////////		
	  	 $ls_evento="UPDATE";
		 $ls_descripcion ="Actualizo en CXP el Cargo con Codigo ".$ls_codigo;
	     $ls_variable= $this->seguridad->uf_sss_insert_eventos_ventana($aa_seguridad["empresa"],
		 $aa_seguridad["sistema"],$ls_evento,$aa_seguridad["logusr"],
		 $aa_seguridad["ventanas"],$ls_descripcion);
		 /////////////////////////////////         SEGURIDAD               ///////////////////////////
		 $lb_valido=true;
	   }
return $lb_valido;
} 

function uf_delete_otroscreditos($as_codemp,$as_codigo,$as_dencar,$aa_seguridad)
{
//////////////////////////////////////////////////////////////////////////////
//	Metodo: uf_delete_otroscreditos
//	Access:  public
//	Arguments:  $as_codemp,$ar_datos,$aa_seguridad
//	Returns: $lb_valido= Variable booleana que devuelve true si la sentencia
//                       SQL fue ejecutada sin errores de lo contrario devuelve false.
//	Description: Funcion que se encarga de Eliminar registros en la tabla 
//               sigesp_cargos.
//////////////////////////////////////////////////////////////////////////////
  
	$lb_valido = false;
	switch ($this->ls_gestor) 
	{
		case 'INFORMIX':
			$as_condicion = " AND (colname='codcar')";
			break;
	
		case 'POSTGRES':
			$as_condicion = " AND (column_name='codcar')";
			break;
			
		case 'MYSQLT':
			$as_condicion = " AND (column_name='codcar')";
			break;
			
		case 'MYSQLI':
			$as_condicion = " AND (column_name='codcar')";
			break;
			
		case 'OCI8PO':
			$as_condicion = " AND (column_name='codcar')";
			break;
	}
	//Nombre del o los campos que deseamos buscar.
	$as_mensaje   = "";                           //Mensaje que será enviado al usuario si se encuentran relaciones a asociadas al campo.
	$lb_tiene     = $this->io_chek->uf_check_relaciones($as_codemp,$as_condicion,'sigesp_cargos',$as_codigo,$as_mensaje);//Verifica los movimientos asociados a la cuenta  
	if (!$lb_tiene)
	{
		  	  $ls_sql    = "DELETE FROM sigesp_cargos WHERE codemp='".$as_codemp."' AND codcar='".$as_codigo."'";	   
			  $this->io_sql->begin_transaction();
			  $rs_data = $this->io_sql->execute($ls_sql);
			  if ($rs_data===false)
		      {
		     	$this->io_msg->message("CLASE->SIGESP_CXP_C_OTROSCREDITOS; METODO->uf_delete_otroscreditos; ERROR->".$this->io_funcion->uf_convertirmsg($this->io_sql->message));
			   $lb_valido=false;
			  }
		      else
		      {
			   /////////////////////////////////         SEGURIDAD               /////////////////////////////		
			   $ls_evento="DELETE";
			   $ls_descripcion =" Elimino en CXP el Cargo con Codigo ".$as_codigo." con Denominacion ".$as_dencar;
			   $ls_variable= $this->seguridad->uf_sss_insert_eventos_ventana($aa_seguridad["empresa"],
			   $aa_seguridad["sistema"],$ls_evento,$aa_seguridad["logusr"],
			   $aa_seguridad["ventanas"],$ls_descripcion);
			   /////////////////////////////////         SEGURIDAD               ///////////////////////////
			   $lb_valido=true;
		  	  }	   
		  	
	}
	else
	{
	   $this->io_msg->message($this->io_chek->is_msg_error);
	}	 
  
  return $lb_valido;
}


function uf_select_otroscreditos($as_codemp,$as_codigo) 
{
//////////////////////////////////////////////////////////////////////////////
//	     Metodo:  uf_select_otroscreditos
// 	     Access:  public
//	   Arguments  $as_codemp,$as_codigo
//	    Returns:  $lb_valido= Variable booleana que devuelve true si la fue
//                encontrado el registro y la sentencia SQL 
//                fue ejecutada sin errores de lo contrario devuelve false.	
//	Description:  Funcion que se encarga de buscar registros en la tabla
//                sigesp_cargos.
//////////////////////////////////////////////////////////////////////////////
	$ls_sql=" SELECT * FROM sigesp_cargos WHERE codemp='".$as_codemp."' AND codcar='".$as_codigo."'";
	$rs_otroscred=$this->io_sql->select($ls_sql);
	if ($rs_otroscred===false)
	   {
		 $this->io_msg->message("CLASE->SIGESP_CXP_C_OTROSCREDITOS; METODO->uf_select_otroscreditos; ERROR->".$this->io_funcion->uf_convertirmsg($this->io_sql->message));
		 $lb_valido=false;
	   }
	else
	   {
	     $li_numrows=$this->io_sql->num_rows($rs_otroscred);
		 if ($li_numrows>0)
			{
			  $lb_valido=true;
			  $this->io_sql->free_result($rs_otroscred);
			}
		 else
			{
			  $lb_valido=false;
			}
		}
return $lb_valido;
}
//-------------------------------------------------------------------------------------------------------------------------------------
function uf_select_configuracion_iva($as_codemp,$as_confiva) 
{
	//////////////////////////////////////////////////////////////////////////////
	//	     Metodo:  uf_select_configuracion_iva
	// 	     Access:  public
	//	   Arguments  $as_codemp,$as_codigo
	//	    Returns:  $lb_valido= Variable que devuelve la configuraciondel iva si es contable
	//                o presupuestario.	
	//	Description:  Funcion que se encarga de buscar registros en la tabla
	//                sigesp_cargos.
	//////////////////////////////////////////////////////////////////////////////
    $lb_valido=false;
	$ls_sql=" SELECT * FROM sigesp_empresa WHERE codemp='".$as_codemp."'";
	$rs_data=$this->io_sql->select($ls_sql);
	if ($rs_data===false)
	{
	   $this->io_msg->message("CLASE->SIGESP_CXP_C_OTROSCREDITOS; METODO->uf_select_configuracion_iva; ERROR->".$this->io_funcion->uf_convertirmsg($this->io_sql->message));
	   $lb_valido=false;
	}
	else
	{
	  /* $li_numrows=$this->io_sql->num_rows($rs_data);
	   if ($li_numrows>0)*/
	   while($row=$this->io_sql->fetch_row($rs_data))
	   {
		  $lb_valido=true;
		  $as_confiva=$row["confiva"];
	   }
	   $this->io_sql->free_result($rs_data);
	}
	$arrResultado['as_confiva']=$as_confiva;
	$arrResultado['lb_valido']=$lb_valido;
	return $arrResultado;		
}

function uf_asociar_articulos_cargos($as_codemp,$as_codigo)
{
		//////////////////////////////////////////////////////////////////////////////
		//	Function: uf_asociar_articulos_cargos
		//	 Access: public
		//	 Argument: $as_codemp // Codigo de empresa
		//             $as_codigo // Codigo del Cargo
		//  Description: Funcion que Verifica si un cargo existe y es de tipo Pago Electronico
		//	Creado Por: Ing. Yesenia Moreno / Ing. Luis Anibal Lang
		//  Fecha Creacion: 10/10/2017								Fecha Última Modificacion : 
		//////////////////////////////////////////////////////////////////////////////
		$lb_valido=true;
		$lb_existe=$this->uf_select_pagoelectronico($as_codemp,$as_codigo);
		if($lb_existe)
		{
			$this->io_sql->begin_transaction();
			$la_articulos=$this->uf_select_articulos($as_codemp);
			if ($la_articulos<>'')
			{
				$li_totart=count($la_articulos);
				for($li_i=1;$li_i<=$li_totart;$li_i++)
				{
					$ls_codart=$la_articulos[$li_i];
					$lb_existe=$this->uf_select_cargosarticulos($as_codemp,$as_codigo,$ls_codart);
					if(!$lb_existe)
					{
						$lb_valido=$this->uf_reasignar_cargo($as_codemp,$as_codigo,$ls_codart);
						if($lb_valido==false)
						{break;}
					}
				}
				if($lb_valido)
				{
					$this->io_sql->commit();
				}
				else
				{
					$this->io_sql->rollback();
				}
			}
			else
			{
				$this->io_msg->message("No hay cargo que asignar.");
			}			
		}
		else
		{
			$this->io_msg->message("El cargo no existe o no es de tipo Pago Electronico");
		}
		return $lb_valido;

}

function uf_select_pagoelectronico($as_codemp,$as_codigo) 
{
		//////////////////////////////////////////////////////////////////////////////
		//	Function: uf_select_pagoelectronico
		//	 Access: public
		//	 Argument: $as_codemp // Codigo de empresa
		//             $as_codigo // Codigo del Cargo
		//  Description: Funcion que Verifica si un cargo existe y es de tipo Pago Electronico
		//	Creado Por: Ing. Yesenia Moreno / Ing. Luis Anibal Lang
		//  Fecha Creacion: 10/10/2017								Fecha Última Modificacion : 
		//////////////////////////////////////////////////////////////////////////////
	$lb_valido=false;
	$ls_sql="SELECT estpagele".
			"  FROM sigesp_cargos".
			" WHERE codemp='".$as_codemp."'".
			"   AND codcar='".$as_codigo."'";
	$rs_data=$this->io_sql->select($ls_sql);
	if ($rs_otroscred===false)
	{
		$this->io_msg->message("CLASE->SIGESP_CXP_C_OTROSCREDITOS; METODO->uf_select_pagoelectronico; ERROR->".$this->io_funcion->uf_convertirmsg($this->io_sql->message));
		$lb_valido=false;
	}
	else
	{
		if($row=$this->io_sql->fetch_row($rs_data))
		{
			$ls_estpagele=$row["estpagele"];
			if(($ls_estpagele=="2")||($ls_estpagele=="3"))
			{
				$lb_valido=true;
			}
		}
	}
return $lb_valido;
}

function uf_select_articulos($as_codemp) 
{
		//////////////////////////////////////////////////////////////////////////////
		//	Function: uf_select_articulos
		//	 Access: public
		//	 Argument: $as_codemp // Codigo de empresa
		//             $as_codigo // Codigo del Cargo
		//  Description: Funcion que Busca los Articulos que Tienen asociado un Cargo de Pago convencional
		//	Creado Por: Ing. Yesenia Moreno / Ing. Luis Anibal Lang
		//  Fecha Creacion: 10/10/2017								Fecha Última Modificacion : 
		//////////////////////////////////////////////////////////////////////////////
	$la_codart="";
	$ls_sql="SELECT codart".
			"  FROM siv_cargosarticulo,sigesp_cargos".
			" WHERE sigesp_cargos.codemp='".$as_codemp."'".
			"   AND sigesp_cargos.estpagele='1'".
			"   AND (sigesp_cargos.porcar=12 OR sigesp_cargos.porcar=0.12) ".
			"   AND siv_cargosarticulo.codemp=sigesp_cargos.codemp".
			"   AND siv_cargosarticulo.codcar=sigesp_cargos.codcar";
	$rs_data=$this->io_sql->select($ls_sql);
	if ($rs_data===false)
	{
		$this->io_msg->message("CLASE->SIGESP_CXP_C_OTROSCREDITOS; METODO->uf_select_articulos; ERROR->".$this->io_funcion->uf_convertirmsg($this->io_sql->message));
		$lb_valido=false;
	}
	else
	{
		$li_i=0;
		while($row=$this->io_sql->fetch_row($rs_data))
		{
			$li_i++;
			$la_codart[$li_i]=$row["codart"];
		}
	}
	return $la_codart;
}

function uf_select_cargosarticulos($as_codemp,$ls_codcar,$ls_codart) 
{
		//////////////////////////////////////////////////////////////////////////////
		//	Function: uf_select_cargosarticulos
		//	 Access: public
		//	 Argument: $as_codemp // Codigo de empresa
		//             $as_codigo // Codigo del Cargo
		//  Description: Funcion que Busca los Articulos que Tienen asociado un Cargo de Pago convencional
		//	Creado Por: Ing. Yesenia Moreno / Ing. Luis Anibal Lang
		//  Fecha Creacion: 10/10/2017								Fecha Última Modificacion : 
		//////////////////////////////////////////////////////////////////////////////
	$lb_existe=false;
	$ls_sql="SELECT codart".
			"  FROM siv_cargosarticulo".
			" WHERE siv_cargosarticulo.codemp='".$as_codemp."'".
			"   AND siv_cargosarticulo.codart='".$ls_codart."'".
			"   AND siv_cargosarticulo.codcar='".$ls_codcar."'";
	$rs_data=$this->io_sql->select($ls_sql);
	if ($rs_data===false)
	{
		$this->io_msg->message("CLASE->SIGESP_CXP_C_OTROSCREDITOS; METODO->uf_select_cargosarticulos; ERROR->".$this->io_funcion->uf_convertirmsg($this->io_sql->message));
		$lb_existe=false;
	}
	else
	{
		$li_i=0;
		if($row=$this->io_sql->fetch_row($rs_data))
		{
			$lb_existe=true;
		}
	}
	return $lb_existe;
}

function uf_reasignar_cargo($as_codemp,$ls_codcar,$ls_codart) 
{
	//////////////////////////////////////////////////////////////////////////////
	//	Function: uf_reasignar_cargo
	//	 Access: public
	//	 Argument: $as_codemp // Codigo de empresa
	//             $as_codigo // Codigo del Cargo
	//  Description: Funcion que Busca los Articulos que Tienen asociado un Cargo de Pago convencional
	//	Creado Por: Ing. Yesenia Moreno / Ing. Luis Anibal Lang
	//  Fecha Creacion: 10/10/2017								Fecha Última Modificacion : 
	//////////////////////////////////////////////////////////////////////////////
	$lb_valido=false;
	$ls_sql=" INSERT INTO siv_cargosarticulo (codemp,codcar,codart)".
			" VALUES ('".$as_codemp."','".$ls_codcar."','".$ls_codart."') ";
	$li_numrows=$this->io_sql->execute($ls_sql);
	if ($li_numrows===false)
	{
		$this->io_msg->message("CLASE->SIGESP_CXP_C_OTROSCREDITOS; METODO->uf_reasignar_cargo; ERROR->".$this->io_funcion->uf_convertirmsg($this->io_sql->message));
		$lb_valido=false;
	}
	else
	{
		$lb_valido=true;
	}
	return $lb_valido;
}

function uf_asociar_servicios_cargos($as_codemp,$as_codigo)
{
		//////////////////////////////////////////////////////////////////////////////
		//	Function: uf_asociar_servicios_cargos
		//	 Access: public
		//	 Argument: $as_codemp // Codigo de empresa
		//             $as_codigo // Codigo del Cargo
		//  Description: Funcion que Verifica si un cargo existe y es de tipo Pago Electronico
		//	Creado Por: Ing. Yesenia Moreno / Ing. Luis Anibal Lang
		//  Fecha Creacion: 10/10/2017								Fecha Última Modificacion : 
		//////////////////////////////////////////////////////////////////////////////
		$lb_valido=true;
		$lb_existe=$this->uf_select_pagoelectronico($as_codemp,$as_codigo);
		if($lb_existe)
		{
			$this->io_sql->begin_transaction();
			$la_servicios=$this->uf_select_servicios($as_codemp);
			if ($la_servicios<>'')
			{
				$li_totser=count($la_servicios);
				for($li_i=1;$li_i<=$li_totser;$li_i++)
				{
					$ls_codser=$la_servicios[$li_i];
					$lb_existe=$this->uf_select_cargosservicios($as_codemp,$as_codigo,$ls_codser);
					if(!$lb_existe)
					{
						$lb_valido=$this->uf_reasignar_cargo_servicios($as_codemp,$as_codigo,$ls_codser);
						if($lb_valido==false)
						{break;}
					}
				}
				if($lb_valido)
				{
					$this->io_sql->commit();
				}
				else
				{
					$this->io_sql->rollback();
				}
			}
			
		}
		else
		{
			$this->io_msg->message("El cargo no existe o no es de tipo Pago Electronico");
		}
		return $lb_valido;

}

function uf_select_servicios($as_codemp) 
{
		//////////////////////////////////////////////////////////////////////////////
		//	Function: uf_select_servicios
		//	 Access: public
		//	 Argument: $as_codemp // Codigo de empresa
		//             $as_codigo // Codigo del Cargo
		//  Description: Funcion que Busca los Servicios que Tienen asociado un Cargo de Pago convencional
		//	Creado Por: Ing. Yesenia Moreno / Ing. Luis Anibal Lang
		//  Fecha Creacion: 10/10/2017								Fecha Última Modificacion : 
		//////////////////////////////////////////////////////////////////////////////
	$la_servicios="";
	$ls_sql="SELECT codser".
			"  FROM soc_serviciocargo,sigesp_cargos".
			" WHERE sigesp_cargos.codemp='".$as_codemp."'".
			"   AND sigesp_cargos.estpagele='1'".
			"   AND (sigesp_cargos.porcar=12 OR sigesp_cargos.porcar=0.12) ".
			"   AND soc_serviciocargo.codemp = sigesp_cargos.codemp".
			"   AND soc_serviciocargo.codcar = sigesp_cargos.codcar";
	$rs_data=$this->io_sql->select($ls_sql);
	if ($rs_data===false)
	{
		$this->io_msg->message("CLASE->SIGESP_CXP_C_OTROSCREDITOS; METODO->uf_select_servicios; ERROR->".$this->io_funcion->uf_convertirmsg($this->io_sql->message));
		$lb_valido=false;
	}
	else
	{
		$li_i=0;
		while($row=$this->io_sql->fetch_row($rs_data))
		{
			$li_i++;
			$la_servicios[$li_i]=$row["codser"];
		}
	}
	return $la_servicios;
}

function uf_select_cargosservicios($as_codemp,$ls_codcar,$ls_codser) 
{
		//////////////////////////////////////////////////////////////////////////////
		//	Function: uf_select_cargosarticulos
		//	 Access: public
		//	 Argument: $as_codemp // Codigo de empresa
		//             $as_codigo // Codigo del Cargo
		//  Description: Funcion que Busca los Servicios que Tienen asociado un Cargo de Pago convencional
		//	Creado Por: Ing. Yesenia Moreno / Ing. Luis Anibal Lang
		//  Fecha Creacion: 10/10/2017								Fecha Última Modificacion : 
		//////////////////////////////////////////////////////////////////////////////
	$lb_existe=false;
	$ls_sql="SELECT codser".
			"  FROM soc_serviciocargo".
			" WHERE soc_serviciocargo.codemp='".$as_codemp."'".
			"   AND soc_serviciocargo.codser='".$ls_codser."'".
			"   AND soc_serviciocargo.codcar='".$ls_codcar."'";
	$rs_data=$this->io_sql->select($ls_sql);
	if ($rs_data===false)
	{
		$this->io_msg->message("CLASE->SIGESP_CXP_C_OTROSCREDITOS; METODO->uf_select_cargosservicios; ERROR->".$this->io_funcion->uf_convertirmsg($this->io_sql->message));
		$lb_existe=false;
	}
	else
	{
		$li_i=0;
		if($row=$this->io_sql->fetch_row($rs_data))
		{
			$lb_existe=true;
		}
	}
	return $lb_existe;
}

function uf_reasignar_cargo_servicios($as_codemp,$ls_codcar,$ls_codser) 
{
	//////////////////////////////////////////////////////////////////////////////
	//	Function: uf_reasignar_cargo_servicios
	//	 Access: public
	//	 Argument: $as_codemp // Codigo de empresa
	//             $as_codigo // Codigo del Cargo
	//  Description: Funcion que Busca los Articulos que Tienen asociado un Cargo de Pago convencional
	//	Creado Por: Ing. Yesenia Moreno / Ing. Luis Anibal Lang
	//  Fecha Creacion: 10/10/2017								Fecha Última Modificacion : 
	//////////////////////////////////////////////////////////////////////////////
	$lb_valido=false;
	$ls_sql=" INSERT INTO soc_serviciocargo (codemp,codcar,codser)".
			" VALUES ('".$as_codemp."','".$ls_codcar."','".$ls_codser."') ";
	$li_numrows=$this->io_sql->execute($ls_sql);
	if ($li_numrows===false)
	{
		$this->io_msg->message("CLASE->SIGESP_CXP_C_OTROSCREDITOS; METODO->uf_reasignar_cargo_servicios; ERROR->".$this->io_funcion->uf_convertirmsg($this->io_sql->message));
		$lb_valido=false;
	}
	else
	{
		$lb_valido=true;
	}
	return $lb_valido;
}

function uf_asociar_conceptos_cargos($as_codemp,$as_codigo)
{
		//////////////////////////////////////////////////////////////////////////////
		//	Function: uf_asociar_conceptos_cargos
		//	 Access: public
		//	 Argument: $as_codemp // Codigo de empresa
		//             $as_codigo // Codigo del Cargo
		//  Description: Funcion que Verifica si un cargo existe y es de tipo Pago Electronico
		//	Creado Por: Ing. Yesenia Moreno / Ing. Luis Anibal Lang
		//  Fecha Creacion: 10/10/2017								Fecha Última Modificacion : 
		//////////////////////////////////////////////////////////////////////////////
		$lb_valido=true;
		$lb_existe=$this->uf_select_pagoelectronico($as_codemp,$as_codigo);
		if($lb_existe)
		{
			$this->io_sql->begin_transaction();
			$la_conceptos=$this->uf_select_conceptos($as_codemp);
			if ($la_conceptos<>'')
			{
				$li_totcon=count($la_conceptos);
				for($li_i=1;$li_i<=$li_totcon;$li_i++)
				{
					$ls_codconsep=$la_conceptos[$li_i];
					$lb_existe=$this->uf_select_cargosconceptos($as_codemp,$as_codigo,$ls_codconsep);
					if(!$lb_existe)
					{
						$lb_valido=$this->uf_reasignar_cargo_conceptos($as_codemp,$as_codigo,$ls_codconsep);
						if($lb_valido==false)
						{break;}
					}
				}
				if($lb_valido)
				{
					$this->io_sql->commit();
				}
				else
				{
					$this->io_sql->rollback();
				}
			}
		}
		else
		{
			$this->io_msg->message("El cargo no existe o no es de tipo Pago Electronico");
		}
		return $lb_valido;

}

function uf_select_conceptos($as_codemp) 
{
		//////////////////////////////////////////////////////////////////////////////
		//	Function: uf_select_conceptos		//	 Access: public
		//	 Argument: $as_codemp // Codigo de empresa
		//             $as_codigo // Codigo del Cargo
		//  Description: Funcion que Busca los Conceptos que Tienen asociado un Cargo de Pago convencional
		//	Creado Por: Ing. Yesenia Moreno / Ing. Luis Anibal Lang
		//  Fecha Creacion: 10/10/2017								Fecha Última Modificacion : 
		//////////////////////////////////////////////////////////////////////////////
	$la_conceptos="";
	$ls_sql="SELECT codconsep".
			"  FROM sep_conceptocargos,sigesp_cargos".
			" WHERE sigesp_cargos.codemp='".$as_codemp."'".
			"   AND sigesp_cargos.estpagele='1'".
			"   AND (sigesp_cargos.porcar=12 OR sigesp_cargos.porcar=0.12) ".
			"   AND sep_conceptocargos.codemp = sigesp_cargos.codemp ".
			"   AND sep_conceptocargos.codcar = sigesp_cargos.codcar";
	$rs_data=$this->io_sql->select($ls_sql);
	if ($rs_data===false)
	{
		$this->io_msg->message("CLASE->SIGESP_CXP_C_OTROSCREDITOS; METODO->uf_select_conceptos; ERROR->".$this->io_funcion->uf_convertirmsg($this->io_sql->message));
		$lb_valido=false;
	}
	else
	{
		$li_i=0;
		while($row=$this->io_sql->fetch_row($rs_data))
		{
			$li_i++;
			$la_conceptos[$li_i]=$row["codconsep"];
		}
	}
	return $la_conceptos;
}

function uf_select_cargosconceptos($as_codemp,$ls_codcar,$ls_codconsep) 
{
		//////////////////////////////////////////////////////////////////////////////
		//	Function: uf_select_cargosconceptos
		//	 Access: public
		//	 Argument: $as_codemp // Codigo de empresa
		//             $as_codigo // Codigo del Cargo
		//  Description: Funcion que Busca los Servicios que Tienen asociado un Cargo de Pago convencional
		//	Creado Por: Ing. Yesenia Moreno / Ing. Luis Anibal Lang
		//  Fecha Creacion: 10/10/2017								Fecha Última Modificacion : 
		//////////////////////////////////////////////////////////////////////////////
	$lb_existe=false;
	$ls_sql="SELECT codconsep".
			"  FROM sep_conceptocargos".
			" WHERE sep_conceptocargos.codemp='".$as_codemp."'".
			"   AND sep_conceptocargos.codconsep='".$ls_codconsep."'".
			"   AND sep_conceptocargos.codcar='".$ls_codcar."'";
	$rs_data=$this->io_sql->select($ls_sql);
	if ($rs_data===false)
	{
		$this->io_msg->message("CLASE->SIGESP_CXP_C_OTROSCREDITOS; METODO->uf_select_cargosconceptos; ERROR->".$this->io_funcion->uf_convertirmsg($this->io_sql->message));
		$lb_existe=false;
	}
	else
	{
		$li_i=0;
		if($row=$this->io_sql->fetch_row($rs_data))
		{
			$lb_existe=true;
		}
	}
	return $lb_existe;
}

function uf_reasignar_cargo_conceptos($as_codemp,$ls_codcar,$ls_codconsep) 
{
	//////////////////////////////////////////////////////////////////////////////
	//	Function: uf_reasignar_cargo_conceptos
	//	 Access: public
	//	 Argument: $as_codemp // Codigo de empresa
	//             $as_codigo // Codigo del Cargo
	//  Description: Funcion que Busca los Articulos que Tienen asociado un Cargo de Pago convencional
	//	Creado Por: Ing. Yesenia Moreno / Ing. Luis Anibal Lang
	//  Fecha Creacion: 10/10/2017								Fecha Última Modificacion : 
	//////////////////////////////////////////////////////////////////////////////
	$lb_valido=false;
	$ls_sql=" INSERT INTO sep_conceptocargos (codemp,codcar,codconsep)".
			" VALUES ('".$as_codemp."','".$ls_codcar."','".$ls_codconsep."') ";
	$li_numrows=$this->io_sql->execute($ls_sql);
	if ($li_numrows===false)
	{
		$this->io_msg->message("CLASE->SIGESP_CXP_C_OTROSCREDITOS; METODO->uf_reasignar_cargo_conceptos; ERROR->".$this->io_funcion->uf_convertirmsg($this->io_sql->message));
		$lb_valido=false;
	}
	else
	{
		$lb_valido=true;
	}
	return $lb_valido;
}

//-------------------------------------------------------------------------------------------------------------------------------------
}//Fin de la Clase...
?> 